/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectDamOverTime
extends L2Effect {
    public EffectDamOverTime(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.DMG_OVER_TIME;
    }

    @Override
    public boolean onActionTime() {
        if (this.getEffected().isDead()) {
            return false;
        }
        double damage = this.calc();
        if (damage >= this.getEffected().getCurrentHp() - 1.0) {
            if (this.getSkill().isToggle()) {
                this.getEffected().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SKILL_REMOVED_DUE_LACK_HP));
                return false;
            }
            if (!this.getSkill().killByDOT()) {
                if (this.getEffected().getCurrentHp() <= 1.0) {
                    return true;
                }
                damage = this.getEffected().getCurrentHp() - 1.0;
            }
        }
        this.getEffected().reduceCurrentHpByDOT(damage, this.getEffector(), this.getSkill());
        return true;
    }
}

