/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2DecoyInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2SkillDecoy
extends L2Skill {
    private final int _npcId;
    private final int _summonTotalLifeTime;

    public L2SkillDecoy(StatsSet set) {
        super(set);
        this._npcId = set.getInteger("npcId", 0);
        this._summonTotalLifeTime = set.getInteger("summonTotalLifeTime", 20000);
    }

    @Override
    public void useSkill(L2Character caster, L2Object[] targets) {
        if (caster.isAlikeDead() || !(caster instanceof L2PcInstance)) {
            return;
        }
        if (this._npcId == 0) {
            return;
        }
        L2PcInstance activeChar = (L2PcInstance)caster;
        if (activeChar.inObserverMode()) {
            return;
        }
        if (activeChar.getPet() != null || activeChar.isMounted()) {
            return;
        }
        L2NpcTemplate DecoyTemplate = NpcTable.getInstance().getTemplate(this._npcId);
        L2DecoyInstance Decoy = new L2DecoyInstance(IdFactory.getInstance().getNextId(), DecoyTemplate, activeChar, this);
        Decoy.setCurrentHp(Decoy.getMaxHp());
        Decoy.setCurrentMp(Decoy.getMaxMp());
        Decoy.setHeading(activeChar.getHeading());
        activeChar.setDecoy(Decoy);
        Decoy.spawnMe(activeChar.getX(), activeChar.getY(), activeChar.getZ());
    }

    public final int getTotalLifeTime() {
        return this._summonTotalLifeTime;
    }
}

