/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.util.L2ObjectMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WorldObjectTree<T extends L2Object>
extends L2ObjectMap<T> {
    private final TreeMap<Integer, T> _objectMap = new TreeMap();
    private final ReentrantReadWriteLock _rwl = new ReentrantReadWriteLock();
    private final Lock _r = this._rwl.readLock();
    private final Lock _w = this._rwl.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this._r.lock();
        try {
            int n = this._objectMap.size();
            return n;
        }
        finally {
            this._r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this._r.lock();
        try {
            boolean bl = this._objectMap.isEmpty();
            return bl;
        }
        finally {
            this._r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this._w.lock();
        try {
            this._objectMap.clear();
        }
        finally {
            this._w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T obj) {
        if (obj != null) {
            this._w.lock();
            try {
                this._objectMap.put(((L2Object)obj).getObjectId(), obj);
            }
            finally {
                this._w.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(T obj) {
        if (obj != null) {
            this._w.lock();
            try {
                this._objectMap.remove(((L2Object)obj).getObjectId());
            }
            finally {
                this._w.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int id) {
        this._r.lock();
        try {
            L2Object l2Object = (L2Object)this._objectMap.get(id);
            return (T)l2Object;
        }
        finally {
            this._r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(T obj) {
        if (obj == null) {
            return false;
        }
        this._r.lock();
        try {
            boolean bl = this._objectMap.containsValue(obj);
            return bl;
        }
        finally {
            this._r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        this._r.lock();
        try {
            Iterator<T> iterator = this._objectMap.values().iterator();
            return iterator;
        }
        finally {
            this._r.unlock();
        }
    }
}

