/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.debug;

import com.mchange.v1.io.WriterUtils;
import com.mchange.v1.lang.BooleanUtils;
import com.mchange.v1.util.SetUtils;
import com.mchange.v1.util.StringTokenizerUtils;
import com.mchange.v2.cmdline.CommandLineUtils;
import com.mchange.v2.cmdline.ParsedCommandLine;
import com.mchange.v2.debug.DebugConstants;
import com.mchange.v2.io.DirectoryDescentUtils;
import com.mchange.v2.io.FileIterator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public final class DebugGen
implements DebugConstants {
    static final String[] VALID = new String[]{"codebase", "packages", "trace", "debug", "recursive", "javac", "noclobber", "classname", "skipdirs", "outputbase"};
    static final String[] REQUIRED = new String[]{"codebase", "packages", "trace", "debug"};
    static final String[] ARGS = new String[]{"codebase", "packages", "trace", "debug", "classname", "outputbase"};
    static final String EOL = System.getProperty("line.separator");
    static int trace_level;
    static boolean debug;
    static boolean recursive;
    static String classname;
    static boolean clobber;
    static Set skipDirs;

    public static final synchronized void main(String[] argv) {
        try {
            int i;
            File outputBaseDir;
            String outputbase;
            ParsedCommandLine pcl = CommandLineUtils.parse(argv, "--", VALID, REQUIRED, ARGS);
            String codebase = pcl.getSwitchArg("codebase");
            codebase = DebugGen.platify(codebase);
            if (!codebase.endsWith(File.separator)) {
                codebase = codebase + File.separator;
            }
            if ((outputbase = pcl.getSwitchArg("outputbase")) != null) {
                if (!(outputbase = DebugGen.platify(outputbase)).endsWith(File.separator)) {
                    outputbase = outputbase + File.separator;
                }
            } else {
                outputbase = codebase;
            }
            if ((outputBaseDir = new File(outputbase)).exists()) {
                if (!outputBaseDir.isDirectory()) {
                    System.exit(-1);
                } else if (!outputBaseDir.canWrite()) {
                    System.err.println("Output Base '" + outputBaseDir.getPath() + "' is not writable!");
                    System.exit(-1);
                }
            } else if (!outputBaseDir.mkdirs()) {
                System.err.println("Output Base directory '" + outputBaseDir.getPath() + "' does not exist, and could not be created!");
                System.exit(-1);
            }
            String[] packages = StringTokenizerUtils.tokenizeToArray(pcl.getSwitchArg("packages"), ", \t");
            File[] srcPkgDirs = new File[packages.length];
            int len = packages.length;
            for (int i2 = 0; i2 < len; ++i2) {
                srcPkgDirs[i2] = new File(codebase + DebugGen.sepify(packages[i2]));
            }
            trace_level = Integer.parseInt(pcl.getSwitchArg("trace"));
            debug = BooleanUtils.parseBoolean(pcl.getSwitchArg("debug"));
            classname = pcl.getSwitchArg("classname");
            if (classname == null) {
                classname = "Debug";
            }
            recursive = pcl.includesSwitch("recursive");
            clobber = !pcl.includesSwitch("noclobber");
            String skipdirStr = pcl.getSwitchArg("skipdirs");
            if (skipdirStr != null) {
                Object[] skipdirArray = StringTokenizerUtils.tokenizeToArray(skipdirStr, ", \t");
                skipDirs = SetUtils.setFromArray(skipdirArray);
            } else {
                skipDirs = new HashSet();
                skipDirs.add("CVS");
            }
            if (pcl.includesSwitch("javac")) {
                System.err.println("autorecompilation of packages not yet implemented.");
            }
            int len2 = srcPkgDirs.length;
            for (i = 0; i < len2; ++i) {
                if (recursive) {
                    if (DebugGen.recursivePrecheckPackages(codebase, srcPkgDirs[i], outputbase, outputBaseDir)) continue;
                    System.err.println("One or more of the specifies packages could not be processed. Aborting. No files have been modified.");
                    System.exit(-1);
                    continue;
                }
                if (DebugGen.precheckPackage(codebase, srcPkgDirs[i], outputbase, outputBaseDir)) continue;
                System.err.println("One or more of the specifies packages could not be processed. Aborting. No files have been modified.");
                System.exit(-1);
            }
            len2 = srcPkgDirs.length;
            for (i = 0; i < len2; ++i) {
                if (recursive) {
                    DebugGen.recursiveWriteDebugFiles(codebase, srcPkgDirs[i], outputbase, outputBaseDir);
                    continue;
                }
                DebugGen.writeDebugFile(outputbase, srcPkgDirs[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println();
            DebugGen.usage();
        }
    }

    private static void usage() {
        System.err.println("java " + DebugGen.class.getName() + " \\");
        System.err.println("\t--codebase=<directory under which packages live> \\  (no default)");
        System.err.println("\t--packages=<comma separated list of packages>    \\  (no default)");
        System.err.println("\t--debug=<true|false>                             \\  (no default)");
        System.err.println("\t--trace=<an int between 0 and 10>                \\  (no default)");
        System.err.println("\t--outputdir=<directory under which to generate>  \\  (defaults to same dir as codebase)");
        System.err.println("\t--recursive                                      \\  (no args)");
        System.err.println("\t--noclobber                                      \\  (no args)");
        System.err.println("\t--classname=<class to generate>                  \\  (defaults to Debug)");
        System.err.println("\t--skipdirs=<directories that should be skipped>  \\  (defaults to CVS)");
    }

    private static String ify(String str, char fromChar, char toChar) {
        if (fromChar == toChar) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str);
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            if (sb.charAt(i) != fromChar) continue;
            sb.setCharAt(i, toChar);
        }
        return sb.toString();
    }

    private static String platify(String str) {
        String out = DebugGen.ify(str, '/', File.separatorChar);
        out = DebugGen.ify(out, '\\', File.separatorChar);
        out = DebugGen.ify(out, ':', File.separatorChar);
        return out;
    }

    private static String dottify(String str) {
        return DebugGen.ify(str, File.separatorChar, '.');
    }

    private static String sepify(String str) {
        return DebugGen.ify(str, '.', File.separatorChar);
    }

    private static boolean recursivePrecheckPackages(String codebase, File srcPkgDir, String outputbase, File outputBaseDir) throws IOException {
        FileIterator fii = DirectoryDescentUtils.depthFirstEagerDescent(srcPkgDir);
        while (fii.hasNext()) {
            File pkgDir = fii.nextFile();
            if (!pkgDir.isDirectory() || skipDirs.contains(pkgDir.getName())) continue;
            File outputDir = DebugGen.outputDir(codebase, pkgDir, outputbase, outputBaseDir);
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                System.err.println("Required output dir: '" + outputDir + "' does not exist, and could not be created.");
                return false;
            }
            if (DebugGen.precheckOutputPackageDir(outputDir)) continue;
            return false;
        }
        return true;
    }

    private static File outputDir(String codebase, File srcPkgDir, String outputbase, File outputBaseDir) {
        if (codebase.equals(outputbase)) {
            return srcPkgDir;
        }
        String srcPath = srcPkgDir.getPath();
        if (!srcPath.startsWith(codebase)) {
            System.err.println(DebugGen.class.getName() + ": program bug. Source package path '" + srcPath + "' does not begin with codebase '" + codebase + "'.");
            System.exit(-1);
        }
        return new File(outputBaseDir, srcPath.substring(codebase.length()));
    }

    private static boolean precheckPackage(String codebase, File srcPkgDir, String outputbase, File outputBaseDir) throws IOException {
        return DebugGen.precheckOutputPackageDir(DebugGen.outputDir(codebase, srcPkgDir, outputbase, outputBaseDir));
    }

    private static boolean precheckOutputPackageDir(File dir) throws IOException {
        File outFile = new File(dir, classname + ".java");
        if (!dir.canWrite()) {
            System.err.println("File '" + outFile.getPath() + "' is not writable.");
            return false;
        }
        if (!clobber && outFile.exists()) {
            System.err.println("File '" + outFile.getPath() + "' exists, and we are in noclobber mode.");
            return false;
        }
        return true;
    }

    private static void recursiveWriteDebugFiles(String codebase, File srcPkgDir, String outputbase, File outputBaseDir) throws IOException {
        FileIterator fii = DirectoryDescentUtils.depthFirstEagerDescent(DebugGen.outputDir(codebase, srcPkgDir, outputbase, outputBaseDir));
        while (fii.hasNext()) {
            File pkgDir = fii.nextFile();
            if (!pkgDir.isDirectory() || skipDirs.contains(pkgDir.getName())) continue;
            DebugGen.writeDebugFile(outputbase, pkgDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDebugFile(String outputbase, File pkgDir) throws IOException {
        File outFile = new File(pkgDir, classname + ".java");
        String pkg = DebugGen.dottify(pkgDir.getPath().substring(outputbase.length()));
        System.err.println("Writing file: " + outFile.getPath());
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile)), "UTF8");
            writer.write("/********************************************************************" + EOL);
            writer.write(" * This class generated by " + DebugGen.class.getName() + EOL);
            writer.write(" * and will probably be overwritten by the same! Edit at" + EOL);
            writer.write(" * YOUR PERIL!!! Hahahahaha." + EOL);
            writer.write(" ********************************************************************/" + EOL);
            writer.write(EOL);
            writer.write("package " + pkg + ';' + EOL);
            writer.write(EOL);
            writer.write("import com.mchange.v2.debug.DebugConstants;" + EOL);
            writer.write(EOL);
            writer.write("final class " + classname + " implements DebugConstants" + EOL);
            writer.write("{" + EOL);
            writer.write("\tfinal static boolean DEBUG = " + debug + ';' + EOL);
            writer.write("\tfinal static int     TRACE = " + DebugGen.traceStr(trace_level) + ';' + EOL);
            writer.write(EOL);
            writer.write("\tprivate " + classname + "()" + EOL);
            writer.write("\t{}" + EOL);
            writer.write("}" + EOL);
            writer.write(EOL);
            ((Writer)writer).flush();
        }
        catch (Throwable throwable) {
            WriterUtils.attemptClose(writer);
            throw throwable;
        }
        WriterUtils.attemptClose(writer);
    }

    private static String traceStr(int trace) {
        if (trace == 0) {
            return "TRACE_NONE";
        }
        if (trace == 5) {
            return "TRACE_MED";
        }
        if (trace == 10) {
            return "TRACE_MAX";
        }
        return String.valueOf(trace);
    }
}

