/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.AccessLevels;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.L2AdminCommandAccessRight;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class AdminCommandAccessRights {
    private static Logger _log = Logger.getLogger(AdminCommandAccessRights.class.getName());
    private Map<String, L2AdminCommandAccessRight> _adminCommandAccessRights;

    public static AdminCommandAccessRights getInstance() {
        return SingletonHolder._instance;
    }

    private AdminCommandAccessRights() {
        this.loadAdminCommandAccessRights();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAdminCommandAccessRights() {
        this._adminCommandAccessRights = new FastMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement stmt = con.prepareStatement("SELECT * FROM admin_command_access_rights");
            ResultSet rset = stmt.executeQuery();
            String adminCommand = null;
            String accessLevels = null;
            boolean confirm = false;
            while (rset.next()) {
                adminCommand = rset.getString("adminCommand");
                accessLevels = rset.getString("accessLevels");
                confirm = rset.getBoolean("confirmDlg");
                this._adminCommandAccessRights.put(adminCommand, new L2AdminCommandAccessRight(adminCommand, accessLevels, confirm));
            }
            rset.close();
            stmt.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "AdminCommandAccessRights: Error loading from database:" + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        _log.info("AdminCommandAccessRights: Loaded " + this._adminCommandAccessRights.size() + " from database.");
    }

    public boolean hasAccess(String adminCommand, L2AccessLevel accessLevel) {
        if (accessLevel.getLevel() == AccessLevels._masterAccessLevelNum) {
            return true;
        }
        L2AdminCommandAccessRight acar = this._adminCommandAccessRights.get(adminCommand);
        if (acar == null) {
            _log.info("AdminCommandAccessRights: No rights defined for admin command " + adminCommand + ".");
            return false;
        }
        return acar.hasAccess(accessLevel);
    }

    public boolean requireConfirm(String command) {
        L2AdminCommandAccessRight acar = this._adminCommandAccessRights.get(command);
        if (acar == null) {
            _log.info("AdminCommandAccessRights: No rights defined for admin command " + command + ".");
            return false;
        }
        return this._adminCommandAccessRights.get(command).getRequireConfirm();
    }

    public void reloadAdminCommandAccessRights() {
        this.loadAdminCommandAccessRights();
    }

    private static class SingletonHolder {
        protected static final AdminCommandAccessRights _instance = new AdminCommandAccessRights();

        private SingletonHolder() {
        }
    }
}

