/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.NpcKnownList;
import java.util.Collection;

public class AttackableKnownList
extends NpcKnownList {
    public AttackableKnownList(L2Attackable activeChar) {
        super(activeChar);
    }

    @Override
    protected boolean removeKnownObject(L2Object object, boolean forget) {
        if (!super.removeKnownObject(object, forget)) {
            return false;
        }
        if (object instanceof L2Character) {
            this.getActiveChar().getAggroList().remove((Object)object);
        }
        Collection<L2PcInstance> known = this.getKnownPlayers().values();
        if (this.getActiveChar().hasAI() && (known == null || known.isEmpty())) {
            this.getActiveChar().getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
        }
        return true;
    }

    @Override
    public L2Attackable getActiveChar() {
        return (L2Attackable)super.getActiveChar();
    }

    @Override
    public int getDistanceToForgetObject(L2Object object) {
        if (this.getActiveChar().getAggroList().get((Object)object) != null) {
            return 3000;
        }
        return Math.min(2200, 2 * this.getDistanceToWatchObject(object));
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        if (object instanceof L2NpcInstance || !(object instanceof L2Character)) {
            return 0;
        }
        if (object instanceof L2Playable) {
            return object.getKnownList().getDistanceToWatchObject(this.getActiveObject());
        }
        int max = Math.max(300, Math.max(this.getActiveChar().getAggroRange(), Math.max(this.getActiveChar().getFactionRange(), this.getActiveChar().getEnemyRange())));
        return max;
    }
}

