/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.instancemanager.TownManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.L2Trap;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.skills.AbnormalEffect;

public abstract class AbstractNpcInfo
extends L2GameServerPacket {
    private static final String _S__22_NPCINFO = "[S] 0c NpcInfo";
    protected int _x;
    protected int _y;
    protected int _z;
    protected int _heading;
    protected int _idTemplate;
    protected boolean _isAttackable;
    protected boolean _isSummoned;
    protected int _mAtkSpd;
    protected int _pAtkSpd;
    protected int _runSpd;
    protected int _walkSpd;
    protected int _rhand;
    protected int _lhand;
    protected int _chest;
    protected int _enchantEffect;
    protected double _collisionHeight;
    protected double _collisionRadius;
    protected String _name = "";
    protected String _title = "";

    public AbstractNpcInfo(L2Character cha) {
        this._isSummoned = cha.isShowSummonAnimation();
        this._x = cha.getX();
        this._y = cha.getY();
        this._z = cha.getZ();
        this._heading = cha.getHeading();
        this._mAtkSpd = cha.getMAtkSpd();
        this._pAtkSpd = cha.getPAtkSpd();
        this._runSpd = cha.getTemplate().baseRunSpd;
        this._walkSpd = cha.getTemplate().baseWalkSpd;
    }

    @Override
    public String getType() {
        return _S__22_NPCINFO;
    }

    public static class SummonInfo
    extends AbstractNpcInfo {
        private L2Summon _summon;
        private int _form = 0;
        private int _val = 0;

        public SummonInfo(L2Summon cha, L2Character attacker, int val) {
            super(cha);
            int npcId;
            this._summon = cha;
            this._val = val;
            if (this._summon.isShowSummonAnimation()) {
                this._val = 2;
            }
            if ((npcId = cha.getTemplate().npcId) == 16041 || npcId == 16042) {
                if (cha.getLevel() > 84) {
                    this._form = 3;
                } else if (cha.getLevel() > 79) {
                    this._form = 2;
                } else if (cha.getLevel() > 74) {
                    this._form = 1;
                }
            } else if (npcId == 16025 || npcId == 16037) {
                if (cha.getLevel() > 69) {
                    this._form = 3;
                } else if (cha.getLevel() > 64) {
                    this._form = 2;
                } else if (cha.getLevel() > 59) {
                    this._form = 1;
                }
            }
            this._isAttackable = cha.isAutoAttackable(attacker);
            this._rhand = cha.getWeapon();
            this._lhand = 0;
            this._chest = cha.getArmor();
            this._enchantEffect = cha.getTemplate().enchantEffect;
            this._name = cha.getName();
            this._title = cha.getOwner() != null ? (!cha.getOwner().isOnline() ? "" : cha.getOwner().getName()) : "";
            this._idTemplate = cha.getTemplate().idTemplate;
            this._collisionHeight = cha.getTemplate().fCollisionHeight;
            this._collisionRadius = cha.getTemplate().fCollisionRadius;
            this._invisible = cha.getOwner() != null ? cha.getOwner().getAppearance().getInvisible() : false;
        }

        @Override
        protected void writeImpl() {
            L2PcInstance tmp;
            boolean gmSeeInvis = false;
            if (this._invisible && (tmp = ((L2GameClient)this.getClient()).getActiveChar()) != null && tmp.isGM()) {
                gmSeeInvis = true;
            }
            this.writeC(12);
            this.writeD(this._summon.getObjectId());
            this.writeD(this._idTemplate + 1000000);
            this.writeD(this._isAttackable ? 1 : 0);
            this.writeD(this._x);
            this.writeD(this._y);
            this.writeD(this._z);
            this.writeD(this._heading);
            this.writeD(0);
            this.writeD(this._mAtkSpd);
            this.writeD(this._pAtkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeF(this._summon.getMovementSpeedMultiplier());
            this.writeF(this._summon.getAttackSpeedMultiplier());
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(this._rhand);
            this.writeD(this._chest);
            this.writeD(this._lhand);
            this.writeC(1);
            this.writeC(1);
            this.writeC(this._summon.isInCombat() ? 1 : 0);
            this.writeC(this._summon.isAlikeDead() ? 1 : 0);
            this.writeC(this._val);
            this.writeS(this._name);
            this.writeS(this._title);
            this.writeD(1);
            this.writeD(this._summon.getPvpFlag());
            this.writeD(this._summon.getKarma());
            this.writeD(gmSeeInvis ? this._summon.getAbnormalEffect() | AbnormalEffect.STEALTH.getMask() : this._summon.getAbnormalEffect());
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeC(0);
            this.writeC(this._summon.getTeam());
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(this._enchantEffect);
            this.writeD(0);
            this.writeD(0);
            this.writeD(this._form);
            this.writeC(1);
            this.writeC(1);
            this.writeD(this._summon.getSpecialEffect());
        }
    }

    public static class TrapInfo
    extends AbstractNpcInfo {
        private L2Trap _trap;

        public TrapInfo(L2Trap cha, L2Character attacker) {
            super(cha);
            this._trap = cha;
            this._idTemplate = cha.getTemplate().idTemplate;
            this._isAttackable = cha.isAutoAttackable(attacker);
            this._rhand = 0;
            this._lhand = 0;
            this._collisionHeight = this._trap.getTemplate().fCollisionHeight;
            this._collisionRadius = this._trap.getTemplate().fCollisionRadius;
            if (cha.getTemplate().serverSideName) {
                this._name = cha.getName();
            }
            this._title = cha.getOwner() != null ? cha.getOwner().getName() : "";
            this._runSpd = this._trap.getRunSpeed();
            this._walkSpd = this._trap.getWalkSpeed();
        }

        @Override
        protected void writeImpl() {
            this.writeC(12);
            this.writeD(this._trap.getObjectId());
            this.writeD(this._idTemplate + 1000000);
            this.writeD(this._isAttackable ? 1 : 0);
            this.writeD(this._x);
            this.writeD(this._y);
            this.writeD(this._z);
            this.writeD(this._heading);
            this.writeD(0);
            this.writeD(this._mAtkSpd);
            this.writeD(this._pAtkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeF(this._trap.getMovementSpeedMultiplier());
            this.writeF(this._trap.getAttackSpeedMultiplier());
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(this._rhand);
            this.writeD(this._chest);
            this.writeD(this._lhand);
            this.writeC(1);
            this.writeC(1);
            this.writeC(this._trap.isInCombat() ? 1 : 0);
            this.writeC(this._trap.isAlikeDead() ? 1 : 0);
            this.writeC(this._isSummoned ? 2 : 0);
            this.writeS(this._name);
            this.writeS(this._title);
            this.writeD(0);
            this.writeD(this._trap.getPvpFlag());
            this.writeD(this._trap.getKarma());
            this.writeD(this._trap.getAbnormalEffect());
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeC(0);
            this.writeC(0);
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeC(1);
            this.writeC(1);
            this.writeD(0);
        }
    }

    public static class NpcInfo
    extends AbstractNpcInfo {
        private L2Npc _npc;
        private int _clanCrest = 0;
        private int _allyCrest = 0;
        private int _allyId = 0;
        private int _clanId = 0;
        private int _displayEffect = 0;

        public NpcInfo(L2Npc cha, L2Character attacker) {
            super(cha);
            int townId;
            this._npc = cha;
            this._idTemplate = cha.getTemplate().idTemplate;
            this._rhand = cha.getRightHandItem();
            this._lhand = cha.getLeftHandItem();
            this._enchantEffect = cha.getEnchantEffect();
            this._collisionHeight = cha.getCollisionHeight();
            this._collisionRadius = cha.getCollisionRadius();
            this._isAttackable = cha.isAutoAttackable(attacker);
            if (cha.getTemplate().serverSideName) {
                this._name = cha.getName();
            }
            if (Config.L2JMOD_CHAMPION_ENABLE && cha.isChampion()) {
                this._title = Config.L2JMOD_CHAMP_TITLE;
            } else {
                this._title = cha.getTitle();
                if (this._title == null && cha.getTemplate().serverSideTitle) {
                    this._title = cha.getTemplate().title;
                }
            }
            if (Config.SHOW_NPC_LVL && this._npc instanceof L2MonsterInstance) {
                StringBuilder t = new StringBuilder(32).append("Lv ").append(cha.getLevel());
                if (cha.getAggroRange() > 0) {
                    t.append('*');
                }
                if (this._title != null) {
                    t.append(' ').append(this._title);
                }
                this._title = t.toString();
            }
            if (cha instanceof L2NpcInstance && cha.isInsideZone((byte)15) && (Config.SHOW_CREST_WITHOUT_QUEST || cha.getCastle().getShowNpcCrest()) && cha.getCastle().getOwnerId() != 0 && (townId = TownManager.getTown(this._x, this._y, this._z).getTownId()) != 33 && townId != 22) {
                L2Clan clan = ClanTable.getInstance().getClan(cha.getCastle().getOwnerId());
                this._clanCrest = clan.getCrestId();
                this._clanId = clan.getClanId();
                this._allyCrest = clan.getAllyCrestId();
                this._allyId = clan.getAllyId();
            }
            this._displayEffect = cha.getDisplayEffect();
        }

        @Override
        protected void writeImpl() {
            this.writeC(12);
            this.writeD(this._npc.getObjectId());
            this.writeD(this._idTemplate + 1000000);
            this.writeD(this._isAttackable ? 1 : 0);
            this.writeD(this._x);
            this.writeD(this._y);
            this.writeD(this._z);
            this.writeD(this._heading);
            this.writeD(0);
            this.writeD(this._mAtkSpd);
            this.writeD(this._pAtkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeF(this._npc.getMovementSpeedMultiplier());
            this.writeF(this._npc.getAttackSpeedMultiplier());
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(this._rhand);
            this.writeD(this._chest);
            this.writeD(this._lhand);
            this.writeC(1);
            this.writeC(this._npc.isRunning() ? 1 : 0);
            this.writeC(this._npc.isInCombat() ? 1 : 0);
            this.writeC(this._npc.isAlikeDead() ? 1 : 0);
            this.writeC(this._isSummoned ? 2 : 0);
            this.writeS(this._name);
            this.writeS(this._title);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(this._npc.getAbnormalEffect());
            this.writeD(this._clanId);
            this.writeD(this._clanCrest);
            this.writeD(this._allyId);
            this.writeD(this._allyCrest);
            this.writeC(this._npc.isFlying() ? 2 : 0);
            this.writeC(0);
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(this._enchantEffect);
            this.writeD(this._npc.isFlying() ? 1 : 0);
            this.writeD(0);
            this.writeD(this._npc.getColorEffect());
            this.writeC(this._npc.isHideName() ? 0 : 1);
            this.writeC(this._npc.isHideName() ? 0 : 1);
            this.writeD(this._npc.getSpecialEffect());
            this.writeD(this._displayEffect);
        }
    }
}

