/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.funcs;

import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.conditions.Condition;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.funcs.Lambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FuncTemplate {
    protected static final Logger _log = Logger.getLogger(FuncTemplate.class.getName());
    public Condition attachCond;
    public Condition applayCond;
    public final Class<?> func;
    public final Constructor<?> constructor;
    public final Stats stat;
    public final int order;
    public final Lambda lambda;

    public FuncTemplate(Condition pAttachCond, Condition pApplayCond, String pFunc, Stats pStat, int pOrder, Lambda pLambda) {
        this.attachCond = pAttachCond;
        this.applayCond = pApplayCond;
        this.stat = pStat;
        this.order = pOrder;
        this.lambda = pLambda;
        try {
            this.func = Class.forName("com.l2jserver.gameserver.skills.funcs.Func" + pFunc);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            this.constructor = this.func.getConstructor(Stats.class, Integer.TYPE, Object.class, Lambda.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public Func getFunc(Env env, Object owner) {
        if (this.attachCond != null && !this.attachCond.test(env)) {
            return null;
        }
        try {
            Func f = (Func)this.constructor.newInstance(new Object[]{this.stat, this.order, owner, this.lambda});
            if (this.applayCond != null) {
                f.setCondition(this.applayCond);
            }
            return f;
        }
        catch (IllegalAccessException e) {
            _log.log(Level.WARNING, "", e);
            return null;
        }
        catch (InstantiationException e) {
            _log.log(Level.WARNING, "", e);
            return null;
        }
        catch (InvocationTargetException e) {
            _log.log(Level.WARNING, "", e);
            return null;
        }
    }
}

