/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GameTimeController {
    protected static final Logger _log = Logger.getLogger(GameTimeController.class.getName());
    public static final int TICKS_PER_SECOND = 10;
    public static final int MILLIS_IN_TICK = 100;
    protected static int _gameTicks;
    protected static long _gameStartTime;
    protected static boolean _isNight;
    protected static boolean _interruptRequest;
    private static final TIntObjectHashMap<L2Character> _movingObjects;
    private static final ReentrantLock _lock;
    protected static TimerThread _timer;

    public static GameTimeController getInstance() {
        return SingletonHolder._instance;
    }

    private GameTimeController() {
        _log.info("Initializing Game Time Controller");
        _gameStartTime = System.currentTimeMillis() - 3600000L;
        _gameTicks = 36000;
        _timer = new TimerThread();
        _timer.start();
        ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new BroadcastSunState(), 0L, 600000L);
    }

    public boolean isNowNight() {
        return _isNight;
    }

    public int getGameTime() {
        return _gameTicks / 100;
    }

    public static int getGameTicks() {
        return _gameTicks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMovingObject(L2Character cha) {
        if (cha == null) {
            return;
        }
        _lock.lock();
        try {
            _movingObjects.putIfAbsent(cha.getObjectId(), (Object)cha);
        }
        finally {
            _lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveObjects() {
        _lock.lock();
        try {
            _movingObjects.forEachValue((TObjectProcedure)new MoveObjects());
        }
        finally {
            _lock.unlock();
        }
    }

    public void stopTimer() {
        _interruptRequest = true;
        _timer.interrupt();
    }

    static {
        _isNight = false;
        _interruptRequest = false;
        _movingObjects = new TIntObjectHashMap();
        _lock = new ReentrantLock();
    }

    private static class SingletonHolder {
        protected static final GameTimeController _instance = new GameTimeController();

        private SingletonHolder() {
        }
    }

    class BroadcastSunState
    implements Runnable {
        BroadcastSunState() {
        }

        @Override
        public void run() {
            boolean tempIsNight;
            int h = (GameTimeController.this.getGameTime() + 30) / 60 % 24;
            boolean bl = tempIsNight = h < 6;
            if (tempIsNight != _isNight) {
                _isNight = tempIsNight;
                DayNightSpawnManager.getInstance().notifyChangeMode();
            }
        }
    }

    private static class MovingObjectArrived
    implements Runnable {
        private final L2Character _ended;

        MovingObjectArrived(L2Character ended) {
            this._ended = ended;
        }

        @Override
        public void run() {
            try {
                if (this._ended.hasAI()) {
                    if (Config.MOVE_BASED_KNOWNLIST) {
                        this._ended.getKnownList().findObjects();
                    }
                    this._ended.getAI().notifyEvent(CtrlEvent.EVT_ARRIVED);
                }
            }
            catch (NullPointerException e) {
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    class TimerThread
    extends Thread {
        public TimerThread() {
            super("GameTimeController");
            this.setDaemon(true);
            this.setPriority(10);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int sleepTime;
                        long runtime;
                        int oldTicks;
                        if ((oldTicks = _gameTicks) != (_gameTicks = (int)((runtime = System.currentTimeMillis() - _gameStartTime) / 100L))) {
                            GameTimeController.this.moveObjects();
                        }
                        if ((sleepTime = 101 - (int)(runtime = System.currentTimeMillis() - _gameStartTime - runtime) % 100) <= 0) continue;
                        Thread.sleep(sleepTime);
                    }
                }
                catch (InterruptedException ie) {
                    if (_interruptRequest) {
                        return;
                    }
                    _log.log(Level.WARNING, "", ie);
                    continue;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "", e);
                    continue;
                }
                break;
            }
        }
    }

    private final class MoveObjects
    implements TObjectProcedure<L2Character> {
        private MoveObjects() {
        }

        public final boolean execute(L2Character ch) {
            if (ch.updatePosition(_gameTicks)) {
                _movingObjects.remove(ch.getObjectId());
                ThreadPoolManager.getInstance().executeTask(new MovingObjectArrived(ch));
            }
            return true;
        }
    }
}

