/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonsterRace {
    protected static final Logger _log = Logger.getLogger(MonsterRace.class.getName());
    private L2Npc[] _monsters = new L2Npc[8];
    private Constructor<?> _constructor;
    private int[][] _speeds = new int[8][20];
    private int[] _first = new int[2];
    private int[] _second = new int[2];

    private MonsterRace() {
    }

    public static MonsterRace getInstance() {
        return SingletonHolder._instance;
    }

    public void newRace() {
        int random = 0;
        for (int i = 0; i < 8; ++i) {
            int id = 31003;
            random = Rnd.get(24);
            for (int j = i - 1; j >= 0; --j) {
                if (this._monsters[j].getTemplate().npcId != id + random) continue;
                random = Rnd.get(24);
            }
            try {
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(id + random);
                this._constructor = Class.forName("com.l2jserver.gameserver.model.actor.instance." + template.type + "Instance").getConstructors()[0];
                int objectId = IdFactory.getInstance().getNextId();
                this._monsters[i] = (L2Npc)this._constructor.newInstance(objectId, template);
                continue;
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "", e);
            }
        }
        this.newSpeeds();
    }

    public void newSpeeds() {
        this._speeds = new int[8][20];
        int total = 0;
        this._first[1] = 0;
        this._second[1] = 0;
        for (int i = 0; i < 8; ++i) {
            total = 0;
            for (int j = 0; j < 20; ++j) {
                this._speeds[i][j] = j == 19 ? 100 : Rnd.get(60) + 65;
                total += this._speeds[i][j];
            }
            if (total >= this._first[1]) {
                this._second[0] = this._first[0];
                this._second[1] = this._first[1];
                this._first[0] = 8 - i;
                this._first[1] = total;
                continue;
            }
            if (total < this._second[1]) continue;
            this._second[0] = 8 - i;
            this._second[1] = total;
        }
    }

    public L2Npc[] getMonsters() {
        return this._monsters;
    }

    public int[][] getSpeeds() {
        return this._speeds;
    }

    public int getFirstPlace() {
        return this._first[0];
    }

    public int getSecondPlace() {
        return this._second[0];
    }

    private static class SingletonHolder {
        protected static final MonsterRace _instance = new MonsterRace();

        private SingletonHolder() {
        }
    }
}

