/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.base.Race;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javolution.util.FastMap;

public class L2MapRegion {
    private String _name = null;
    private String _town = null;
    private int _locId = -1;
    private int _castle = -1;
    private int _bbs = -1;
    private List<int[]> _maps = null;
    private List<Location> _spawnLocs = null;
    private List<Location> _otherSpawnLocs = null;
    private List<Location> _chaoticSpawnLocs = null;
    private List<Location> _banishSpawnLocs = null;
    private Map<Race, String> _bannedRace = new FastMap();

    public L2MapRegion(String name, String town, int locId, int castle, int bbs) {
        this._name = name;
        this._town = town;
        this._locId = locId;
        this._castle = castle;
        this._bbs = bbs;
    }

    public final String getName() {
        return this._name;
    }

    public final String getTown() {
        return this._town;
    }

    public final int getLocId() {
        return this._locId;
    }

    public final int getCastle() {
        return this._castle;
    }

    public final int getBbs() {
        return this._bbs;
    }

    public final void addMap(int x, int y) {
        if (this._maps == null) {
            this._maps = new ArrayList<int[]>();
        }
        this._maps.add(new int[]{x, y});
    }

    public final List<int[]> getMaps() {
        return this._maps;
    }

    public final boolean isZoneInRegion(int x, int y) {
        if (this._maps == null) {
            return false;
        }
        for (int[] map : this._maps) {
            if (map[0] != x || map[1] != y) continue;
            return true;
        }
        return false;
    }

    public final void addSpawn(int x, int y, int z) {
        if (this._spawnLocs == null) {
            this._spawnLocs = new ArrayList<Location>();
        }
        this._spawnLocs.add(new Location(x, y, z));
    }

    public final void addOtherSpawn(int x, int y, int z) {
        if (this._otherSpawnLocs == null) {
            this._otherSpawnLocs = new ArrayList<Location>();
        }
        this._otherSpawnLocs.add(new Location(x, y, z));
    }

    public final void addChaoticSpawn(int x, int y, int z) {
        if (this._chaoticSpawnLocs == null) {
            this._chaoticSpawnLocs = new ArrayList<Location>();
        }
        this._chaoticSpawnLocs.add(new Location(x, y, z));
    }

    public final void addBanishSpawn(int x, int y, int z) {
        if (this._banishSpawnLocs == null) {
            this._banishSpawnLocs = new ArrayList<Location>();
        }
        this._banishSpawnLocs.add(new Location(x, y, z));
    }

    public final List<Location> getSpawns() {
        return this._spawnLocs;
    }

    public final Location getSpawnLoc() {
        if (Config.RANDOM_RESPAWN_IN_TOWN_ENABLED) {
            return this._spawnLocs.get(Rnd.get(this._spawnLocs.size()));
        }
        return this._spawnLocs.get(0);
    }

    public final Location getOtherSpawnLoc() {
        if (this._otherSpawnLocs != null) {
            if (Config.RANDOM_RESPAWN_IN_TOWN_ENABLED) {
                return this._otherSpawnLocs.get(Rnd.get(this._otherSpawnLocs.size()));
            }
            return this._otherSpawnLocs.get(0);
        }
        return this.getSpawnLoc();
    }

    public final Location getChaoticSpawnLoc() {
        if (this._chaoticSpawnLocs != null) {
            if (Config.RANDOM_RESPAWN_IN_TOWN_ENABLED) {
                return this._chaoticSpawnLocs.get(Rnd.get(this._chaoticSpawnLocs.size()));
            }
            return this._chaoticSpawnLocs.get(0);
        }
        return this.getSpawnLoc();
    }

    public final Location getBanishSpawnLoc() {
        if (this._banishSpawnLocs != null) {
            if (Config.RANDOM_RESPAWN_IN_TOWN_ENABLED) {
                return this._banishSpawnLocs.get(Rnd.get(this._banishSpawnLocs.size()));
            }
            return this._banishSpawnLocs.get(0);
        }
        return this.getSpawnLoc();
    }

    public final void addBannedRace(String race, String point) {
        this._bannedRace.put(Race.valueOf(race), point);
    }

    public final Map<Race, String> getBannedRace() {
        return this._bannedRace;
    }
}

