/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import java.util.Collection;

public abstract class L2Decoy
extends L2Character {
    private final L2PcInstance _owner;

    public L2Decoy(int objectId, L2CharTemplate template, L2PcInstance owner) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2Decoy);
        this._owner = owner;
        this.setXYZInvisible(owner.getX(), owner.getY(), owner.getZ());
        this.setIsInvul(false);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.getOwner().sendPacket(new CharInfo(this));
    }

    @Override
    public void updateAbnormalEffect() {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null) continue;
            player.sendPacket(new CharInfo(this));
        }
    }

    public void stopDecay() {
        DecayTaskManager.getInstance().cancelDecayTask(this);
    }

    @Override
    public void onDecay() {
        this.deleteMe(this._owner);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return this._owner.isAutoAttackable(attacker);
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    public final int getNpcId() {
        return this.getTemplate().npcId;
    }

    @Override
    public int getLevel() {
        return this.getTemplate().level;
    }

    public void deleteMe(L2PcInstance owner) {
        this.decayMe();
        this.getKnownList().removeAllKnownObjects();
        owner.setDecoy(null);
    }

    public synchronized void unSummon(L2PcInstance owner) {
        if (this.isVisible() && !this.isDead()) {
            if (this.getWorldRegion() != null) {
                this.getWorldRegion().removeFromZones(this);
            }
            owner.setDecoy(null);
            this.decayMe();
            this.getKnownList().removeAllKnownObjects();
        }
    }

    public final L2PcInstance getOwner() {
        return this._owner;
    }

    @Override
    public L2PcInstance getActingPlayer() {
        return this._owner;
    }

    @Override
    public L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)super.getTemplate();
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        activeChar.sendPacket(new CharInfo(this));
    }
}

