/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.skills.AbnormalEffect;

public class L2AbnormalZone
extends L2ZoneType {
    private int abnormal = AbnormalEffect.BIG_HEAD.getMask();
    private int special = 0;

    public L2AbnormalZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("AbnormalMask")) {
            this.abnormal = Integer.parseInt(value);
        } else if (name.equals("SpecialMask")) {
            this.special = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        character.startAbnormalEffect(this.abnormal);
        character.startSpecialEffect(this.special);
    }

    @Override
    protected void onExit(L2Character character) {
        character.stopAbnormalEffect(this.abnormal);
        character.stopSpecialEffect(this.special);
    }

    @Override
    public void onDieInside(L2Character character) {
        this.onExit(character);
    }

    @Override
    public void onReviveInside(L2Character character) {
        this.onEnter(character);
    }
}

