/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import java.util.concurrent.Future;

public class L2DynamicZone
extends L2ZoneType {
    private L2WorldRegion _region;
    private L2Character _owner;
    private Future<?> _task;
    private L2Skill _skill;

    protected void setTask(Future<?> task) {
        this._task = task;
    }

    public L2DynamicZone(L2WorldRegion region, L2Character owner, L2Skill skill) {
        super(-1);
        this._region = region;
        this._owner = owner;
        this._skill = skill;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                L2DynamicZone.this.remove();
            }
        };
        this.setTask(ThreadPoolManager.getInstance().scheduleGeneral(r, skill.getBuffDuration()));
    }

    @Override
    protected void onEnter(L2Character character) {
        try {
            if (character instanceof L2PcInstance) {
                ((L2PcInstance)character).sendMessage("You have entered a temporary zone!");
            }
            this._skill.getEffects(this._owner, character);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character instanceof L2PcInstance) {
            ((L2PcInstance)character).sendMessage("You have left a temporary zone!");
        }
        if (character == this._owner) {
            this.remove();
            return;
        }
        character.stopSkillEffects(this._skill.getId());
    }

    protected void remove() {
        if (this._task == null) {
            return;
        }
        this._task.cancel(false);
        this._task = null;
        this._region.removeZone(this);
        for (L2Character member : this.getCharactersInsideArray()) {
            try {
                member.stopSkillEffects(this._skill.getId());
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        this._owner.stopSkillEffects(this._skill.getId());
    }

    @Override
    public void onDieInside(L2Character character) {
        if (character == this._owner) {
            this.remove();
        } else {
            character.stopSkillEffects(this._skill.getId());
        }
    }

    @Override
    public void onReviveInside(L2Character character) {
        this._skill.getEffects(this._owner, character);
    }
}

