/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.model.CharSelectInfoPackage;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.network.BlowFishKeygen;
import com.l2jserver.gameserver.network.ClientStats;
import com.l2jserver.gameserver.network.GameCrypt;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.ServerClose;
import com.l2jserver.gameserver.security.SecondaryPasswordAuth;
import com.l2jserver.gameserver.util.FloodProtectors;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.mmocore.network.MMOClient;
import org.mmocore.network.MMOConnection;
import org.mmocore.network.ReceivablePacket;
import org.mmocore.network.SendablePacket;

public final class L2GameClient
extends MMOClient<MMOConnection<L2GameClient>>
implements Runnable {
    protected static final Logger _log = Logger.getLogger(L2GameClient.class.getName());
    protected static final Logger _logAccounting = Logger.getLogger("accounting");
    private GameClientState _state;
    private final InetAddress _addr;
    private String _accountName;
    private LoginServerThread.SessionKey _sessionId;
    private L2PcInstance _activeChar;
    private final ReentrantLock _activeCharLock = new ReentrantLock();
    private SecondaryPasswordAuth _secondaryAuth;
    private boolean _isAuthedGG;
    private final long _connectionStartTime;
    private CharSelectInfoPackage[] _charSlotMapping = null;
    private final FloodProtectors _floodProtectors = new FloodProtectors(this);
    protected final ScheduledFuture<?> _autoSaveInDB;
    protected ScheduledFuture<?> _cleanupTask = null;
    private L2GameServerPacket _aditionalClosePacket;
    private final GameCrypt _crypt;
    private final ClientStats _stats;
    private boolean _isDetached = false;
    private boolean _protocol;
    private final ArrayBlockingQueue<ReceivablePacket<L2GameClient>> _packetQueue;
    private final ReentrantLock _queueLock = new ReentrantLock();
    private int[][] trace;

    public L2GameClient(MMOConnection<L2GameClient> con) {
        super(con);
        this._state = GameClientState.CONNECTED;
        this._connectionStartTime = System.currentTimeMillis();
        this._crypt = new GameCrypt();
        this._stats = new ClientStats();
        this._packetQueue = new ArrayBlockingQueue(Config.CLIENT_PACKET_QUEUE_SIZE);
        this._autoSaveInDB = Config.CHAR_STORE_INTERVAL > 0 ? ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new AutoSaveTask(), Rnd.get(300000L, 300000L + (long)Config.CHAR_STORE_INTERVAL * 60000L), (long)Config.CHAR_STORE_INTERVAL * 60000L) : null;
        try {
            this._addr = con != null ? con.getInetAddress() : InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new Error("Unable to determine localhost address.");
        }
    }

    public byte[] enableCrypt() {
        byte[] key = BlowFishKeygen.getRandomKey();
        this._crypt.setKey(key);
        return key;
    }

    public GameClientState getState() {
        return this._state;
    }

    public void setState(GameClientState pState) {
        if (this._state != pState) {
            this._state = pState;
            this._packetQueue.clear();
        }
    }

    public ClientStats getStats() {
        return this._stats;
    }

    public InetAddress getConnectionAddress() {
        return this._addr;
    }

    public long getConnectionStartTime() {
        return this._connectionStartTime;
    }

    public boolean decrypt(ByteBuffer buf, int size) {
        this._crypt.decrypt(buf.array(), buf.position(), size);
        return true;
    }

    public boolean encrypt(ByteBuffer buf, int size) {
        this._crypt.encrypt(buf.array(), buf.position(), size);
        buf.position(buf.position() + size);
        return true;
    }

    public L2PcInstance getActiveChar() {
        return this._activeChar;
    }

    public void setActiveChar(L2PcInstance pActiveChar) {
        this._activeChar = pActiveChar;
    }

    public ReentrantLock getActiveCharLock() {
        return this._activeCharLock;
    }

    public FloodProtectors getFloodProtectors() {
        return this._floodProtectors;
    }

    public void setGameGuardOk(boolean val) {
        this._isAuthedGG = val;
    }

    public boolean isAuthedGG() {
        return this._isAuthedGG;
    }

    public void setAccountName(String pAccountName) {
        this._accountName = pAccountName;
        if (Config.SECOND_AUTH_ENABLED) {
            this._secondaryAuth = new SecondaryPasswordAuth(this);
        }
    }

    public String getAccountName() {
        return this._accountName;
    }

    public void setSessionId(LoginServerThread.SessionKey sk) {
        this._sessionId = sk;
    }

    public LoginServerThread.SessionKey getSessionId() {
        return this._sessionId;
    }

    public void sendPacket(L2GameServerPacket gsp) {
        if (this._isDetached) {
            return;
        }
        if (gsp.isInvisible() && this.getActiveChar() != null && !this.getActiveChar().isGM()) {
            return;
        }
        this.getConnection().sendPacket((SendablePacket)gsp);
        gsp.runImpl();
    }

    public boolean isDetached() {
        return this._isDetached;
    }

    public void setDetached(boolean b) {
        this._isDetached = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte markToDeleteChar(int charslot) {
        int objid = this.getObjectIdForSlot(charslot);
        if (objid < 0) {
            return -1;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clanId FROM characters WHERE charId=?");
            statement.setInt(1, objid);
            ResultSet rs = statement.executeQuery();
            rs.next();
            int clanId = rs.getInt(1);
            byte answer = 0;
            if (clanId != 0) {
                L2Clan clan = ClanTable.getInstance().getClan(clanId);
                answer = clan == null ? (byte)0 : (clan.getLeaderId() == objid ? (byte)2 : 1);
            }
            rs.close();
            statement.close();
            if (answer == 0) {
                if (Config.DELETE_DAYS == 0) {
                    L2GameClient.deleteCharByObjId(objid);
                } else {
                    statement = con.prepareStatement("UPDATE characters SET deletetime=? WHERE charId=?");
                    statement.setLong(1, System.currentTimeMillis() + (long)Config.DELETE_DAYS * 86400000L);
                    statement.setInt(2, objid);
                    statement.execute();
                    statement.close();
                }
                LogRecord record = new LogRecord(Level.WARNING, "Delete");
                record.setParameters(new Object[]{objid, this});
                _logAccounting.log(record);
            }
            byte by = answer;
            return by;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error updating delete time of character.", e);
            byte by = -1;
            return by;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void saveCharToDisk() {
        try {
            if (this.getActiveChar() != null) {
                this.getActiveChar().store();
                this.getActiveChar().storeRecommendations();
                if (Config.UPDATE_ITEMS_ON_CHAR_STORE) {
                    this.getActiveChar().getInventory().updateDatabase();
                    this.getActiveChar().getWarehouse().updateDatabase();
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error saving character..", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRestoredChar(int charslot) {
        int objid = this.getObjectIdForSlot(charslot);
        if (objid < 0) {
            return;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE characters SET deletetime=0 WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error restoring character.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        LogRecord record = new LogRecord(Level.WARNING, "Restore");
        record.setParameters(new Object[]{objid, this});
        _logAccounting.log(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCharByObjId(int objid) {
        if (objid < 0) {
            return;
        }
        CharNameTable.getInstance().removeName(objid);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_contacts WHERE charId=? OR contactId=?");
            statement.setInt(1, objid);
            statement.setInt(2, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_friends WHERE charId=? OR friendId=?");
            statement.setInt(1, objid);
            statement.setInt(2, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_hennas WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_macroses WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_quests WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_quest_global_data WHERE charId=?");
            statement.setInt(1, objid);
            statement.executeUpdate();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_recipebook WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_shortcuts WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_skills WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_skills_save WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_subclasses WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM heroes WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM olympiad_nobles WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM seven_signs WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id IN (SELECT object_id FROM items WHERE items.owner_id=?)");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM item_attributes WHERE itemId IN (SELECT object_id FROM items WHERE items.owner_id=?)");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM items WHERE owner_id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM merchant_lease WHERE player_id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_raid_points WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_reco_bonus WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_instance_time WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM characters WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error deleting character.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public L2PcInstance loadCharFromDisk(int charslot) {
        int objId = this.getObjectIdForSlot(charslot);
        if (objId < 0) {
            return null;
        }
        L2PcInstance character = L2World.getInstance().getPlayer(objId);
        if (character != null) {
            _log.severe("Attempt of double login: " + character.getName() + "(" + objId + ") " + this.getAccountName());
            if (character.getClient() != null) {
                character.getClient().closeNow();
            } else {
                character.deleteMe();
            }
            return null;
        }
        character = L2PcInstance.load(objId);
        if (character != null) {
            character.setRunning();
            character.standUp();
            character.refreshOverloaded();
            character.refreshExpertisePenalty();
            character.setOnlineStatus(true, false);
        } else {
            _log.severe("could not restore in slot: " + charslot);
        }
        return character;
    }

    public void setCharSelection(CharSelectInfoPackage[] chars) {
        this._charSlotMapping = chars;
    }

    public CharSelectInfoPackage getCharSelection(int charslot) {
        if (this._charSlotMapping == null || charslot < 0 || charslot >= this._charSlotMapping.length) {
            return null;
        }
        return this._charSlotMapping[charslot];
    }

    public SecondaryPasswordAuth getSecondaryAuth() {
        return this._secondaryAuth;
    }

    public void close(L2GameServerPacket gsp) {
        if (this.getConnection() == null) {
            return;
        }
        if (this._aditionalClosePacket != null) {
            this.getConnection().close((SendablePacket[])new L2GameServerPacket[]{this._aditionalClosePacket, gsp});
        } else {
            this.getConnection().close((SendablePacket)gsp);
        }
    }

    public void close(L2GameServerPacket[] gspArray) {
        if (this.getConnection() == null) {
            return;
        }
        this.getConnection().close((SendablePacket[])gspArray);
    }

    private int getObjectIdForSlot(int charslot) {
        CharSelectInfoPackage info = this.getCharSelection(charslot);
        if (info == null) {
            _log.warning(this.toString() + " tried to delete Character in slot " + charslot + " but no characters exits at that slot.");
            return -1;
        }
        return info.getObjectId();
    }

    protected void onForcedDisconnection() {
        LogRecord record = new LogRecord(Level.WARNING, "Disconnected abnormally");
        record.setParameters(new Object[]{this});
        _logAccounting.log(record);
    }

    protected void onDisconnection() {
        try {
            ThreadPoolManager.getInstance().executeTask(new DisconnectTask());
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeNow() {
        this._isDetached = true;
        this.close(ServerClose.STATIC_PACKET);
        L2GameClient l2GameClient = this;
        synchronized (l2GameClient) {
            if (this._cleanupTask != null) {
                this.cancelCleanup();
            }
            this._cleanupTask = ThreadPoolManager.getInstance().scheduleGeneral(new CleanupTask(), 0L);
        }
    }

    public String toString() {
        try {
            InetAddress address = this.getConnection().getInetAddress();
            switch (this.getState()) {
                case CONNECTED: {
                    return "[IP: " + (address == null ? "disconnected" : address.getHostAddress()) + "]";
                }
                case AUTHED: {
                    return "[Account: " + this.getAccountName() + " - IP: " + (address == null ? "disconnected" : address.getHostAddress()) + "]";
                }
                case IN_GAME: {
                    return "[Character: " + (this.getActiveChar() == null ? "disconnected" : this.getActiveChar().getName() + "[" + this.getActiveChar().getObjectId() + "]") + " - Account: " + this.getAccountName() + " - IP: " + (address == null ? "disconnected" : address.getHostAddress()) + "]";
                }
            }
            throw new IllegalStateException("Missing state on switch");
        }
        catch (NullPointerException e) {
            return "[Character read failed due to disconnect]";
        }
    }

    private boolean offlineMode(L2PcInstance player) {
        boolean canSetShop = false;
        if (player.isInOlympiadMode() || player.isFestivalParticipant() || TvTEvent.isPlayerParticipant(player.getObjectId()) || player.isInJail() || player.getVehicle() != null) {
            return false;
        }
        if (Config.OFFLINE_TRADE_ENABLE && (player.getPrivateStoreType() == 1 || player.getPrivateStoreType() == 3)) {
            canSetShop = true;
        } else if (Config.OFFLINE_CRAFT_ENABLE && (player.isInCraftMode() || player.getPrivateStoreType() == 5)) {
            canSetShop = true;
        }
        if (Config.OFFLINE_MODE_IN_PEACE_ZONE && !player.isInsideZone((byte)1)) {
            canSetShop = false;
        }
        return canSetShop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanMe(boolean fast) {
        try {
            L2GameClient l2GameClient = this;
            synchronized (l2GameClient) {
                if (this._cleanupTask == null) {
                    this._cleanupTask = ThreadPoolManager.getInstance().scheduleGeneral(new CleanupTask(), fast ? 5L : 15000L);
                }
            }
        }
        catch (Exception e1) {
            _log.log(Level.WARNING, "Error during cleanup.", e1);
        }
    }

    public boolean isProtocolOk() {
        return this._protocol;
    }

    public void setProtocolOk(boolean b) {
        this._protocol = b;
    }

    public boolean handleCheat(String punishment) {
        if (this._activeChar != null) {
            Util.handleIllegalPlayerAction(this._activeChar, this.toString() + ": " + punishment, Config.DEFAULT_PUNISH);
            return true;
        }
        Logger _logAudit = Logger.getLogger("audit");
        _logAudit.log(Level.INFO, "AUDIT: Client " + this.toString() + " kicked for reason: " + punishment);
        this.closeNow();
        return false;
    }

    public boolean dropPacket() {
        if (this._isDetached) {
            return true;
        }
        if (this.getStats().countPacket(this._packetQueue.size())) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return true;
        }
        return this.getStats().dropPacket();
    }

    public void onBufferUnderflow() {
        if (this.getStats().countUnderflowException()) {
            _log.severe("Client " + this.toString() + " - Disconnected: Too many buffer underflow exceptions.");
            this.closeNow();
            return;
        }
        if (this._state == GameClientState.CONNECTED) {
            if (Config.PACKET_HANDLER_DEBUG) {
                _log.severe("Client " + this.toString() + " - Disconnected, too many buffer underflows in non-authed state.");
            }
            this.closeNow();
        }
    }

    public void onUnknownPacket() {
        if (this.getStats().countUnknownPacket()) {
            _log.severe("Client " + this.toString() + " - Disconnected: Too many unknown packets.");
            this.closeNow();
            return;
        }
        if (this._state == GameClientState.CONNECTED) {
            if (Config.PACKET_HANDLER_DEBUG) {
                _log.severe("Client " + this.toString() + " - Disconnected, too many unknown packets in non-authed state.");
            }
            this.closeNow();
        }
    }

    public void execute(ReceivablePacket<L2GameClient> packet) {
        block11: {
            if (this.getStats().countFloods()) {
                _log.severe("Client " + this.toString() + " - Disconnected, too many floods:" + this.getStats().longFloods + " long and " + this.getStats().shortFloods + " short.");
                this.closeNow();
                return;
            }
            if (!this._packetQueue.offer(packet)) {
                if (this.getStats().countQueueOverflow()) {
                    _log.severe("Client " + this.toString() + " - Disconnected, too many queue overflows.");
                    this.closeNow();
                } else {
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                }
                return;
            }
            if (this._queueLock.isLocked()) {
                return;
            }
            try {
                if (this._state == GameClientState.CONNECTED) {
                    if (this.getStats().processedPackets > 3) {
                        if (Config.PACKET_HANDLER_DEBUG) {
                            _log.severe("Client " + this.toString() + " - Disconnected, too many packets in non-authed state.");
                        }
                        this.closeNow();
                        return;
                    }
                    ThreadPoolManager.getInstance().executeIOPacket(this);
                } else {
                    ThreadPoolManager.getInstance().executePacket(this);
                }
            }
            catch (RejectedExecutionException e) {
                if (ThreadPoolManager.getInstance().isShutdown()) break block11;
                _log.severe("Failed executing: " + packet.getClass().getSimpleName() + " for Client: " + this.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this._queueLock.tryLock()) {
            return;
        }
        try {
            int count = 0;
            do {
                ReceivablePacket<L2GameClient> packet;
                if ((packet = this._packetQueue.poll()) == null) {
                    return;
                }
                if (this._isDetached) {
                    this._packetQueue.clear();
                    return;
                }
                try {
                    packet.run();
                }
                catch (Exception e) {
                    _log.severe("Exception during execution " + packet.getClass().getSimpleName() + ", client: " + this.toString() + "," + e.getMessage());
                }
            } while (!this.getStats().countBurst(++count));
            return;
        }
        finally {
            this._queueLock.unlock();
        }
    }

    public void setClientTracert(int[][] tracert) {
        this.trace = tracert;
    }

    public int[][] getTrace() {
        return this.trace;
    }

    private boolean cancelCleanup() {
        ScheduledFuture<?> task = this._cleanupTask;
        if (task != null) {
            this._cleanupTask = null;
            return task.cancel(true);
        }
        return false;
    }

    public void setAditionalClosePacket(L2GameServerPacket aditionalClosePacket) {
        this._aditionalClosePacket = aditionalClosePacket;
    }

    private class AutoSaveTask
    implements Runnable {
        private AutoSaveTask() {
        }

        @Override
        public void run() {
            try {
                L2PcInstance player = L2GameClient.this.getActiveChar();
                if (player != null && player.isOnline()) {
                    L2GameClient.this.saveCharToDisk();
                    if (player.getPet() != null) {
                        player.getPet().store();
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error on AutoSaveTask.", e);
            }
        }
    }

    private class CleanupTask
    implements Runnable {
        private CleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (L2GameClient.this._autoSaveInDB != null) {
                    L2GameClient.this._autoSaveInDB.cancel(true);
                }
                if (L2GameClient.this.getActiveChar() != null) {
                    if (L2GameClient.this.getActiveChar().isLocked()) {
                        _log.log(Level.WARNING, "Player " + L2GameClient.this.getActiveChar().getName() + " still performing subclass actions during disconnect.");
                    }
                    if (L2Event.isParticipant(L2GameClient.this.getActiveChar())) {
                        L2Event.savePlayerEventStatus(L2GameClient.this.getActiveChar());
                    }
                    L2GameClient.this.getActiveChar().setClient(null);
                    if (L2GameClient.this.getActiveChar().isOnline()) {
                        L2GameClient.this.getActiveChar().deleteMe();
                        AntiFeedManager.getInstance().onDisconnect(L2GameClient.this);
                    }
                }
                L2GameClient.this.setActiveChar(null);
            }
            catch (Exception e1) {
                _log.log(Level.WARNING, "Error while cleanup client.", e1);
            }
            finally {
                LoginServerThread.getInstance().sendLogout(L2GameClient.this.getAccountName());
            }
        }
    }

    private class DisconnectTask
    implements Runnable {
        private DisconnectTask() {
        }

        @Override
        public void run() {
            boolean fast = true;
            try {
                if (L2GameClient.this.getActiveChar() != null && !L2GameClient.this.isDetached()) {
                    L2GameClient.this.setDetached(true);
                    if (L2GameClient.this.offlineMode(L2GameClient.this.getActiveChar())) {
                        L2GameClient.this.getActiveChar().leaveParty();
                        if (L2GameClient.this.getActiveChar().getPet() != null) {
                            L2GameClient.this.getActiveChar().getPet().setRestoreSummon(true);
                            L2GameClient.this.getActiveChar().getPet().unSummon(L2GameClient.this.getActiveChar());
                            if (L2GameClient.this.getActiveChar().getPet() != null) {
                                L2GameClient.this.getActiveChar().getPet().broadcastNpcInfo(0);
                            }
                        }
                        if (Config.OFFLINE_MODE_SET_INVULNERABLE) {
                            L2GameClient.this.getActiveChar().setIsInvul(true);
                        }
                        if (Config.OFFLINE_SET_NAME_COLOR) {
                            L2GameClient.this.getActiveChar().getAppearance().setNameColor(Config.OFFLINE_NAME_COLOR);
                            L2GameClient.this.getActiveChar().broadcastUserInfo();
                        }
                        if (L2GameClient.this.getActiveChar().getOfflineStartTime() == 0L) {
                            L2GameClient.this.getActiveChar().setOfflineStartTime(System.currentTimeMillis());
                        }
                        LogRecord record = new LogRecord(Level.INFO, "Entering offline mode");
                        record.setParameters(new Object[]{L2GameClient.this});
                        _logAccounting.log(record);
                        return;
                    }
                    fast = !L2GameClient.this.getActiveChar().isInCombat() && !L2GameClient.this.getActiveChar().isLocked();
                }
                L2GameClient.this.cleanMe(fast);
            }
            catch (Exception e1) {
                _log.log(Level.WARNING, "Error while disconnecting client.", e1);
            }
        }
    }

    public static enum GameClientState {
        CONNECTED,
        AUTHED,
        IN_GAME;

    }
}

