/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExAutoSoulShot;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Logger;

public final class RequestAutoSoulShot
extends L2GameClientPacket {
    private static final String _C__D0_0D_REQUESTAUTOSOULSHOT = "[C] D0:0D RequestAutoSoulShot";
    private static Logger _log = Logger.getLogger(RequestAutoSoulShot.class.getName());
    private int _itemId;
    private int _type;

    @Override
    protected void readImpl() {
        this._itemId = this.readD();
        this._type = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.getPrivateStoreType() == 0 && activeChar.getActiveRequester() == null && !activeChar.isDead()) {
            L2ItemInstance item;
            if (Config.DEBUG) {
                _log.fine("AutoSoulShot:" + this._itemId);
            }
            if ((item = activeChar.getInventory().getItemByItemId(this._itemId)) == null) {
                return;
            }
            if (this._type == 1) {
                if (!activeChar.getInventory().canManipulateWithItemId(item.getItemId())) {
                    activeChar.sendMessage("Cannot use this item.");
                    return;
                }
                if (this._itemId < 6535 || this._itemId > 6540) {
                    if (this._itemId == 6645 || this._itemId == 6646 || this._itemId == 6647 || this._itemId == 20332 || this._itemId == 20333 || this._itemId == 20334) {
                        if (activeChar.getPet() != null) {
                            if (item.getEtcItem().getHandlerName().equals("BeastSoulShot")) {
                                if ((long)activeChar.getPet().getSoulShotsPerHit() > item.getCount()) {
                                    activeChar.sendPacket(SystemMessageId.NOT_ENOUGH_SOULSHOTS_FOR_PET);
                                    return;
                                }
                            } else if ((long)activeChar.getPet().getSpiritShotsPerHit() > item.getCount()) {
                                activeChar.sendPacket(SystemMessageId.NOT_ENOUGH_SOULSHOTS_FOR_PET);
                                return;
                            }
                            activeChar.addAutoSoulShot(this._itemId);
                            activeChar.sendPacket(new ExAutoSoulShot(this._itemId, this._type));
                            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.USE_OF_S1_WILL_BE_AUTO);
                            sm.addItemName(item);
                            activeChar.sendPacket(sm);
                            activeChar.rechargeAutoSoulShot(true, true, true);
                        } else {
                            activeChar.sendPacket(SystemMessageId.NO_SERVITOR_CANNOT_AUTOMATE_USE);
                        }
                    } else {
                        if (activeChar.getActiveWeaponItem() != activeChar.getFistsWeaponItem() && item.getItem().getCrystalType() == activeChar.getActiveWeaponItem().getItemGradeSPlus()) {
                            activeChar.addAutoSoulShot(this._itemId);
                            activeChar.sendPacket(new ExAutoSoulShot(this._itemId, this._type));
                        } else {
                            if (this._itemId >= 2509 && this._itemId <= 2514 || this._itemId >= 3947 && this._itemId <= 3952 || this._itemId == 5790 || this._itemId >= 22072 && this._itemId <= 22081) {
                                activeChar.sendPacket(SystemMessageId.SPIRITSHOTS_GRADE_MISMATCH);
                            } else {
                                activeChar.sendPacket(SystemMessageId.SOULSHOTS_GRADE_MISMATCH);
                            }
                            activeChar.addAutoSoulShot(this._itemId);
                            activeChar.sendPacket(new ExAutoSoulShot(this._itemId, this._type));
                        }
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.USE_OF_S1_WILL_BE_AUTO);
                        sm.addItemName(item);
                        activeChar.sendPacket(sm);
                        activeChar.rechargeAutoSoulShot(true, true, false);
                    }
                }
            } else if (this._type == 0) {
                activeChar.removeAutoSoulShot(this._itemId);
                activeChar.sendPacket(new ExAutoSoulShot(this._itemId, this._type));
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AUTO_USE_OF_S1_CANCELLED);
                sm.addItemName(item);
                activeChar.sendPacket(sm);
            }
        }
    }

    @Override
    public String getType() {
        return _C__D0_0D_REQUESTAUTOSOULSHOT;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

