/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class PackageSendableList
extends L2GameServerPacket {
    private static final String _S__D2_PACKAGESENDABLELIST = "[S] D2 PackageSendableList";
    private final L2ItemInstance[] _items;
    private final int _playerObjId;

    public PackageSendableList(L2ItemInstance[] items, int playerObjId) {
        this._items = items;
        this._playerObjId = playerObjId;
    }

    @Override
    protected void writeImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        this.writeC(210);
        this.writeD(this._playerObjId);
        this.writeQ(activeChar.getAdena());
        this.writeD(this._items.length);
        for (L2ItemInstance item : this._items) {
            this.writeD(item.getObjectId());
            this.writeD(item.getItemId());
            this.writeD(item.getLocationSlot());
            this.writeQ(item.getCount());
            this.writeH(item.getItem().getType2());
            this.writeH(item.getCustomType1());
            this.writeH(item.isEquipped() ? 1 : 0);
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchantLevel());
            this.writeH(item.getCustomType2());
            if (item.isAugmented()) {
                this.writeD(item.getAugmentation().getAugmentationId());
            } else {
                this.writeD(0);
            }
            this.writeD(item.getMana());
            this.writeD(item.isTimeLimitedItem() ? (int)(item.getRemainingTime() / 1000L) : -9999);
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
            this.writeD(item.getObjectId());
        }
    }

    @Override
    public String getType() {
        return _S__D2_PACKAGESENDABLELIST;
    }
}

