/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.security;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.Ex2ndPasswordAck;
import com.l2jserver.gameserver.network.serverpackets.Ex2ndPasswordCheck;
import com.l2jserver.gameserver.network.serverpackets.Ex2ndPasswordVerify;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecondaryPasswordAuth {
    private final Logger _log = Logger.getLogger(SecondaryPasswordAuth.class.getName());
    private final L2GameClient _activeClient;
    private String _password;
    private int _wrongAttempts;
    private boolean _authed;
    private static final String VAR_PWD = "secauth_pwd";
    private static final String VAR_WTE = "secauth_wte";
    private static final String SELECT_PASSWORD = "SELECT var, value FROM account_gsdata WHERE account_name=? AND var LIKE 'secauth_%'";
    private static final String INSERT_PASSWORD = "INSERT INTO account_gsdata VALUES (?, ?, ?)";
    private static final String UPDATE_PASSWORD = "UPDATE account_gsdata SET value=? WHERE account_name=? AND var=?";
    private static final String INSERT_ATTEMPT = "INSERT INTO account_gsdata VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE value=?";

    public SecondaryPasswordAuth(L2GameClient activeClient) {
        this._activeClient = activeClient;
        this._password = null;
        this._wrongAttempts = 0;
        this._authed = false;
        this.loadPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPassword() {
        String value = null;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(SELECT_PASSWORD);
            statement.setString(1, this._activeClient.getAccountName());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                String var = rs.getString("var");
                value = rs.getString("value");
                if (var.equals(VAR_PWD)) {
                    this._password = value;
                    continue;
                }
                if (!var.equals(VAR_WTE)) continue;
                this._wrongAttempts = Integer.parseInt(value);
            }
            statement.close();
        }
        catch (Exception e) {
            this._log.log(Level.SEVERE, "Error while reading password.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePassword(String password) {
        if (this.passwordExist()) {
            this._log.warning("[SecondaryPasswordAuth]" + this._activeClient.getAccountName() + " forced savePassword");
            this._activeClient.closeNow();
            return false;
        }
        if (!this.validatePassword(password)) {
            this._activeClient.sendPacket(new Ex2ndPasswordAck(Ex2ndPasswordAck.WRONG_PATTERN));
            return false;
        }
        password = this.cryptPassword(password);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(INSERT_PASSWORD);
            statement.setString(1, this._activeClient.getAccountName());
            statement.setString(2, VAR_PWD);
            statement.setString(3, password);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            this._log.log(Level.SEVERE, "Error while writing password.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this._password = password;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertWrongAttempt(int attempts) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(INSERT_ATTEMPT);
            statement.setString(1, this._activeClient.getAccountName());
            statement.setString(2, VAR_WTE);
            statement.setString(3, Integer.toString(attempts));
            statement.setString(4, Integer.toString(attempts));
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            this._log.log(Level.SEVERE, "Error while writing wrong attempts.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changePassword(String oldPassword, String newPassword) {
        if (!this.passwordExist()) {
            this._log.warning("[SecondaryPasswordAuth]" + this._activeClient.getAccountName() + " forced changePassword");
            this._activeClient.closeNow();
            return false;
        }
        if (!this.checkPassword(oldPassword, true)) {
            return false;
        }
        if (!this.validatePassword(newPassword)) {
            this._activeClient.sendPacket(new Ex2ndPasswordAck(Ex2ndPasswordAck.WRONG_PATTERN));
            return false;
        }
        newPassword = this.cryptPassword(newPassword);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(UPDATE_PASSWORD);
            statement.setString(1, newPassword);
            statement.setString(2, this._activeClient.getAccountName());
            statement.setString(3, VAR_PWD);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            this._log.log(Level.SEVERE, "Error while reading password.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this._password = newPassword;
        this._authed = false;
        return true;
    }

    public boolean checkPassword(String password, boolean skipAuth) {
        if (!(password = this.cryptPassword(password)).equals(this._password)) {
            ++this._wrongAttempts;
            if (this._wrongAttempts < Config.SECOND_AUTH_MAX_ATTEMPTS) {
                this._activeClient.sendPacket(new Ex2ndPasswordVerify(1, this._wrongAttempts));
                this.insertWrongAttempt(this._wrongAttempts);
                return false;
            }
            LoginServerThread.getInstance().sendTempBan(this._activeClient.getAccountName(), this._activeClient.getConnectionAddress().getHostAddress(), Config.SECOND_AUTH_BAN_TIME);
            LoginServerThread.getInstance().sendMail(this._activeClient.getAccountName(), "SATempBan", this._activeClient.getConnectionAddress().getHostAddress(), Integer.toString(Config.SECOND_AUTH_MAX_ATTEMPTS), Long.toString(Config.SECOND_AUTH_BAN_TIME), Config.SECOND_AUTH_REC_LINK);
            this._log.warning(this._activeClient.getAccountName() + " - (" + this._activeClient.getConnectionAddress().getHostAddress() + ") has inputted the wrong password " + this._wrongAttempts + " times in row.");
            this.insertWrongAttempt(0);
            this._activeClient.close(new Ex2ndPasswordVerify(2, Config.SECOND_AUTH_MAX_ATTEMPTS));
            return false;
        }
        if (!skipAuth) {
            this._authed = true;
            this._activeClient.sendPacket(new Ex2ndPasswordVerify(0, this._wrongAttempts));
        }
        this.insertWrongAttempt(0);
        return true;
    }

    public boolean passwordExist() {
        return this._password != null;
    }

    public void openDialog() {
        if (this.passwordExist()) {
            this._activeClient.sendPacket(new Ex2ndPasswordCheck(1));
        } else {
            this._activeClient.sendPacket(new Ex2ndPasswordCheck(0));
        }
    }

    public boolean isAuthed() {
        return this._authed;
    }

    private String cryptPassword(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] raw = password.getBytes("UTF-8");
            byte[] hash = md.digest(raw);
            return Base64.encodeBytes(hash);
        }
        catch (NoSuchAlgorithmException e) {
            this._log.severe("[SecondaryPasswordAuth]Unsupported Algorythm");
        }
        catch (UnsupportedEncodingException e) {
            this._log.severe("[SecondaryPasswordAuth]Unsupported Encoding");
        }
        return null;
    }

    private boolean validatePassword(String password) {
        int i;
        if (!Util.isDigit(password)) {
            return false;
        }
        if (password.length() < 6 || password.length() > 8) {
            return false;
        }
        for (i = 0; i < password.length() - 1; ++i) {
            char nxtCh;
            char curCh = password.charAt(i);
            if (curCh + '\u0001' == (nxtCh = password.charAt(i + 1))) {
                return false;
            }
            if (curCh - '\u0001' == nxtCh) {
                return false;
            }
            if (curCh != nxtCh) continue;
            return false;
        }
        for (i = 0; i < password.length() - 2; ++i) {
            StringBuffer chkEr;
            String toChk = password.substring(i + 1);
            if (toChk.contains(chkEr = new StringBuffer(password.substring(i, i + 2)))) {
                return false;
            }
            if (!toChk.contains(chkEr.reverse())) continue;
            return false;
        }
        this._wrongAttempts = 0;
        return true;
    }
}

