/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.instancemanager.RaidBossPointsManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Logger;

public class TaskRaidPointsReset
extends Task {
    private static final Logger _log = Logger.getLogger(TaskRaidPointsReset.class.getName());
    public static final String NAME = "raid_points_reset";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        Calendar cal = Calendar.getInstance();
        if (cal.get(7) == 2) {
            Map<Integer, Integer> rankList = RaidBossPointsManager.getInstance().getRankList();
            for (L2Clan c : ClanTable.getInstance().getClans()) {
                for (Map.Entry<Integer, Integer> entry : rankList.entrySet()) {
                    if (entry.getValue() > 100 || !c.isMember(entry.getKey())) continue;
                    int reputation = 0;
                    switch (entry.getValue()) {
                        case 1: {
                            reputation = Config.RAID_RANKING_1ST;
                            break;
                        }
                        case 2: {
                            reputation = Config.RAID_RANKING_2ND;
                            break;
                        }
                        case 3: {
                            reputation = Config.RAID_RANKING_3RD;
                            break;
                        }
                        case 4: {
                            reputation = Config.RAID_RANKING_4TH;
                            break;
                        }
                        case 5: {
                            reputation = Config.RAID_RANKING_5TH;
                            break;
                        }
                        case 6: {
                            reputation = Config.RAID_RANKING_6TH;
                            break;
                        }
                        case 7: {
                            reputation = Config.RAID_RANKING_7TH;
                            break;
                        }
                        case 8: {
                            reputation = Config.RAID_RANKING_8TH;
                            break;
                        }
                        case 9: {
                            reputation = Config.RAID_RANKING_9TH;
                            break;
                        }
                        case 10: {
                            reputation = Config.RAID_RANKING_10TH;
                            break;
                        }
                        default: {
                            reputation = entry.getValue() <= 50 ? Config.RAID_RANKING_UP_TO_50TH : Config.RAID_RANKING_UP_TO_100TH;
                        }
                    }
                    c.addReputationScore(reputation, true);
                }
            }
            RaidBossPointsManager.getInstance().cleanUp();
            _log.info("Raid Points Reset Global Task: launched.");
        }
    }

    @Override
    public void initializate() {
        super.initializate();
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", "00:10:00", "");
    }
}

