/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates.effects;

import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.model.ChanceCondition;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.skills.AbnormalEffect;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.conditions.Condition;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.skills.funcs.Lambda;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EffectTemplate {
    static Logger _log = Logger.getLogger(EffectTemplate.class.getName());
    private final Class<?> _func;
    private final Constructor<?> _constructor;
    public final Condition attachCond;
    public final Condition applayCond;
    public final Lambda lambda;
    public final int counter;
    public final int abnormalTime;
    public final AbnormalEffect abnormalEffect;
    public final AbnormalEffect[] specialEffect;
    public final AbnormalEffect eventEffect;
    public FuncTemplate[] funcTemplates;
    public final String abnormalType;
    public final byte abnormalLvl;
    public final boolean icon;
    public final String funcName;
    public final double effectPower;
    public final L2SkillType effectType;
    public final int triggeredId;
    public final int triggeredLevel;
    public final ChanceCondition chanceCondition;

    public EffectTemplate(Condition pAttachCond, Condition pApplayCond, String func, Lambda pLambda, int pCounter, int pAbnormalTime, AbnormalEffect pAbnormalEffect, AbnormalEffect[] pSpecialEffect, AbnormalEffect pEventEffect, String pAbnormalType, byte pAbnormalLvl, boolean showicon, double ePower, L2SkillType eType, int trigId, int trigLvl, ChanceCondition chanceCond) {
        this.attachCond = pAttachCond;
        this.applayCond = pApplayCond;
        this.lambda = pLambda;
        this.counter = pCounter;
        this.abnormalTime = pAbnormalTime;
        this.abnormalEffect = pAbnormalEffect;
        this.specialEffect = pSpecialEffect;
        this.eventEffect = pEventEffect;
        this.abnormalType = StringIntern.intern(pAbnormalType);
        this.abnormalLvl = pAbnormalLvl;
        this.icon = showicon;
        this.funcName = StringIntern.intern(func);
        this.effectPower = ePower;
        this.effectType = eType;
        this.triggeredId = trigId;
        this.triggeredLevel = trigLvl;
        this.chanceCondition = chanceCond;
        try {
            this._func = Class.forName("com.l2jserver.gameserver.skills.effects.Effect" + func);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            this._constructor = this._func.getConstructor(Env.class, EffectTemplate.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public L2Effect getEffect(Env env) {
        if (this.attachCond != null && !this.attachCond.test(env)) {
            return null;
        }
        try {
            L2Effect effect = (L2Effect)this._constructor.newInstance(env, this);
            return effect;
        }
        catch (IllegalAccessException e) {
            _log.log(Level.WARNING, "", e);
            return null;
        }
        catch (InstantiationException e) {
            _log.log(Level.WARNING, "", e);
            return null;
        }
        catch (InvocationTargetException e) {
            _log.log(Level.WARNING, "Error creating new instance of Class " + this._func + " Exception was: " + e.getTargetException().getMessage(), e.getTargetException());
            return null;
        }
    }

    public L2Effect getStolenEffect(Env env, L2Effect stolen) {
        Constructor<?> stolenCons;
        Class<?> func;
        try {
            func = Class.forName("com.l2jserver.gameserver.skills.effects.Effect" + stolen.getEffectTemplate().funcName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            stolenCons = func.getConstructor(Env.class, L2Effect.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            L2Effect effect = (L2Effect)stolenCons.newInstance(env, stolen);
            return effect;
        }
        catch (IllegalAccessException e) {
            _log.log(Level.WARNING, "", e);
            return null;
        }
        catch (InstantiationException e) {
            _log.log(Level.WARNING, "", e);
            return null;
        }
        catch (InvocationTargetException e) {
            _log.log(Level.WARNING, "Error creating new instance of Class " + func + " Exception was: " + e.getTargetException().getMessage(), e.getTargetException());
            return null;
        }
    }

    public void attach(FuncTemplate f) {
        if (this.funcTemplates == null) {
            this.funcTemplates = new FuncTemplate[]{f};
        } else {
            int len = this.funcTemplates.length;
            FuncTemplate[] tmp = new FuncTemplate[len + 1];
            System.arraycopy(this.funcTemplates, 0, tmp, 0, len);
            tmp[len] = f;
            this.funcTemplates = tmp;
        }
    }
}

