/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.status;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GmListTable;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.Shutdown;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.MultiSell;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.datatables.TeleportLocationTable;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.instancemanager.Manager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.RaidBossSpawnManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.util.GMAudit;
import com.l2jserver.status.TelnetExec;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javolution.util.FastComparator;
import javolution.util.FastTable;

public class GameStatusThread
extends Thread {
    private final Socket _cSocket;
    private final PrintWriter _print;
    private final BufferedReader _read;
    private final int _uptime;

    private void telnetOutput(int type, String text) {
        if (Config.DEVELOPER) {
            if (type == 1) {
                System.out.println("TELNET | " + text);
            } else if (type == 2) {
                System.out.print("TELNET | " + text);
            } else if (type == 3) {
                System.out.print(text);
            } else if (type == 4) {
                System.out.println(text);
            } else {
                System.out.println("TELNET | " + text);
            }
        } else if (type == 5) {
            System.out.println("TELNET | " + text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidIP(Socket client) {
        boolean result = false;
        InetAddress ClientIP = client.getInetAddress();
        String clientStringIP = ClientIP.getHostAddress();
        this.telnetOutput(1, "Connection from: " + clientStringIP);
        if (Config.DEVELOPER) {
            this.telnetOutput(2, "");
        }
        InputStream telnetIS = null;
        try {
            Properties telnetSettings = new Properties();
            telnetIS = new FileInputStream(new File("./config/telnet.properties"));
            telnetSettings.load(telnetIS);
            String HostList = telnetSettings.getProperty("ListOfHosts", "127.0.0.1,localhost,::1");
            if (Config.DEVELOPER) {
                this.telnetOutput(3, "Comparing ip to list...");
            }
            String ipToCompare = null;
            for (String ip : HostList.split(",")) {
                if (result) continue;
                ipToCompare = InetAddress.getByName(ip).getHostAddress();
                if (clientStringIP.equals(ipToCompare)) {
                    result = true;
                }
                if (!Config.DEVELOPER) continue;
                this.telnetOutput(3, clientStringIP + " = " + ipToCompare + "(" + ip + ") = " + result);
            }
        }
        catch (IOException e) {
            if (Config.DEVELOPER) {
                this.telnetOutput(4, "");
            }
            this.telnetOutput(1, "Error: " + e);
        }
        finally {
            try {
                telnetIS.close();
            }
            catch (Exception e) {}
        }
        if (Config.DEVELOPER) {
            this.telnetOutput(4, "Allow IP: " + result);
        }
        return result;
    }

    public GameStatusThread(Socket client, int uptime, String StatusPW) throws IOException {
        this.setPriority(10);
        this._cSocket = client;
        this._uptime = uptime;
        this._print = new PrintWriter(this._cSocket.getOutputStream());
        this._read = new BufferedReader(new InputStreamReader(this._cSocket.getInputStream()));
        if (this.isValidIP(client)) {
            this.telnetOutput(1, client.getInetAddress().getHostAddress() + " accepted.");
            this._print.println("Welcome To The L2J Telnet Session.");
            this._print.println("Please Insert Your Password!");
            this._print.print("Password: ");
            this._print.flush();
            String tmpLine = this._read.readLine();
            if (tmpLine == null) {
                this._print.println("Error.");
                this._print.println("Disconnected...");
                this._print.flush();
                this._cSocket.close();
            } else if (tmpLine.compareTo(StatusPW) != 0) {
                this._print.println("Incorrect Password!");
                this._print.println("Disconnected...");
                this._print.flush();
                this._cSocket.close();
            } else {
                this._print.println("Password Correct!");
                this._print.println("[L2J Game Server]");
                this._print.print("");
                this._print.flush();
                this.start();
            }
        } else {
            this.telnetOutput(5, "Connection attempt from " + client.getInetAddress().getHostAddress() + " rejected.");
            this._cSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        _usrCommand = "";
        try {
            while (_usrCommand.compareTo("quit") != 0 && _usrCommand.compareTo("exit") != 0) {
                block164: {
                    _usrCommand = this._read.readLine();
                    if (_usrCommand == null) {
                        this._cSocket.close();
                        break;
                    }
                    if (_usrCommand.equals("help")) {
                        this._print.println("The following is a list of all available commands: ");
                        this._print.println("help                  - shows this help.");
                        this._print.println("status                - displays basic server statistics.");
                        this._print.println("gamestat privatestore - displays info about stores");
                        this._print.println("performance           - shows server performance statistics.");
                        this._print.println("forcegc               - forced garbage collection.");
                        this._print.println("purge                 - removes finished threads from thread pools.");
                        this._print.println("memusage              - displays memory amounts in JVM.");
                        this._print.println("announce <text>       - announces <text> in game.");
                        this._print.println("msg <nick> <text>     - Sends a whisper to char <nick> with <text>.");
                        this._print.println("gmchat <text>         - Sends a message to all GMs with <text>.");
                        this._print.println("gmlist                - lists all gms online.");
                        this._print.println("kick                  - kick player <name> from server.");
                        this._print.println("shutdown <time>       - shuts down server in <time> seconds.");
                        this._print.println("restart <time>        - restarts down server in <time> seconds.");
                        this._print.println("abort                 - aborts shutdown/restart.");
                        this._print.println("give <player> <itemid> <amount>");
                        this._print.println("enchant <player> <itemType> <enchant> (itemType: 1 - Helmet, 2 - Chest, 3 - Gloves, 4 - Feet, 5 - Legs, 6 - Right Hand, 7 - Left Hand, 8 - Left Ear, 9 - Right Ear , 10 - Left Finger, 11 - Right Finger, 12- Necklace, 13 - Underwear, 14 - Back, 15 - Belt, 0 - No Enchant)");
                        this._print.println("debug <cmd>           - executes the debug command (see 'help debug').");
                        this._print.println("reload <type>         - reload data");
                        this._print.println("jail <player> [time]");
                        this._print.println("unjail <player>");
                        this._print.println("quit                  - closes telnet session.");
                    } else if (_usrCommand.equals("help debug")) {
                        this._print.println("The following is a list of all available debug commands: ");
                        this._print.println("full                - Dumps complete debug information to an file (recommended)");
                        this._print.println("decay               - prints info about the DecayManager");
                        this._print.println("PacketTP            - prints info about the General Packet ThreadPool");
                        this._print.println("IOPacketTP          - prints info about the I/O Packet ThreadPool");
                        this._print.println("GeneralTP           - prints info about the General ThreadPool");
                    } else if (_usrCommand.equals("status")) {
                        this._print.print(this.getServerStatus());
                        this._print.flush();
                    } else if (_usrCommand.equals("forcegc")) {
                        System.gc();
                        sb = new StringBuilder(256);
                        sb.append("RAM Used: ").append((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
                        this._print.println(sb.toString());
                    } else if (_usrCommand.equals("performance")) {
                        for (String line : ThreadPoolManager.getInstance().getStats()) {
                            this._print.println(line);
                        }
                        this._print.flush();
                    } else if (_usrCommand.equals("purge")) {
                        ThreadPoolManager.getInstance().purge();
                        this._print.println("STATUS OF THREAD POOLS AFTER PURGE COMMAND:");
                        this._print.println("");
                        for (String line : ThreadPoolManager.getInstance().getStats()) {
                            this._print.println(line);
                        }
                        this._print.flush();
                    } else if (_usrCommand.startsWith("memusage")) {
                        max = Runtime.getRuntime().maxMemory() / 1024L;
                        allocated = Runtime.getRuntime().totalMemory() / 1024L;
                        nonAllocated = max - allocated;
                        cached = Runtime.getRuntime().freeMemory() / 1024L;
                        used = allocated - cached;
                        useable = max - used;
                        df = new DecimalFormat(" (0.0000'%')");
                        df2 = new DecimalFormat(" # 'KB'");
                        this._print.println("+----");
                        this._print.println("| Allowed Memory:" + df2.format(max));
                        this._print.println("|    |= Allocated Memory:" + df2.format(allocated) + df.format(allocated / max * 100.0));
                        this._print.println("|    |= Non-Allocated Memory:" + df2.format(nonAllocated) + df.format(nonAllocated / max * 100.0));
                        this._print.println("| Allocated Memory:" + df2.format(allocated));
                        this._print.println("|    |= Used Memory:" + df2.format(used) + df.format(used / max * 100.0));
                        this._print.println("|    |= Unused (cached) Memory:" + df2.format(cached) + df.format(cached / max * 100.0));
                        this._print.println("| Useable Memory:" + df2.format(useable) + df.format(useable / max * 100.0));
                        this._print.println("+----");
                    } else if (_usrCommand.startsWith("announce")) {
                        try {
                            _usrCommand = _usrCommand.substring(9);
                            Announcements.getInstance().announceToAll(_usrCommand);
                            this._print.println("Announcement Sent!");
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            this._print.println("Please Enter Some Text To Announce!");
                        }
                    } else if (_usrCommand.startsWith("msg")) {
                        try {
                            val = _usrCommand.substring(4);
                            st = new StringTokenizer(val);
                            name = st.nextToken();
                            message = val.substring(name.length() + 1);
                            reciever = L2World.getInstance().getPlayer(name);
                            cs = new CreatureSay(0, 2, "Telnet Priv", message);
                            if (reciever != null) {
                                reciever.sendPacket(cs);
                                this._print.println("Telnet Priv->" + name + ": " + message);
                                this._print.println("Message Sent!");
                                break block164;
                            }
                            this._print.println("Unable To Find Username: " + name);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            this._print.println("Please Enter Some Text!");
                        }
                    } else if (_usrCommand.startsWith("gmchat")) {
                        try {
                            _usrCommand = _usrCommand.substring(7);
                            cs = new CreatureSay(0, 9, "Telnet GM Broadcast from " + this._cSocket.getInetAddress().getHostAddress(), _usrCommand);
                            GmListTable.broadcastToGMs(cs);
                            this._print.println("Your Message Has Been Sent To " + this.getOnlineGMS() + " GM(s).");
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            this._print.println("Please Enter Some Text To Announce!");
                        }
                    } else if (_usrCommand.equals("gmlist")) {
                        igm = 0;
                        gmList = "";
                        for (String player : GmListTable.getInstance().getAllGmNames(true)) {
                            gmList = gmList + ", " + player;
                            ++igm;
                        }
                        this._print.println("There are currently " + igm + " GM(s) online...");
                        if (!gmList.isEmpty()) {
                            this._print.println(gmList);
                        }
                    } else if (_usrCommand.startsWith("kick")) {
                        try {
                            _usrCommand = _usrCommand.substring(5);
                            player = L2World.getInstance().getPlayer(_usrCommand);
                            if (player != null) {
                                player.sendMessage("You are kicked by gm");
                                player.logout();
                                this._print.println("Player kicked");
                            }
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            this._print.println("Please enter player name to kick");
                        }
                    } else if (_usrCommand.startsWith("shutdown")) {
                        try {
                            val = Integer.parseInt(_usrCommand.substring(9));
                            Shutdown.getInstance().startTelnetShutdown(this._cSocket.getInetAddress().getHostAddress(), val, false);
                            this._print.println("Server Will Shutdown In " + val + " Seconds!");
                            this._print.println("Type \"abort\" To Abort Shutdown!");
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            this._print.println("Please Enter * amount of seconds to shutdown!");
                        }
                        catch (Exception NumberFormatException) {
                            this._print.println("Numbers Only!");
                        }
                    } else if (_usrCommand.startsWith("restart")) {
                        try {
                            val = Integer.parseInt(_usrCommand.substring(8));
                            Shutdown.getInstance().startTelnetShutdown(this._cSocket.getInetAddress().getHostAddress(), val, true);
                            this._print.println("Server Will Restart In " + val + " Seconds!");
                            this._print.println("Type \"abort\" To Abort Restart!");
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            this._print.println("Please Enter * amount of seconds to restart!");
                        }
                        catch (Exception NumberFormatException) {
                            this._print.println("Numbers Only!");
                        }
                    } else if (_usrCommand.startsWith("abort")) {
                        Shutdown.getInstance().telnetAbort(this._cSocket.getInetAddress().getHostAddress());
                        this._print.println("OK! - Shutdown/Restart Aborted.");
                    } else if (!_usrCommand.equals("quit")) {
                        if (_usrCommand.startsWith("give")) {
                            st = new StringTokenizer(_usrCommand.substring(5));
                            try {
                                player = L2World.getInstance().getPlayer(st.nextToken());
                                itemId = Integer.parseInt(st.nextToken());
                                amount = Integer.parseInt(st.nextToken());
                                if (player != null) {
                                    item = player.getInventory().addItem("Status-Give", itemId, amount, null, null);
                                    iu = new InventoryUpdate();
                                    iu.addItem(item);
                                    player.sendPacket(iu);
                                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1_S2);
                                    sm.addItemName(itemId);
                                    sm.addItemNumber(amount);
                                    player.sendPacket(sm);
                                    this._print.println("ok");
                                    GMAudit.auditGMAction("Telnet Admin", "Give Item", player.getName(), "item: " + itemId + " amount: " + amount);
                                    break block164;
                                }
                                this._print.println("Player not found");
                            }
                            catch (Exception e) {}
                        } else if (_usrCommand.startsWith("enchant")) {
                            st = new StringTokenizer(_usrCommand.substring(8), " ");
                            enchant = 0;
                            itemType = 0;
                            try {
                                player = L2World.getInstance().getPlayer(st.nextToken());
                                itemType = Integer.parseInt(st.nextToken());
                                enchant = Integer.parseInt(st.nextToken());
                                switch (itemType) {
                                    case 1: {
                                        itemType = 1;
                                        break;
                                    }
                                    case 2: {
                                        itemType = 6;
                                        break;
                                    }
                                    case 3: {
                                        itemType = 10;
                                        break;
                                    }
                                    case 4: {
                                        itemType = 12;
                                        break;
                                    }
                                    case 5: {
                                        itemType = 11;
                                        break;
                                    }
                                    case 6: {
                                        itemType = 5;
                                        break;
                                    }
                                    case 7: {
                                        itemType = 7;
                                        break;
                                    }
                                    case 8: {
                                        itemType = 9;
                                        break;
                                    }
                                    case 9: {
                                        itemType = 8;
                                        break;
                                    }
                                    case 10: {
                                        itemType = 14;
                                        break;
                                    }
                                    case 11: {
                                        itemType = 13;
                                        break;
                                    }
                                    case 12: {
                                        itemType = 4;
                                        break;
                                    }
                                    case 13: {
                                        itemType = 0;
                                        break;
                                    }
                                    case 14: {
                                        itemType = 23;
                                        break;
                                    }
                                    case 15: {
                                        itemType = 24;
                                        break;
                                    }
                                    default: {
                                        itemType = 0;
                                    }
                                }
                                if (enchant > 65535) {
                                    enchant = 65535;
                                } else if (enchant < 0) {
                                    enchant = 0;
                                }
                                success = false;
                                if (player != null && itemType > 0) {
                                    success = this.setEnchant(player, enchant, itemType);
                                    if (success) {
                                        this._print.println("Item enchanted successfully.");
                                    }
                                } else if (!success) {
                                    this._print.println("Item failed to enchant.");
                                }
                            }
                            catch (Exception e) {}
                        } else {
                            if (_usrCommand.startsWith("jail")) {
                                st = new StringTokenizer(_usrCommand.substring(5));
                                try {
                                    playerName = st.nextToken();
                                    playerObj = L2World.getInstance().getPlayer(playerName);
                                    delay = 0;
                                    try {
                                        delay = Integer.parseInt(st.nextToken());
                                    }
                                    catch (NumberFormatException nfe) {
                                    }
                                    catch (NoSuchElementException nsee) {
                                        // empty catch block
                                    }
                                    if (playerObj != null) {
                                        playerObj.setPunishLevel(L2PcInstance.PunishLevel.JAIL, delay);
                                        this._print.println("Character " + playerObj.getName() + " jailed for " + (delay > 0 ? delay + " minutes." : "ever!"));
                                        break block164;
                                    }
                                    this.jailOfflinePlayer(playerName, delay);
                                }
                                catch (NoSuchElementException nsee) {
                                    this._print.println("Specify a character name.");
                                }
                                catch (Exception e) {
                                    if (Config.DEBUG) {
                                        e.printStackTrace();
                                    }
                                    break block164;
                                }
                            }
                            if (_usrCommand.startsWith("unjail")) {
                                st = new StringTokenizer(_usrCommand.substring(7));
                                try {
                                    playerName = st.nextToken();
                                    playerObj = L2World.getInstance().getPlayer(playerName);
                                    if (playerObj != null) {
                                        playerObj.setPunishLevel(L2PcInstance.PunishLevel.NONE, 0);
                                        this._print.println("Character " + playerObj.getName() + " removed from jail");
                                        break block164;
                                    }
                                    this.unjailOfflinePlayer(playerName);
                                }
                                catch (NoSuchElementException nsee) {
                                    this._print.println("Specify a character name.");
                                }
                                catch (Exception e) {
                                    if (Config.DEBUG) {
                                        e.printStackTrace();
                                    }
                                    break block164;
                                }
                            }
                            if (_usrCommand.startsWith("debug") && _usrCommand.length() > 6) {
                                st = new StringTokenizer(_usrCommand.substring(6));
                                fos = null;
                                out = null;
                                try {
                                    dbg = st.nextToken();
                                    if (dbg.equals("decay")) {
                                        this._print.print(DecayTaskManager.getInstance().toString());
                                    }
                                    if (dbg.equals("ai")) {
                                    }
                                    if (dbg.equals("aiflush")) {
                                    }
                                    if (dbg.equals("PacketTP")) {
                                        str = ThreadPoolManager.getInstance().getPacketStats();
                                        this._print.println(str);
                                        i = 0;
                                        f = new File("./log/StackTrace-PacketTP-" + i + ".txt");
                                        while (f.exists()) {
                                            f = new File("./log/StackTrace-PacketTP-" + ++i + ".txt");
                                        }
                                        f.getParentFile().mkdirs();
                                        fos = new FileOutputStream(f);
                                        out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                        out.write(str);
                                    }
                                    if (dbg.equals("IOPacketTP")) {
                                        str = ThreadPoolManager.getInstance().getIOPacketStats();
                                        this._print.println(str);
                                        i = 0;
                                        f = new File("./log/StackTrace-IOPacketTP-" + i + ".txt");
                                        while (f.exists()) {
                                            f = new File("./log/StackTrace-IOPacketTP-" + ++i + ".txt");
                                        }
                                        f.getParentFile().mkdirs();
                                        fos = new FileOutputStream(f);
                                        out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                        out.write(str);
                                    }
                                    if (dbg.equals("GeneralTP")) {
                                        str = ThreadPoolManager.getInstance().getGeneralStats();
                                        this._print.println(str);
                                        i = 0;
                                        f = new File("./log/StackTrace-GeneralTP-" + i + ".txt");
                                        while (f.exists()) {
                                            f = new File("./log/StackTrace-GeneralTP-" + ++i + ".txt");
                                        }
                                        f.getParentFile().mkdirs();
                                        fos = new FileOutputStream(f);
                                        out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                        out.write(str);
                                    }
                                    if (!dbg.equals("full")) ** GOTO lbl481
                                    this.debugAll();
                                }
                                catch (Exception e) {
                                }
                                finally {
                                    try {
                                        out.close();
                                    }
                                    catch (Exception e) {}
                                    try {
                                        fos.close();
                                    }
                                    catch (Exception e) {}
                                }
                            } else if (_usrCommand.startsWith("reload")) {
                                st = new StringTokenizer(_usrCommand.substring(7));
                                try {
                                    type = st.nextToken();
                                    if (type.equals("multisell")) {
                                        this._print.print("Reloading multisell... ");
                                        MultiSell.getInstance().reload();
                                        this._print.println("done");
                                    } else if (type.equals("skill")) {
                                        this._print.print("Reloading skills... ");
                                        SkillTable.getInstance().reload();
                                        this._print.println("done");
                                    } else if (type.equals("npc")) {
                                        this._print.print("Reloading npc templates... ");
                                        NpcTable.getInstance().reloadAllNpc();
                                        QuestManager.getInstance().reloadAllQuests();
                                        this._print.println("done");
                                    } else if (type.equals("html")) {
                                        this._print.print("Reloading html cache... ");
                                        HtmCache.getInstance().reload();
                                        this._print.println("done");
                                    } else if (type.equals("item")) {
                                        this._print.print("Reloading item templates... ");
                                        ItemTable.getInstance().reload();
                                        this._print.println("done");
                                    } else if (type.equals("instancemanager")) {
                                        this._print.print("Reloading instance managers... ");
                                        Manager.reloadAll();
                                        this._print.println("done");
                                    } else if (type.equals("zone")) {
                                        this._print.print("Reloading zone tables... ");
                                        ZoneManager.getInstance().reload();
                                        this._print.println("done");
                                    } else if (type.equals("teleports")) {
                                        this._print.print("Reloading telport location table... ");
                                        TeleportLocationTable.getInstance().reloadAll();
                                        this._print.println("done");
                                    } else if (type.equals("spawns")) {
                                        this._print.print("Reloading spawns... ");
                                        RaidBossSpawnManager.getInstance().cleanUp();
                                        DayNightSpawnManager.getInstance().cleanUp();
                                        L2World.getInstance().deleteVisibleNpcSpawns();
                                        NpcTable.getInstance().reloadAllNpc();
                                        SpawnTable.getInstance().reloadAll();
                                        RaidBossSpawnManager.getInstance().reloadBosses();
                                        this._print.println("done\n");
                                    }
                                }
                                catch (Exception e) {}
                            } else if (_usrCommand.startsWith("gamestat")) {
                                st = new StringTokenizer(_usrCommand.substring(9));
                                try {
                                    type = st.nextToken();
                                    if (!type.equals("privatestore")) ** GOTO lbl481
                                    for (L2PcInstance player : L2World.getInstance().getAllPlayersArray()) {
                                        if (player.getPrivateStoreType() == 0) continue;
                                        list = null;
                                        content = "";
                                        if (player.getPrivateStoreType() == 1) {
                                            list = player.getSellList();
                                            for (TradeList.TradeItem item : list.getItems()) {
                                                content = content + item.getItem().getItemId() + ":" + item.getEnchant() + ":" + item.getPrice() + ":";
                                            }
                                            content = player.getName() + ";" + "sell;" + player.getX() + ";" + player.getY() + ";" + content;
                                            this._print.println(content);
                                            continue;
                                        }
                                        if (player.getPrivateStoreType() != 3) continue;
                                        list = player.getBuyList();
                                        for (TradeList.TradeItem item : list.getItems()) {
                                            content = content + item.getItem().getItemId() + ":" + item.getEnchant() + ":" + item.getPrice() + ":";
                                        }
                                        content = player.getName() + ";" + "buy;" + player.getX() + ";" + player.getY() + ";" + content;
                                        this._print.println(content);
                                    }
                                }
                                catch (Exception var3_46) {}
                            } else if (_usrCommand.startsWith("!")) {
                                exitValue = new TelnetExec(this._print).exec(_usrCommand.substring(1));
                                this._print.println("*ERROELEVEL=" + exitValue);
                            } else if (_usrCommand.length() == 0) {
                                // empty if block
                            }
                        }
                    }
                }
                this._print.print("");
                this._print.flush();
            }
            if (!this._cSocket.isClosed()) {
                this._print.println("Bye Bye!");
                this._print.flush();
                this._cSocket.close();
            }
            this.telnetOutput(1, "Connection from " + this._cSocket.getInetAddress().getHostAddress() + " was closed by client.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean setEnchant(L2PcInstance activeChar, int ench, int armorType) {
        int curEnchant = 0;
        L2ItemInstance itemInstance = null;
        L2ItemInstance parmorInstance = activeChar.getInventory().getPaperdollItem(armorType);
        if (parmorInstance != null && parmorInstance.getLocationSlot() == armorType) {
            itemInstance = parmorInstance;
        } else {
            parmorInstance = activeChar.getInventory().getPaperdollItem(5);
            if (parmorInstance != null && parmorInstance.getLocationSlot() == 5) {
                itemInstance = parmorInstance;
            }
        }
        if (itemInstance != null) {
            curEnchant = itemInstance.getEnchantLevel();
            activeChar.getInventory().unEquipItemInSlot(armorType);
            itemInstance.setEnchantLevel(ench);
            activeChar.getInventory().equipItem(itemInstance);
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(itemInstance);
            activeChar.sendPacket(iu);
            activeChar.broadcastPacket(new CharInfo(activeChar));
            activeChar.sendPacket(new UserInfo(activeChar));
            activeChar.broadcastPacket(new ExBrExtraUserInfo(activeChar));
            activeChar.sendMessage("Changed enchantment of " + activeChar.getName() + "'s " + itemInstance.getItem().getName() + " from " + curEnchant + " to " + ench + ".");
            activeChar.sendMessage("Admin has changed the enchantment of your " + itemInstance.getItem().getName() + " from " + curEnchant + " to " + ench + ".");
            GMAudit.auditGMAction("TelnetAdministrator", "enchant", activeChar.getName(), itemInstance.getItem().getName() + "(" + itemInstance.getObjectId() + ")" + " from " + curEnchant + " to " + ench);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jailOfflinePlayer(String name, int delay) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE characters SET x=?, y=?, z=?, punish_level=?, punish_timer=? WHERE char_name=?");
            statement.setInt(1, -114356);
            statement.setInt(2, -249645);
            statement.setInt(3, -2984);
            statement.setInt(4, L2PcInstance.PunishLevel.JAIL.value());
            statement.setLong(5, (long)delay * 60000L);
            statement.setString(6, name);
            statement.execute();
            int count = statement.getUpdateCount();
            statement.close();
            if (count == 0) {
                this._print.println("Character not found!");
            } else {
                this._print.println("Character " + name + " jailed for " + (delay > 0 ? delay + " minutes." : "ever!"));
            }
        }
        catch (SQLException se) {
            this._print.println("SQLException while jailing player");
            if (Config.DEBUG) {
                se.printStackTrace();
            }
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unjailOfflinePlayer(String name) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE characters SET x=?, y=?, z=?, punish_level=?, punish_timer=? WHERE char_name=?");
            statement.setInt(1, 17836);
            statement.setInt(2, 170178);
            statement.setInt(3, -3507);
            statement.setInt(4, 0);
            statement.setLong(5, 0L);
            statement.setString(6, name);
            statement.execute();
            int count = statement.getUpdateCount();
            statement.close();
            if (count == 0) {
                this._print.println("Character not found!");
            } else {
                this._print.println("Character " + name + " set free.");
            }
        }
        catch (SQLException se) {
            this._print.println("SQLException while jailing player");
            if (Config.DEBUG) {
                se.printStackTrace();
            }
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private int getOnlineGMS() {
        return GmListTable.getInstance().getAllGms(true).size();
    }

    private String getUptime(int time) {
        int uptime = (int)System.currentTimeMillis() - time;
        int h = (uptime /= 1000) / 3600;
        int m = (uptime - h * 3600) / 60;
        int s = uptime - h * 3600 - m * 60;
        return h + "hrs " + m + "mins " + s + "secs";
    }

    private String gameTime() {
        int t = GameTimeController.getInstance().getGameTime();
        int h = t / 60;
        int m = t % 60;
        SimpleDateFormat format = new SimpleDateFormat("H:mm");
        Calendar cal = Calendar.getInstance();
        cal.set(11, h);
        cal.set(12, m);
        return format.format(cal.getTime());
    }

    public String getServerStatus() {
        int playerCount = 0;
        int objectCount = 0;
        int max = LoginServerThread.getInstance().getMaxPlayer();
        playerCount = L2World.getInstance().getAllPlayersCount();
        objectCount = L2World.getInstance().getAllVisibleObjectsCount();
        int itemCount = 0;
        int itemVoidCount = 0;
        int monsterCount = 0;
        int minionCount = 0;
        int minionsGroupCount = 0;
        int npcCount = 0;
        int charCount = 0;
        int pcCount = 0;
        int detachedCount = 0;
        int doorCount = 0;
        int summonCount = 0;
        int AICount = 0;
        for (L2Object obj : L2World.getInstance().getAllVisibleObjectsArray()) {
            if (obj == null) continue;
            if (obj instanceof L2Character && ((L2Character)obj).hasAI()) {
                ++AICount;
            }
            if (obj instanceof L2ItemInstance) {
                if (((L2ItemInstance)obj).getLocation() == L2ItemInstance.ItemLocation.VOID) {
                    ++itemVoidCount;
                    continue;
                }
                ++itemCount;
                continue;
            }
            if (obj instanceof L2MonsterInstance) {
                ++monsterCount;
                if (!((L2MonsterInstance)obj).hasMinions()) continue;
                minionCount += ((L2MonsterInstance)obj).getMinionList().countSpawnedMinions();
                minionsGroupCount += ((L2MonsterInstance)obj).getMinionList().lazyCountSpawnedMinionsGroups();
                continue;
            }
            if (obj instanceof L2Npc) {
                ++npcCount;
                continue;
            }
            if (obj instanceof L2PcInstance) {
                ++pcCount;
                if (((L2PcInstance)obj).getClient() == null || !((L2PcInstance)obj).getClient().isDetached()) continue;
                ++detachedCount;
                continue;
            }
            if (obj instanceof L2Summon) {
                ++summonCount;
                continue;
            }
            if (obj instanceof L2DoorInstance) {
                ++doorCount;
                continue;
            }
            if (!(obj instanceof L2Character)) continue;
            ++charCount;
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("Server Status: \r\n  --->  Player Count: ").append(playerCount).append('/').append(max);
        sb.append("\r\n  ---> Offline Count: ").append(detachedCount).append('/').append(playerCount);
        sb.append("\r\n  +-->  Object Count: ").append(objectCount);
        sb.append("\r\n  +-->      AI Count: ").append(AICount);
        sb.append("\r\n  +.... L2Item(Void): ").append(itemVoidCount);
        sb.append("\r\n  +.......... L2Item: ").append(itemCount);
        sb.append("\r\n  +....... L2Monster: ").append(monsterCount);
        sb.append("\r\n  +......... Minions: ").append(minionCount);
        sb.append("\r\n  +.. Minions Groups: ").append(minionsGroupCount);
        sb.append("\r\n  +........... L2Npc: ").append(npcCount);
        sb.append("\r\n  +............ L2Pc: ").append(pcCount);
        sb.append("\r\n  +........ L2Summon: ").append(summonCount);
        sb.append("\r\n  +.......... L2Door: ").append(doorCount);
        sb.append("\r\n  +.......... L2Char: ").append(charCount);
        sb.append("\r\n  --->   Ingame Time: ").append(this.gameTime());
        sb.append("\r\n  ---> Server Uptime: ").append(this.getUptime(this._uptime));
        sb.append("\r\n  --->      GM Count: ").append(this.getOnlineGMS());
        sb.append("\r\n  --->       Threads: ").append(Thread.activeCount());
        sb.append("\r\n  RAM Used: ").append((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
        sb.append("\r\n");
        return sb.toString();
    }

    public void debugAll() throws IOException {
        String[] libs;
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        StringBuilder sb = new StringBuilder(256);
        sb.append(sdf.format(cal.getTime()));
        sb.append("\n\nL2J Server Version: ").append(Config.SERVER_VERSION);
        sb.append("\nDP Revision: ").append(Config.DATAPACK_VERSION);
        sb.append("\n\n");
        sb.append(this.getServerStatus());
        sb.append("\n\n\n## Java Platform Information ##\nJava Runtime Name: ").append(System.getProperty("java.runtime.name"));
        sb.append("\nJava Version: ").append(System.getProperty("java.version"));
        sb.append("\nJava Class Version: ").append(System.getProperty("java.class.version"));
        sb.append("\n\n## Virtual Machine Information ##\nVM Name: ").append(System.getProperty("java.vm.name"));
        sb.append("\nVM Version: ").append(System.getProperty("java.vm.version"));
        sb.append("\nVM Vendor: ").append(System.getProperty("java.vm.vendor"));
        sb.append("\nVM Info: ").append(System.getProperty("java.vm.info"));
        sb.append("\n\n## OS Information ##\nName: ").append(System.getProperty("os.name"));
        sb.append("\nArchiteture: ").append(System.getProperty("os.arch"));
        sb.append("\nVersion: ").append(System.getProperty("os.version"));
        sb.append("\n\n## Runtime Information ##\nCPU Count: ").append(Runtime.getRuntime().availableProcessors());
        sb.append("\nCurrent Free Heap Size: ").append(Runtime.getRuntime().freeMemory() / 1024L / 1024L).append(" mb\nCurrent Heap Size: ").append(Runtime.getRuntime().totalMemory() / 1024L / 1024L).append(" mb\nMaximum Heap Size: ").append(Runtime.getRuntime().maxMemory() / 1024L / 1024L).append(" mb\n\n## Class Path Information ##\n");
        String cp = System.getProperty("java.class.path");
        for (String lib : libs = cp.split(File.pathSeparator)) {
            sb.append(lib);
            sb.append('\n');
        }
        sb.append("\n## Threads Information ##\n");
        Map<Thread, StackTraceElement[]> allThread = Thread.getAllStackTraces();
        FastTable entries = new FastTable();
        entries.setValueComparator((FastComparator)new FastComparator<Map.Entry<Thread, StackTraceElement[]>>(){

            public boolean areEqual(Map.Entry<Thread, StackTraceElement[]> e1, Map.Entry<Thread, StackTraceElement[]> e2) {
                return e1.getKey().getName().equals(e2.getKey().getName());
            }

            public int compare(Map.Entry<Thread, StackTraceElement[]> e1, Map.Entry<Thread, StackTraceElement[]> e2) {
                return e1.getKey().getName().compareTo(e2.getKey().getName());
            }

            public int hashCodeOf(Map.Entry<Thread, StackTraceElement[]> e) {
                return e.hashCode();
            }
        });
        entries.addAll(allThread.entrySet());
        entries.sort();
        for (Map.Entry entry : entries) {
            StackTraceElement[] stes = (StackTraceElement[])entry.getValue();
            Thread t = (Thread)entry.getKey();
            sb.append("--------------\n");
            sb.append(t.toString()).append(" (").append(t.getId()).append(")\nState: ").append((Object)t.getState()).append("\nisAlive: ").append(t.isAlive()).append(" | isDaemon: ").append(t.isDaemon()).append(" | isInterrupted: ").append(t.isInterrupted()).append("\n\n");
            for (StackTraceElement ste : stes) {
                sb.append(ste.toString());
                sb.append('\n');
            }
            sb.append('\n');
        }
        sb.append('\n');
        this.checkForDeadlocks(sb);
        sb.append("\n\n## Thread Pool Manager Statistics ##\n");
        for (String line : ThreadPoolManager.getInstance().getStats()) {
            sb.append(line);
            sb.append('\n');
        }
        int i = 0;
        File f = new File("./log/Debug-" + i + ".txt");
        while (f.exists()) {
            f = new File("./log/Debug-" + ++i + ".txt");
        }
        f.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(f);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        out.write(sb.toString());
        out.flush();
        out.close();
        fos.close();
        this._print.println("Debug output saved to log/" + f.getName());
        this._print.flush();
    }

    private void checkForDeadlocks(StringBuilder sb) {
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        long[] ids = this.findDeadlockedThreads(mbean);
        if (ids != null && ids.length > 0) {
            Thread[] threads = new Thread[ids.length];
            for (int i = 0; i < threads.length; ++i) {
                threads[i] = this.findMatchingThread(mbean.getThreadInfo(ids[i]));
            }
            sb.append("Deadlocked Threads:\n-------------------\n");
            for (Thread thread : threads) {
                System.err.println(thread);
                for (StackTraceElement ste : thread.getStackTrace()) {
                    sb.append('\t').append(ste);
                    sb.append('\n');
                }
            }
        }
    }

    private long[] findDeadlockedThreads(ThreadMXBean mbean) {
        if (mbean.isSynchronizerUsageSupported()) {
            return mbean.findDeadlockedThreads();
        }
        return mbean.findMonitorDeadlockedThreads();
    }

    private Thread findMatchingThread(ThreadInfo inf) {
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (thread.getId() != inf.getThreadId()) continue;
            return thread;
        }
        throw new IllegalStateException("Deadlocked Thread not found");
    }
}

