/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSParticipantAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceCommitOperation;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.eclipse.ui.PlatformUI;

public class WorkspaceCommitAction
extends CVSParticipantAction {
    public WorkspaceCommitAction(ISynchronizePageConfiguration configuration) {
        super(configuration);
        this.setId("org.eclipse.team.cvs.ui.commit");
        this.setActionDefinitionId("org.eclipse.team.cvs.ui.commit");
    }

    public WorkspaceCommitAction(ISynchronizePageConfiguration configuration, ISelectionProvider provider, String bundleKey) {
        super(configuration, provider, bundleKey);
        this.setId("org.eclipse.team.cvs.ui.commitAll");
        this.setActionDefinitionId("org.eclipse.team.cvs.ui.commitAll");
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4});
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        return new WorkspaceCommitOperation(configuration, elements, false);
    }

    public void runOperation() {
        SyncInfoSet set = this.getSyncInfoSet();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        try {
            CommitWizard.run(shell, set, (IJobChangeListener)this.getSubscriberOperation(this.getConfiguration(), this.getFilteredDiffElements()));
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    private SyncInfoSet getSyncInfoSet() {
        IDiffElement[] elements = this.getFilteredDiffElements();
        SyncInfoSet filtered = new SyncInfoSet();
        int i = 0;
        while (i < elements.length) {
            IDiffElement e = elements[i];
            if (e instanceof SyncInfoModelElement) {
                filtered.add(((SyncInfoModelElement)e).getSyncInfo());
            }
            ++i;
        }
        return filtered;
    }
}

