/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.cache;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.tigris.subversion.subclipse.graph.cache.Branch;

public class Node
implements Serializable,
IPropertySource,
Comparable {
    private static final long serialVersionUID = 2835522933811459843L;
    private long revision;
    private String author;
    private Date revisionDate;
    private String message;
    private String path;
    private char action;
    private long copySrcRevision;
    private String copySrcPath;
    private Node parent;
    private Node source;
    private int childCount;
    private transient Object view;
    private List mergedRevisions;
    private List tags;
    private transient Branch branch;
    private transient int branchIndex;
    private transient int graphIndex;
    private static DateFormat dateFormat;
    public static String P_ID_ACTION;
    public static String P_ACTION;
    public static String P_ID_PATH;
    public static String P_PATH;
    public static String P_ID_DATE;
    public static String P_DATE;
    public static String P_ID_AUTHOR;
    public static String P_AUTHOR;
    public static String P_ID_FROM;
    public static String P_FROM;
    public static String P_ID_MSG;
    public static String P_MSG;
    public static List descriptors;

    static {
        P_ID_ACTION = "action";
        P_ACTION = "Action";
        P_ID_PATH = "path";
        P_PATH = "Path";
        P_ID_DATE = "date";
        P_DATE = "Date";
        P_ID_AUTHOR = "author";
        P_AUTHOR = "Author";
        P_ID_FROM = "from";
        P_FROM = "From";
        P_ID_MSG = "msg";
        P_MSG = "Message";
        descriptors = new ArrayList();
        descriptors.add(new PropertyDescriptor((Object)P_ID_ACTION, P_ACTION));
        descriptors.add(new PropertyDescriptor((Object)P_ID_PATH, P_PATH));
        descriptors.add(new PropertyDescriptor((Object)P_ID_DATE, P_DATE));
        descriptors.add(new PropertyDescriptor((Object)P_ID_AUTHOR, P_AUTHOR));
        descriptors.add(new PropertyDescriptor((Object)P_ID_MSG, P_MSG));
        descriptors.add(new PropertyDescriptor((Object)P_ID_FROM, P_FROM));
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
        if (parent != null) {
            ++parent.childCount;
        }
    }

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getRevisionDate() {
        return this.revisionDate;
    }

    public void setRevisionDate(Date revisionDate) {
        this.revisionDate = revisionDate;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public char getAction() {
        return this.action;
    }

    public void setAction(char action) {
        this.action = action;
    }

    public long getCopySrcRevision() {
        return this.copySrcRevision;
    }

    public void setCopySrcRevision(long copySrcRevision) {
        this.copySrcRevision = copySrcRevision;
    }

    public String getCopySrcPath() {
        return this.copySrcPath;
    }

    public void setCopySrcPath(String copySrcPath) {
        this.copySrcPath = copySrcPath;
    }

    public String toString() {
        String pattern = "{0} by {1} {3} on {2} -- {4} --";
        return MessageFormat.format(pattern, new Long(this.revision), this.author, this.path, String.valueOf(this.action), this.message);
    }

    public Object getView() {
        return this.view;
    }

    public void setView(Object view) {
        this.view = view;
    }

    public int getChildCount() {
        return this.childCount;
    }

    public Node getSource() {
        return this.source;
    }

    public void setSource(Node source) {
        this.source = source;
        if (source != null) {
            ++source.childCount;
        }
    }

    public List getMergedRevisions() {
        return this.mergedRevisions;
    }

    public void addMergedRevision(Node node) {
        if (this.mergedRevisions == null) {
            this.mergedRevisions = new ArrayList();
        }
        this.mergedRevisions.add(node);
    }

    public List getTags() {
        return this.tags;
    }

    public void addTag(Node node) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        this.tags.add(node);
    }

    public void setBranch(Branch branch) {
        this.branch = branch;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public void setBranchIndex(int branchIndex) {
        this.branchIndex = branchIndex;
    }

    public int getBranchIndex() {
        return this.branchIndex;
    }

    public int getGraphIndex() {
        return this.graphIndex;
    }

    public void setGraphIndex(int graphIndex) {
        this.graphIndex = graphIndex;
    }

    public Object getEditableValue() {
        return "r" + this.revision;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Node.getDescriptors().toArray(new IPropertyDescriptor[Node.getDescriptors().size()]);
    }

    private static List getDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object propKey) {
        if (P_ID_MSG.equals(propKey) && this.message != null) {
            return this.message;
        }
        if (P_ID_AUTHOR.equals(propKey) && this.author != null) {
            return this.author;
        }
        if (P_ID_ACTION.equals(propKey)) {
            return String.valueOf(this.action);
        }
        if (P_ID_PATH.equals(propKey) && this.path != null) {
            return this.path;
        }
        if (P_ID_FROM.equals(propKey) && this.copySrcPath != null) {
            return "r" + Long.toString(this.copySrcRevision) + " " + this.copySrcPath;
        }
        if (P_ID_DATE.equals(propKey) && this.revisionDate != null) {
            return Node.getDateFormat().format(this.revisionDate);
        }
        return "";
    }

    public boolean isPropertySet(Object arg0) {
        return false;
    }

    public void resetPropertyValue(Object arg0) {
    }

    public void setPropertyValue(Object arg0, Object arg1) {
    }

    private static DateFormat getDateFormat() {
        if (dateFormat == null) {
            dateFormat = SimpleDateFormat.getDateTimeInstance(2, 2);
        }
        return dateFormat;
    }

    public int compareTo(Object object) {
        if (object instanceof Node) {
            Node compareTo = (Node)object;
            if (compareTo.getRevision() < this.revision) {
                return 1;
            }
            if (compareTo.getRevision() > this.revision) {
                return -1;
            }
            return 0;
        }
        return 0;
    }
}

