/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.RESyntax;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.PerlLineBreakpoint;
import org.epic.debug.ui.RegExpBPSettingsDialog;

public class PerlRegExpBreakpoint
extends PerlLineBreakpoint {
    private static final String Perl_REGEXP_BREAKPOINT = "org.epic.debug.perlRegExpBreakpointMarker";
    private static final String SOURCE_LINE = "EPIC_SOURCE_LINE";
    private static final String REG_EXP = "EPIC_REG_EXP";
    private static final String MATCH_TEXT = "EPIC_MATCH_TEXT";
    private static final String IGNORE_CASE = "EPIC_IGNORE_CASE";
    private static final String MULTILINE = "EPIC_MULTILINE";
    private RegExpBPSettingsDialog dialog;

    public PerlRegExpBreakpoint() {
    }

    public PerlRegExpBreakpoint(IResource resource, int lineNumber) throws DebugException, CoreException {
        super(resource, lineNumber);
        this.calculateRegExp();
    }

    public PerlRegExpBreakpoint(IResource resource, int lineNumber, int charStart, int charEnd, boolean add, Map attributes) throws DebugException, CoreException {
        this.calculateRegExp();
    }

    String getMarkerID() {
        return Perl_REGEXP_BREAKPOINT;
    }

    public String getSourceLine() {
        return (String)this.getAttribute(SOURCE_LINE);
    }

    private Object getAttribute(String fID) {
        try {
            return this.getMarker().getAttribute(fID);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getRegExp() {
        return (String)this.getAttribute(REG_EXP);
    }

    public String getMatchText() {
        return (String)this.getAttribute(MATCH_TEXT);
    }

    private void setAttributeValue(String fID, Object fValue) {
        try {
            this.getMarker().setAttribute(fID, fValue);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setMatchText(String fText) {
        this.setAttributeValue(MATCH_TEXT, fText);
    }

    public void setIgnoreCase(boolean fBool) {
        this.setAttributeValue(IGNORE_CASE, new Boolean(fBool));
    }

    public boolean getIgnoreCase() {
        Boolean b = (Boolean)this.getAttribute(IGNORE_CASE);
        if (b != null) {
            return b;
        }
        return false;
    }

    public boolean getMultiLine() {
        Boolean b = (Boolean)this.getAttribute(MULTILINE);
        if (b != null) {
            return b;
        }
        return false;
    }

    public void setMultiLine(boolean fBool) {
        this.setAttributeValue(MULTILINE, new Boolean(fBool));
    }

    @Override
    public void setRegExp(String fText) {
        this.setAttributeValue(REG_EXP, fText);
    }

    public void setSourceLine(String fText) {
        this.setAttributeValue(SOURCE_LINE, fText);
    }

    public boolean isStoredDataValid() {
        return this.isStoredDataValid(this.getCurrentSourceLine());
    }

    public boolean isStoredDataValid(String fCurrentSourceLine) {
        String lineStored = this.getSourceLine();
        return fCurrentSourceLine != null && lineStored != null && fCurrentSourceLine.equals(lineStored) && this.getRegExp() != null && this.getMatchText() != null;
    }

    void calculateRegExp() {
        String lineCurrent = this.getCurrentSourceLine();
        if (!this.isStoredDataValid(lineCurrent)) {
            this.setSourceLine(lineCurrent);
            if (this.extractRegExp(lineCurrent)) {
                return;
            }
            Shell shell = PerlDebugPlugin.getActiveWorkbenchShell();
            this.dialog = new RegExpBPSettingsDialog(shell, this, "Could not extract Regular Expression...");
            if (shell != null) {
                shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PerlRegExpBreakpoint.this.dialog.open();
                    }
                });
            }
        }
    }

    private boolean extractRegExp(String line) {
        String mod;
        String text;
        String var;
        block13: {
            REMatch match;
            block12: {
                String delim;
                block11: {
                    block10: {
                        try {
                            RE findDelim = new RE((Object)"[$%@].+[\\s]*=~[\\s]*[m]?(.)", 0, RESyntax.RE_SYNTAX_PERL5);
                            match = findDelim.getMatch((Object)line);
                            if (match != null) break block10;
                            return false;
                        }
                        catch (REException e2) {
                            e2.printStackTrace();
                            return false;
                        }
                    }
                    delim = match.toString(1);
                    if (delim != null) break block11;
                    return false;
                }
                String temp = line;
                temp.replaceAll("\\" + delim, "xx");
                RE findRegExp = new RE((Object)("([$%@][^\\s]+)[\\s]*=~[\\s]*[m]?" + delim + "(.*)" + delim + "(.*)"), 0, RESyntax.RE_SYNTAX_PERL5);
                match = findRegExp.getMatch((Object)temp);
                if (match != null) break block12;
                return false;
            }
            var = line.substring(match.getStartIndex(1), match.getEndIndex(1));
            text = line.substring(match.getStartIndex(2), match.getEndIndex(2));
            mod = line.substring(match.getStartIndex(3), match.getEndIndex(3));
            if (var != null && text != null) break block13;
            return false;
        }
        if (mod != null && mod.indexOf("i") >= 0) {
            this.setIgnoreCase(true);
        } else {
            this.setIgnoreCase(false);
        }
        if (mod != null && mod.indexOf("m") >= 0) {
            this.setMultiLine(true);
        } else {
            this.setMultiLine(false);
        }
        this.setRegExp(text);
        this.setMatchText(var);
        return true;
    }

    private String getCurrentSourceLine() {
        IDocument doc = this.getDocument();
        String line = null;
        try {
            int length = doc.getLineLength(this.getLineNumber() - 1);
            int offset = doc.getLineOffset(this.getLineNumber() - 1);
            line = doc.get(offset, length);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (CoreException coreException) {}
        return line.trim();
    }

    public void updateIfRecognized() {
        String lineCurrent = this.getCurrentSourceLine();
        if (!this.isStoredDataValid(lineCurrent)) {
            this.setSourceLine(lineCurrent);
            this.extractRegExp(lineCurrent);
        }
    }
}

