/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public class LogWriter
implements ILogListener {
    protected File logFile = null;
    protected Writer log = null;
    protected boolean newSession = true;
    protected int mLogLevel;
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String SUBENTRY = "!SUBENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final String LINE_SEPARATOR;
    protected static final String TAB_STRING = "\t";

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n" : s;
    }

    public LogWriter(File file, int fLogLevel) {
        this.logFile = file;
        this.mLogLevel = fLogLevel;
    }

    public LogWriter(OutputStream out, int fLogLevel) {
        this.log = this.logForStream(out);
        this.mLogLevel = fLogLevel;
    }

    protected void closeLogFile() throws IOException {
        try {
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
        }
        finally {
            this.log = null;
        }
    }

    public synchronized void logging(IStatus status, String plugin) {
        if (status != null && status.getSeverity() < this.mLogLevel) {
            return;
        }
        if (this.logFile != null) {
            this.openLogFile();
        }
        if (this.log == null) {
            this.log = this.logForStream(System.err);
        }
        try {
            try {
                try {
                    this.write(status, 0);
                }
                finally {
                    if (this.logFile != null) {
                        this.closeLogFile();
                    } else {
                        this.log.flush();
                    }
                }
            }
            catch (Exception e) {
                System.err.println("An exception occurred while writing to the EPIC log:");
                e.printStackTrace(System.err);
                System.err.println("Logging to the console instead.");
                try {
                    this.log = this.logForStream(System.err);
                    this.write(status, 0);
                    this.log.flush();
                }
                catch (Exception e2) {
                    System.err.println("An exception occurred while logging to the console:");
                    e2.printStackTrace(System.err);
                }
                this.log = null;
            }
        }
        finally {
            this.log = null;
        }
    }

    protected void openLogFile() {
        try {
            this.log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), "UTF-8"));
            if (this.newSession) {
                this.writeHeader();
                this.newSession = false;
            }
        }
        catch (IOException iOException) {
            this.log = this.logForStream(System.err);
        }
    }

    protected void writeHeader() throws IOException {
        this.write(SESSION);
        this.writeSpace();
        String date = this.getDate();
        this.write(date);
        this.writeSpace();
        int i = SESSION.length() + date.length();
        while (i < 78) {
            this.write("-");
            ++i;
        }
        this.writeln();
        try {
            String key = "java.fullversion";
            String value = System.getProperty(key);
            if (value == null) {
                key = "java.version";
                value = System.getProperty(key);
                this.writeln(String.valueOf(key) + "=" + value);
                key = "java.vendor";
                value = System.getProperty(key);
                this.writeln(String.valueOf(key) + "=" + value);
            } else {
                this.writeln(String.valueOf(key) + "=" + value);
            }
        }
        catch (Exception exception) {}
        this.write("BootLoader constants: OS=" + Platform.getOS());
        this.write(", ARCH=" + Platform.getOSArch());
        this.write(", WS=" + Platform.getWS());
        this.writeln(", NL=" + Platform.getNL());
        String[] args = Platform.getCommandLineArgs();
        if (args != null && args.length > 0) {
            this.write("Command-line arguments:");
            int i2 = 0;
            while (i2 < args.length) {
                this.write(" " + args[i2]);
                ++i2;
            }
            this.writeln();
        }
    }

    protected String getDate() {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SS");
            return formatter.format(new Date());
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    protected Writer logForStream(OutputStream output) {
        try {
            return new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(output));
        }
    }

    protected void writeln(String s) throws IOException {
        this.write(s);
        this.writeln();
    }

    public synchronized void shutdown() {
        try {
            if (this.logFile != null) {
                this.closeLogFile();
                this.logFile = null;
            } else if (this.log != null) {
                Writer old = this.log;
                this.log = null;
                old.flush();
                old.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void write(Throwable throwable) throws IOException {
        if (throwable == null) {
            return;
        }
        this.write(STACK);
        this.writeSpace();
        boolean isCoreException = throwable instanceof CoreException;
        if (isCoreException) {
            this.writeln("1");
        } else {
            this.writeln("0");
        }
        throwable.printStackTrace(new PrintWriter(this.log));
        if (isCoreException) {
            CoreException e = (CoreException)throwable;
            this.write(e.getStatus(), 0);
        }
    }

    protected void write(IStatus status, int depth) throws IOException {
        if (depth == 0) {
            this.write(ENTRY);
        } else {
            this.write(SUBENTRY);
            this.writeSpace();
            this.write(Integer.toString(depth));
        }
        this.writeSpace();
        this.write(status.getPlugin());
        this.writeSpace();
        switch (status.getSeverity()) {
            case 0: {
                this.write("**OK**");
                break;
            }
            case 1: {
                this.write("**Info**");
                break;
            }
            case 2: {
                this.write("**Warning**");
                break;
            }
            case 4: {
                this.write("**Error**");
                break;
            }
            default: {
                this.write("**?" + status.getSeverity() + "?**");
            }
        }
        this.writeSpace();
        this.write(Integer.toString(status.getCode()));
        this.writeSpace();
        this.write(this.getDate());
        this.writeln();
        this.write(MESSAGE);
        this.writeSpace();
        this.writeln(status.getMessage());
        this.write(status.getException());
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.write(children[i], depth + 1);
                ++i;
            }
        }
    }

    protected void writeln() throws IOException {
        this.write(LINE_SEPARATOR);
    }

    protected void write(String message) throws IOException {
        if (message != null) {
            this.log.write(message);
        }
    }

    protected void writeSpace() throws IOException {
        this.write(" ");
    }
}

