/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.asm;

import de.loskutov.bco.asm.CommentedClassVisitor;
import de.loskutov.bco.asm.DecompiledMethod;
import de.loskutov.bco.asm.Index;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.AbstractVisitor;

public class DecompilerMethodVisitor
extends MethodAdapter {
    private final String owner;
    private final List text;
    private final MethodNode meth;
    private LabelNode currentLabel;
    private int currentInsn;
    private final Map lineNumbers;
    private final BitSet modes;

    public DecompilerMethodVisitor(String owner, MethodNode meth, MethodVisitor mv, BitSet modes) {
        super(mv);
        this.owner = owner;
        this.modes = modes;
        this.text = ((AbstractVisitor)mv).getText();
        this.meth = meth;
        this.lineNumbers = new HashMap();
    }

    public DecompiledMethod getResult(ClassLoader cl) {
        return new DecompiledMethod(this.owner, this.text, this.lineNumbers, this.meth, cl, this.modes);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor annVisitor = super.visitAnnotationDefault();
        AnnotationVisitor visitor = this.meth.visitAnnotationDefault();
        if (annVisitor instanceof CommentedClassVisitor.CommentedAnnotationVisitor) {
            CommentedClassVisitor.CommentedAnnotationVisitor av = (CommentedClassVisitor.CommentedAnnotationVisitor)annVisitor;
            av.setAnnotationVisitor(visitor);
        }
        return annVisitor;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor annVisitor = super.visitAnnotation(desc, visible);
        AnnotationVisitor visitor = this.meth.visitAnnotation(desc, visible);
        if (annVisitor instanceof CommentedClassVisitor.CommentedAnnotationVisitor) {
            CommentedClassVisitor.CommentedAnnotationVisitor av = (CommentedClassVisitor.CommentedAnnotationVisitor)annVisitor;
            av.setAnnotationVisitor(visitor);
        }
        return annVisitor;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationVisitor annVisitor = super.visitParameterAnnotation(parameter, desc, visible);
        AnnotationVisitor visitor = this.meth.visitParameterAnnotation(parameter, desc, visible);
        if (annVisitor instanceof CommentedClassVisitor.CommentedAnnotationVisitor) {
            CommentedClassVisitor.CommentedAnnotationVisitor av = (CommentedClassVisitor.CommentedAnnotationVisitor)annVisitor;
            av.setAnnotationVisitor(visitor);
        }
        return annVisitor;
    }

    public void visitCode() {
        super.visitCode();
        this.meth.visitCode();
    }

    public void visitEnd() {
        super.visitEnd();
        this.meth.visitEnd();
    }

    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
        this.meth.visitAttribute(attr);
    }

    public void visitInsn(int opcode) {
        this.addIndex(opcode);
        super.visitInsn(opcode);
        this.meth.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.addIndex(opcode);
        super.visitIntInsn(opcode, operand);
        this.meth.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.addIndex(opcode);
        super.visitVarInsn(opcode, var);
        this.meth.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.addIndex(opcode);
        super.visitTypeInsn(opcode, desc);
        this.meth.visitTypeInsn(opcode, desc);
    }

    public void visitFieldInsn(int opcode, String owner1, String name, String desc) {
        this.addIndex(opcode);
        super.visitFieldInsn(opcode, owner1, name, desc);
        this.meth.visitFieldInsn(opcode, owner1, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner1, String name, String desc) {
        this.addIndex(opcode);
        super.visitMethodInsn(opcode, owner1, name, desc);
        this.meth.visitMethodInsn(opcode, owner1, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.addIndex(opcode);
        super.visitJumpInsn(opcode, label);
        this.meth.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.addIndex(-1);
        super.visitLabel(label);
        this.meth.visitLabel(label);
        this.currentLabel = (LabelNode)this.meth.instructions.getLast();
    }

    public void visitLdcInsn(Object cst) {
        this.addIndex(18);
        super.visitLdcInsn(cst);
        this.meth.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        this.addIndex(132);
        super.visitIincInsn(var, increment);
        this.meth.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.addIndex(170);
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.meth.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.addIndex(171);
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.meth.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.addIndex(197);
        super.visitMultiANewArrayInsn(desc, dims);
        this.meth.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        this.meth.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, desc, signature, start, end, index);
        this.meth.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        this.addIndex(-1);
        this.lineNumbers.put(start, new Integer(line));
        super.visitLineNumber(line, start);
        this.meth.visitLineNumber(line, start);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, maxLocals);
        this.meth.visitMaxs(maxStack, maxLocals);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.addIndex(-1);
        super.visitFrame(type, nLocal, local, nStack, stack);
        this.meth.visitFrame(type, nLocal, local, nStack, stack);
    }

    protected void addIndex(int opcode) {
        this.text.add(new Index(this.currentLabel, this.currentInsn++, opcode));
    }
}

