/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.ui;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.asm.DecompiledClass;
import de.loskutov.bco.ui.EclipseUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.ITextSelection;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;

public class JdtUtils {
    private static final char PACKAGE_SEPARATOR = '/';
    private static final char TYPE_SEPARATOR = '$';
    static /* synthetic */ Class class$de$loskutov$bco$ui$JdtUtils;

    private JdtUtils() {
    }

    public static IJavaElement getMethod(IParent parent, String signature) {
        try {
            IJavaElement[] children = parent.getChildren();
            for (int i = 0; i < children.length; ++i) {
                IJavaElement javaElement = children[i];
                switch (javaElement.getElementType()) {
                    case 9: 
                    case 10: {
                        if (!signature.equals(JdtUtils.getMethodSignature(javaElement))) break;
                        return javaElement;
                    }
                }
                if (!(javaElement instanceof IParent) || (javaElement = JdtUtils.getMethod((IParent)javaElement, signature)) == null) continue;
                return javaElement;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public static String getMethodSignature(IJavaElement childEl) {
        String methodName;
        block8: {
            methodName = null;
            if (childEl.getElementType() == 10) {
                IInitializer ini = (IInitializer)childEl;
                try {
                    if (Flags.isStatic((int)ini.getFlags())) {
                        methodName = "<clinit>()V";
                        break block8;
                    }
                    methodName = "<init>()";
                }
                catch (JavaModelException e) {
                    BytecodeOutlinePlugin.log(e, 2);
                }
            } else if (childEl.getElementType() == 9) {
                IMethod iMethod = (IMethod)childEl;
                try {
                    methodName = JdtUtils.createMethodSignature(iMethod);
                }
                catch (JavaModelException e) {
                    BytecodeOutlinePlugin.log(e, 2);
                }
            }
        }
        return methodName;
    }

    public static String createMethodSignature(IMethod iMethod) throws JavaModelException {
        String resolvedType;
        String typeSignature;
        StringBuffer sb = new StringBuffer();
        if (iMethod.isConstructor()) {
            sb.append("<init>");
        } else {
            sb.append(iMethod.getElementName());
        }
        if (iMethod.isBinary()) {
            return sb.append(iMethod.getSignature()).toString();
        }
        sb.append('(');
        IType declaringType = iMethod.getDeclaringType();
        String[] parameterTypes = iMethod.getParameterTypes();
        if (iMethod.isConstructor() && JdtUtils.isNonStaticInner(declaringType) && (typeSignature = JdtUtils.getTypeSignature(JdtUtils.getFirstAncestor((IJavaElement)declaringType))) != null) {
            String[] newParams = new String[parameterTypes.length + 1];
            newParams[0] = typeSignature;
            System.arraycopy(parameterTypes, 0, newParams, 1, parameterTypes.length);
            parameterTypes = newParams;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            resolvedType = JdtUtils.getResolvedType(parameterTypes[i], declaringType);
            if (resolvedType != null && resolvedType.length() > 0) {
                sb.append(resolvedType);
                continue;
            }
            JdtUtils.appendGenericType(sb, iMethod, parameterTypes[i]);
        }
        sb.append(')');
        String returnType = iMethod.getReturnType();
        resolvedType = JdtUtils.getResolvedType(returnType, declaringType);
        if (resolvedType != null && resolvedType.length() > 0) {
            sb.append(resolvedType);
        } else {
            JdtUtils.appendGenericType(sb, iMethod, returnType);
        }
        return sb.toString();
    }

    private static String getTypeSignature(IType type) {
        if (type == null) {
            return null;
        }
        String name = type.getFullyQualifiedName(',');
        name = name.replace('.', '/');
        name = name.replace(',', '$');
        return 'L' + name + ';';
    }

    private static void appendGenericType(StringBuffer sb, IMethod iMethod, String unresolvedType) throws JavaModelException {
        String[] bounds;
        IType declaringType = iMethod.getDeclaringType();
        if (unresolvedType.length() < 3) {
            sb.append(unresolvedType);
            return;
        }
        ITypeParameter typeParameter = iMethod.getTypeParameter(unresolvedType = unresolvedType.substring(1, unresolvedType.length() - 1));
        if (typeParameter == null || !typeParameter.exists()) {
            typeParameter = declaringType.getTypeParameter(unresolvedType);
        }
        if ((bounds = typeParameter.getBounds()).length == 0) {
            sb.append("Ljava/lang/Object;");
        } else {
            for (int i = 0; i < bounds.length; ++i) {
                String simplyName = bounds[i];
                simplyName = 'Q' + simplyName + ';';
                String resolvedType = JdtUtils.getResolvedType(simplyName, declaringType);
                sb.append(resolvedType);
            }
        }
    }

    private static String getResolvedType(String typeToResolve, IType declaringType) throws JavaModelException {
        StringBuffer sb = new StringBuffer();
        int arrayCount = Signature.getArrayCount((String)typeToResolve);
        boolean isPrimitive = JdtUtils.isPrimitiveType(typeToResolve.charAt(arrayCount));
        if (isPrimitive) {
            sb.append(typeToResolve);
        } else {
            boolean isUnresolvedType = JdtUtils.isUnresolvedType(typeToResolve, arrayCount);
            if (!isUnresolvedType) {
                sb.append(typeToResolve);
            } else {
                String resolved = JdtUtils.getResolvedTypeName(typeToResolve, declaringType);
                if (resolved != null) {
                    while (arrayCount > 0) {
                        sb.append('[');
                        --arrayCount;
                    }
                    sb.append('L');
                    sb.append(resolved);
                    sb.append(';');
                }
            }
        }
        return sb.toString();
    }

    private static String getResolvedTypeName(String refTypeSig, IType declaringType) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        if (JdtUtils.isUnresolvedType(refTypeSig, arrayCount)) {
            String name = "";
            int bracket = refTypeSig.indexOf(60, arrayCount + 1);
            if (bracket > 0) {
                name = refTypeSig.substring(arrayCount + 1, bracket);
            } else {
                int semi = refTypeSig.indexOf(59, arrayCount + 1);
                if (semi == -1) {
                    throw new IllegalArgumentException();
                }
                name = refTypeSig.substring(arrayCount + 1, semi);
            }
            String[][] resolvedNames = declaringType.resolveType(name);
            if (resolvedNames != null && resolvedNames.length > 0) {
                return JdtUtils.concatenateName(resolvedNames[0][0], resolvedNames[0][1]);
            }
            return null;
        }
        return refTypeSig.substring(arrayCount);
    }

    private static boolean isUnresolvedType(String refTypeSig, int arrayCount) {
        char type = refTypeSig.charAt(arrayCount);
        return type == 'Q';
    }

    private static String concatenateName(String packageName, String className) {
        StringBuffer buf = new StringBuffer();
        if (packageName != null && packageName.length() > 0) {
            packageName = packageName.replace('.', '/');
            buf.append(packageName);
        }
        if (className != null && className.length() > 0) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            className = className.replace('.', '$');
            buf.append(className);
        }
        return buf.toString();
    }

    private static boolean isPrimitiveType(char first) {
        return first != 'L' && first != 'Q';
    }

    public static IType getEnclosingType(IJavaElement childEl) {
        if (childEl == null) {
            return null;
        }
        return (IType)childEl.getAncestor(7);
    }

    public static IClassFile getInnerType(IClassFile cf, DecompiledClass dc, String typeSignature) {
        if (typeSignature.endsWith(";") && (typeSignature = typeSignature.substring(0, typeSignature.length() - 1)).startsWith("L")) {
            typeSignature = typeSignature.substring(1, typeSignature.length());
        }
        ClassNode cn = dc.getClassNode();
        List innerClasses = cn.innerClasses;
        for (int i = 0; i < innerClasses.size(); ++i) {
            InnerClassNode in = (InnerClassNode)innerClasses.get(i);
            if (!typeSignature.equals(in.name)) continue;
            int idx = typeSignature.lastIndexOf(47);
            String className = typeSignature;
            if (idx > 0) {
                className = typeSignature.substring(idx + 1, typeSignature.length());
            }
            className = className + ".class";
            return cf.getType().getPackageFragment().getClassFile(className);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IJavaElement getElementAtOffset(IJavaElement input, ITextSelection selection) throws JavaModelException {
        IClassFile iClass;
        IJavaElement ref;
        if (selection == null) {
            return null;
        }
        ICompilationUnit workingCopy = null;
        if (input instanceof ICompilationUnit) {
            ICompilationUnit iCompilationUnit = workingCopy = (ICompilationUnit)input;
            synchronized (iCompilationUnit) {
                workingCopy.reconcile(0, false, null, null);
            }
            IJavaElement ref2 = workingCopy.getElementAt(selection.getOffset());
            if (ref2 != null) {
                return ref2;
            }
        } else if (input instanceof IClassFile && (ref = (iClass = (IClassFile)input).getElementAt(selection.getOffset())) != null) {
            IType type;
            IClassFile classFile;
            if (ref instanceof IType && (classFile = (type = (IType)ref).getClassFile()) != iClass) {
                ref = classFile.getElementAt(selection.getOffset());
            }
            return ref;
        }
        return null;
    }

    public static boolean is50OrHigher(IJavaElement javaElt) {
        IJavaProject project = javaElt.getJavaProject();
        String option = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        boolean result = "1.5".equals(option);
        if (result) {
            return result;
        }
        result = "1.4".equals(option);
        if (result) {
            return false;
        }
        result = "1.3".equals(option);
        if (result) {
            return false;
        }
        result = "1.2".equals(option);
        if (result) {
            return false;
        }
        result = "1.1".equals(option);
        return !result;
    }

    public static String getElementName(IJavaElement javaElement) {
        if (JdtUtils.isAnonymousType(javaElement)) {
            IType anonType = (IType)javaElement;
            ArrayList allAnonymous = new ArrayList();
            JdtUtils.collectAllAnonymous(allAnonymous, anonType);
            int idx = JdtUtils.getAnonimousIndex(anonType, allAnonymous.toArray(new IType[allAnonymous.size()]));
            return Integer.toString(idx);
        }
        String name = javaElement.getElementName();
        if (JdtUtils.isLocal(javaElement)) {
            name = JdtUtils.is50OrHigher(javaElement) ? "1" + name : "1$" + name;
        }
        if (name.endsWith(".java")) {
            name = name.substring(0, name.lastIndexOf(".java"));
        } else if (name.endsWith(".class")) {
            name = name.substring(0, name.lastIndexOf(".class"));
        }
        return name;
    }

    private static IType getFirstAncestor(IJavaElement javaElement) {
        IJavaElement parent = javaElement;
        if (javaElement.getElementType() == 7) {
            parent = javaElement.getParent();
        }
        if (parent != null) {
            return (IType)parent.getAncestor(7);
        }
        return null;
    }

    private static IJavaElement getLastAncestor(IJavaElement javaElement, int elementType) {
        IJavaElement parent;
        IJavaElement lastFound = null;
        if (elementType == javaElement.getElementType()) {
            lastFound = javaElement;
        }
        if ((parent = javaElement.getParent()) == null) {
            return lastFound;
        }
        IJavaElement ancestor = parent.getAncestor(elementType);
        if (ancestor != null) {
            return JdtUtils.getLastAncestor(ancestor, elementType);
        }
        return lastFound;
    }

    private static int getTopAncestorDistance(IJavaElement javaElement, IJavaElement topAncestor) {
        if (topAncestor == javaElement) {
            return 0;
        }
        IType ancestor = JdtUtils.getFirstAncestor(javaElement);
        if (ancestor != null) {
            return 1 + JdtUtils.getTopAncestorDistance((IJavaElement)ancestor, topAncestor);
        }
        return -1;
    }

    private static IJavaElement getFirstNonAnonymous(IJavaElement javaElement, IJavaElement topAncestor) {
        if (javaElement.getElementType() == 7 && !JdtUtils.isAnonymousType(javaElement)) {
            return javaElement;
        }
        IJavaElement parent = javaElement.getParent();
        if (parent == null) {
            return topAncestor;
        }
        IJavaElement ancestor = parent.getAncestor(7);
        if (ancestor != null) {
            return JdtUtils.getFirstNonAnonymous(ancestor, topAncestor);
        }
        return topAncestor;
    }

    private static boolean isAnonymousType(IJavaElement javaElement) {
        try {
            return javaElement instanceof IType && ((IType)javaElement).isAnonymous();
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.log(e, 4);
            return false;
        }
    }

    private static boolean isLocal(IJavaElement innerType) {
        try {
            return innerType instanceof IType && ((IType)innerType).isLocal();
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.log(e, 4);
            return false;
        }
    }

    private static boolean isAnyParentLocal(IJavaElement elt, IJavaElement topParent) {
        if (JdtUtils.isLocal(elt)) {
            return true;
        }
        for (IJavaElement parent = elt.getParent(); parent != null && parent != topParent; parent = parent.getParent()) {
            if (!JdtUtils.isLocal(parent)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNonStaticInner(IType type) throws JavaModelException {
        if (type.isMember()) {
            return !Flags.isStatic((int)type.getFlags());
        }
        return false;
    }

    private static boolean isFromInitBlock(IType type) {
        IJavaElement ancestor = type.getAncestor(10);
        return ancestor != null;
    }

    private static String getPackageOutputPath(IJavaElement javaElement) throws JavaModelException {
        IPath def;
        String dir = "";
        if (javaElement == null) {
            return dir;
        }
        IJavaProject project = javaElement.getJavaProject();
        if (project == null) {
            return dir;
        }
        IPath path = project.getOutputLocation();
        IResource resource = javaElement.getUnderlyingResource();
        if (resource == null) {
            return dir;
        }
        if (project.exists() && project.getProject().isOpen()) {
            IClasspathEntry[] entries = project.getRawClasspath();
            for (int i = 0; i < entries.length; ++i) {
                IPath outputPath;
                IClasspathEntry classpathEntry = entries[i];
                if (classpathEntry.getEntryKind() != 3 || (outputPath = classpathEntry.getOutputLocation()) == null || !classpathEntry.getPath().isPrefixOf(resource.getFullPath())) continue;
                path = outputPath;
                break;
            }
        }
        if (path == null && (def = project.getOutputLocation()) != null && def.isPrefixOf(resource.getFullPath())) {
            path = def;
        }
        if (path == null) {
            return dir;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (!project.getPath().equals(path)) {
            IPath rawPath;
            IFolder outputFolder = workspace.getRoot().getFolder(path);
            if (outputFolder != null && (rawPath = outputFolder.getRawLocation()) != null) {
                path = rawPath;
            }
        } else {
            path = project.getProject().getLocation();
        }
        IPathVariableManager pathManager = workspace.getPathVariableManager();
        path = pathManager.resolvePath(path);
        if (path == null) {
            return dir;
        }
        if (JdtUtils.isPackageRoot(project, resource)) {
            dir = path.toOSString();
        } else {
            String packPath = EclipseUtils.getJavaPackageName(javaElement).replace('.', '/');
            dir = path.append(packPath).toOSString();
        }
        return dir;
    }

    private static boolean isPackageRoot(IJavaProject project, IResource pack) throws JavaModelException {
        boolean isRoot = false;
        if (project == null || pack == null || !(pack instanceof IContainer)) {
            return isRoot;
        }
        IPackageFragmentRoot root = project.getPackageFragmentRoot(pack);
        IClasspathEntry clPathEntry = null;
        if (root != null) {
            clPathEntry = root.getRawClasspathEntry();
        }
        isRoot = clPathEntry != null;
        return isRoot;
    }

    public static String getByteCodePath(IJavaElement javaElement) {
        if (javaElement == null) {
            return "";
        }
        String packagePath = "";
        try {
            packagePath = JdtUtils.getPackageOutputPath(javaElement);
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.log(e, 4);
            return "";
        }
        IJavaElement ancestor = JdtUtils.getLastAncestor(javaElement, 7);
        StringBuffer sb = new StringBuffer(packagePath);
        sb.append(File.separator);
        sb.append(JdtUtils.getClassName(javaElement, ancestor));
        sb.append(".class");
        return sb.toString();
    }

    public static InputStream createInputStream(IJavaElement javaElement) {
        IClassFile classFile = (IClassFile)javaElement.getAncestor(6);
        InputStream is = null;
        if (classFile != null) {
            boolean isJar;
            IJavaElement jarParent = classFile.getParent();
            boolean bl = isJar = jarParent != null && jarParent.getClass().getName().endsWith("JarPackageFragment");
            is = isJar ? JdtUtils.createStreamFromJar(classFile) : JdtUtils.createStreamFromClass(classFile);
        } else {
            boolean inJavaPath = JdtUtils.isOnClasspath(javaElement);
            if (!inJavaPath) {
                return null;
            }
            String classPath = JdtUtils.getByteCodePath(javaElement);
            try {
                is = new FileInputStream(classPath);
            }
            catch (FileNotFoundException e) {
                BytecodeOutlinePlugin.log(e, 2);
            }
        }
        return is;
    }

    private static InputStream createStreamFromClass(IClassFile classFile) {
        IResource underlyingResource = null;
        try {
            underlyingResource = classFile.exists() ? classFile.getUnderlyingResource() : classFile.getResource();
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.log(e, 4);
            return null;
        }
        IPath rawLocation = underlyingResource.getRawLocation();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPathVariableManager pathManager = workspace.getPathVariableManager();
        rawLocation = pathManager.resolvePath(rawLocation);
        try {
            return new FileInputStream(rawLocation.toOSString());
        }
        catch (FileNotFoundException e) {
            BytecodeOutlinePlugin.log(e, 4);
            return null;
        }
    }

    private static InputStream createStreamFromJar(IClassFile classFile) {
        IPath path = null;
        IResource resource = classFile.getResource();
        path = resource != null ? resource.getRawLocation() : classFile.getPath();
        if (path == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPathVariableManager pathManager = workspace.getPathVariableManager();
        path = pathManager.resolvePath(path);
        JarFile jar = null;
        try {
            jar = new JarFile(path.toOSString());
        }
        catch (IOException e) {
            BytecodeOutlinePlugin.log(e, 4);
            return null;
        }
        String fullClassName = JdtUtils.getFullBytecodeName(classFile);
        if (fullClassName == null) {
            return null;
        }
        JarEntry jarEntry = jar.getJarEntry(fullClassName);
        if (jarEntry != null) {
            try {
                return jar.getInputStream(jarEntry);
            }
            catch (IOException e) {
                BytecodeOutlinePlugin.log(e, 4);
            }
        }
        return null;
    }

    private static boolean isOnClasspath(IJavaElement javaElement) {
        IJavaProject project = javaElement.getJavaProject();
        if (project != null) {
            boolean result = project.isOnClasspath(javaElement);
            return result;
        }
        return false;
    }

    public static String getFullBytecodeName(IClassFile classFile) {
        IPackageFragment packageFr = (IPackageFragment)classFile.getAncestor(4);
        if (packageFr == null) {
            return null;
        }
        String packageName = packageFr.getElementName();
        packageName = packageName.replace('.', '/');
        String className = classFile.getElementName();
        if (packageName != null && packageName.length() > 0) {
            return packageName + '/' + className;
        }
        return className;
    }

    private static String getClassName(IJavaElement javaElement, IJavaElement topAncestor) {
        StringBuffer sb = new StringBuffer();
        if (!javaElement.equals(topAncestor)) {
            int elementType = javaElement.getElementType();
            if (elementType == 8 || elementType == 9 || elementType == 10) {
                javaElement = JdtUtils.getFirstAncestor(javaElement);
            } else {
                boolean is50OrHigher = JdtUtils.is50OrHigher(javaElement);
                if (!is50OrHigher && (JdtUtils.isAnonymousType(javaElement) || JdtUtils.isLocal(javaElement))) {
                    sb.append(JdtUtils.getElementName(topAncestor));
                    sb.append('$');
                } else {
                    topAncestor = JdtUtils.getFirstAncestor(javaElement);
                    while (topAncestor != null) {
                        sb.insert(0, JdtUtils.getElementName(topAncestor) + '$');
                        topAncestor = JdtUtils.getFirstAncestor(topAncestor);
                    }
                }
            }
        }
        sb.append(JdtUtils.getElementName(javaElement));
        return sb.toString();
    }

    private static void collectAllAnonymous(List list, IType anonType) {
        boolean allowNested = !JdtUtils.is50OrHigher((IJavaElement)anonType);
        IType declaringType = allowNested ? (IType)JdtUtils.getLastAncestor((IJavaElement)anonType, 7) : anonType.getDeclaringType();
        try {
            JdtUtils.collectAllAnonymous(list, (IParent)declaringType, allowNested);
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.log(e, 4);
        }
        JdtUtils.sortAnonymous(list, anonType);
    }

    private static void collectAllAnonymous(List list, IParent parent, boolean allowNested) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IJavaElement childElem = children[i];
            if (JdtUtils.isAnonymousType(childElem)) {
                list.add(childElem);
            }
            if (!(childElem instanceof IParent) || !allowNested && childElem instanceof IType) continue;
            JdtUtils.collectAllAnonymous(list, (IParent)childElem, allowNested);
        }
    }

    private static int getAnonimousIndex(IType anonType, IType[] anonymous) {
        for (int i = 0; i < anonymous.length; ++i) {
            if (anonymous[i] != anonType) continue;
            return i + 1;
        }
        return -1;
    }

    private static void sortAnonymous(List anonymous, IType anonType) {
        SourceOffsetComparator sourceComparator = new SourceOffsetComparator();
        AnonymClassComparator classComparator = new AnonymClassComparator(anonType, sourceComparator);
        Collections.sort(anonymous, classComparator);
        if (BytecodeOutlinePlugin.debug) {
            JdtUtils.debugCompilePrio(classComparator);
        }
    }

    private static void debugCompilePrio(AnonymClassComparator classComparator) {
        final Map map = classComparator.map;
        Comparator prioComp = new Comparator(){

            public int compare(Object e1, Object e2) {
                int result = ((Comparable)map.get(e1)).compareTo(map.get(e2));
                if (result == 0) {
                    return e1.toString().compareTo(e2.toString());
                }
                return -result;
            }
        };
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys, prioComp);
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            System.out.println(map.get(key) + " : " + key);
        }
    }

    private static int getAnonCompilePriority50(IJavaElement javaElement, IJavaElement firstAncestor, IJavaElement topAncestor) {
        IJavaElement initBlock = JdtUtils.getLastAncestor(javaElement, 10);
        if (initBlock != null) {
            return 10;
        }
        return 5;
    }

    private static int getAnonCompilePriority(IJavaElement elt, IJavaElement firstAncestor, IJavaElement topAncestor, boolean is50OrHigher) {
        if (is50OrHigher) {
            return JdtUtils.getAnonCompilePriority50(elt, firstAncestor, topAncestor);
        }
        IJavaElement firstNonAnon = JdtUtils.getFirstNonAnonymous(elt, topAncestor);
        if (topAncestor != firstNonAnon && JdtUtils.isLocal(firstNonAnon)) {
            return 5;
        }
        IJavaElement initBlock = JdtUtils.getLastAncestor(elt, 10);
        if (initBlock != null) {
            if (JdtUtils.isAnyParentLocal(firstAncestor, topAncestor)) {
                return 5;
            }
            if (firstAncestor == topAncestor) {
                return 10;
            }
            if (!JdtUtils.isStatic((IMember)firstNonAnon)) {
                return 8;
            }
            return 7;
        }
        if (firstNonAnon != topAncestor) {
            if (!JdtUtils.isStatic((IMember)firstNonAnon)) {
                return 7;
            }
            return 6;
        }
        return 5;
    }

    private static boolean isStatic(IMember firstNonAnon) {
        int topFlags = 0;
        try {
            topFlags = firstNonAnon.getFlags();
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.log(e, 4);
        }
        return Flags.isStatic((int)topFlags);
    }

    public static ClassLoader getClassLoader(IJavaElement type) {
        IJavaProject javaProject = type.getJavaProject();
        ArrayList urls = new ArrayList();
        JdtUtils.getClassURLs(javaProject, urls);
        ClassLoader cl = urls.isEmpty() ? (class$de$loskutov$bco$ui$JdtUtils == null ? (class$de$loskutov$bco$ui$JdtUtils = JdtUtils.class$("de.loskutov.bco.ui.JdtUtils")) : class$de$loskutov$bco$ui$JdtUtils).getClassLoader() : new URLClassLoader(urls.toArray(new URL[urls.size()]));
        return cl;
    }

    private static void getClassURLs(IJavaProject javaProject, List urls) {
        IProject project = javaProject.getProject();
        IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
        IClasspathEntry[] paths = null;
        IPath defaultOutputLocation = null;
        try {
            paths = javaProject.getResolvedClasspath(true);
            defaultOutputLocation = javaProject.getOutputLocation();
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        if (paths != null) {
            IPath projectPath = javaProject.getProject().getLocation();
            for (int i = 0; i < paths.length; ++i) {
                IClasspathEntry cpEntry = paths[i];
                IPath p = null;
                if (cpEntry.getEntryKind() == 3) {
                    p = cpEntry.getOutputLocation();
                    if (p == null) {
                        p = defaultOutputLocation;
                    }
                } else {
                    if (cpEntry.getEntryKind() == 2) {
                        String projName = cpEntry.getPath().toPortableString().substring(1);
                        IProject proj = workspaceRoot.getProject(projName);
                        IJavaProject projj = JavaCore.create((IProject)proj);
                        JdtUtils.getClassURLs(projj, urls);
                        continue;
                    }
                    p = cpEntry.getPath();
                }
                if (p == null || !p.toFile().exists() && !(p = projectPath.append(p.removeFirstSegments(1))).toFile().exists()) continue;
                try {
                    urls.add(p.toFile().toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    BytecodeOutlinePlugin.log(e, 4);
                }
            }
        }
    }

    public static boolean isAbstractOrInterface(IJavaElement javaEl) {
        if (javaEl == null) {
            return true;
        }
        boolean abstractOrInterface = false;
        try {
            switch (javaEl.getElementType()) {
                case 6: {
                    IClassFile classFile = (IClassFile)javaEl;
                    if (JdtUtils.isOnClasspath(javaEl)) {
                        abstractOrInterface = classFile.isInterface();
                    }
                    break;
                }
                case 5: {
                    ICompilationUnit cUnit = (ICompilationUnit)javaEl;
                    IType type = cUnit.findPrimaryType();
                    abstractOrInterface = type != null && type.isInterface();
                    break;
                }
                case 7: {
                    abstractOrInterface = ((IType)javaEl).isInterface();
                    break;
                }
                case 9: {
                    abstractOrInterface = Flags.isAbstract((int)((IMethod)javaEl).getFlags());
                    if (!abstractOrInterface) {
                        IType ancestor = (IType)javaEl.getAncestor(7);
                        abstractOrInterface = ancestor != null && ancestor.isInterface();
                    }
                    break;
                }
                default: {
                    IType ancestor1 = (IType)javaEl.getAncestor(7);
                    abstractOrInterface = ancestor1 != null && ancestor1.isInterface();
                    break;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return abstractOrInterface;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class AnonymClassComparator
    implements Comparator {
        private final IType topAncestorType;
        private final SourceOffsetComparator sourceComparator;
        private final boolean is50OrHigher;
        private final Map map;

        public AnonymClassComparator(IType javaElement, SourceOffsetComparator sourceComparator) {
            this.sourceComparator = sourceComparator;
            this.is50OrHigher = JdtUtils.is50OrHigher((IJavaElement)javaElement);
            this.topAncestorType = (IType)JdtUtils.getLastAncestor((IJavaElement)javaElement, 7);
            this.map = new IdentityHashMap();
        }

        private int compare50(IType m1, IType m2) {
            int compilePrio2;
            IType firstAncestor1 = JdtUtils.getFirstAncestor((IJavaElement)m1);
            IType firstAncestor2 = JdtUtils.getFirstAncestor((IJavaElement)m2);
            int compilePrio1 = this.getCompilePrio(m1, (IJavaElement)firstAncestor1);
            if (compilePrio1 > (compilePrio2 = this.getCompilePrio(m2, (IJavaElement)firstAncestor2))) {
                return -1;
            }
            if (compilePrio1 < compilePrio2) {
                return 1;
            }
            return this.sourceComparator.compare(m1, m2);
        }

        public int compare(Object o1, Object o2) {
            int topAncestorDistance2;
            boolean isLocal;
            int compilePrio2;
            if (o1 == o2) {
                return 0;
            }
            IType m1 = (IType)o1;
            IType m2 = (IType)o2;
            if (this.is50OrHigher) {
                return this.compare50(m1, m2);
            }
            IType firstAncestor1 = JdtUtils.getFirstAncestor((IJavaElement)m1);
            IType firstAncestor2 = JdtUtils.getFirstAncestor((IJavaElement)m2);
            int compilePrio1 = this.getCompilePrio(m1, (IJavaElement)firstAncestor1);
            if (compilePrio1 > (compilePrio2 = this.getCompilePrio(m2, (IJavaElement)firstAncestor2))) {
                return -1;
            }
            if (compilePrio1 < compilePrio2) {
                return 1;
            }
            firstAncestor1 = JdtUtils.getFirstNonAnonymous((IJavaElement)m1, (IJavaElement)this.topAncestorType);
            if (firstAncestor1 == (firstAncestor2 = JdtUtils.getFirstNonAnonymous((IJavaElement)m2, (IJavaElement)this.topAncestorType))) {
                boolean fromInitBlock2;
                boolean fromInitBlock1;
                if (JdtUtils.isLocal((IJavaElement)firstAncestor1) && (fromInitBlock1 = JdtUtils.isFromInitBlock(m1)) ^ (fromInitBlock2 = JdtUtils.isFromInitBlock(m2))) {
                    return fromInitBlock1 ? -1 : 1;
                }
                return this.sourceComparator.compare(o1, o2);
            }
            boolean bl = isLocal = JdtUtils.isLocal((IJavaElement)firstAncestor1) || JdtUtils.isLocal((IJavaElement)firstAncestor2);
            if (isLocal) {
                return this.sourceComparator.compare(o1, o2);
            }
            int topAncestorDistance1 = JdtUtils.getTopAncestorDistance((IJavaElement)firstAncestor1, (IJavaElement)this.topAncestorType);
            if (topAncestorDistance1 > (topAncestorDistance2 = JdtUtils.getTopAncestorDistance((IJavaElement)firstAncestor2, (IJavaElement)this.topAncestorType))) {
                return -1;
            }
            if (topAncestorDistance1 < topAncestorDistance2) {
                return 1;
            }
            return this.sourceComparator.compare(o1, o2);
        }

        private int getCompilePrio(IType anonType, IJavaElement firstAncestor) {
            int compilePrio;
            Integer prio = (Integer)this.map.get(anonType);
            if (prio != null) {
                compilePrio = prio;
                if (BytecodeOutlinePlugin.debug) {
                    System.out.println("Using cache");
                }
            } else {
                compilePrio = JdtUtils.getAnonCompilePriority((IJavaElement)anonType, firstAncestor, (IJavaElement)this.topAncestorType, this.is50OrHigher);
                this.map.put(anonType, compilePrio);
                if (BytecodeOutlinePlugin.debug) {
                    System.out.println("Calculating value!");
                }
            }
            return compilePrio;
        }
    }

    static class SourceOffsetComparator
    implements Comparator {
        SourceOffsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            int idx2;
            int idx1;
            IType m1 = (IType)o1;
            IType m2 = (IType)o2;
            try {
                ISourceRange sr1 = m1.getSourceRange();
                ISourceRange sr2 = m2.getSourceRange();
                if (sr1 == null || sr2 == null) {
                    return 0;
                }
                idx1 = sr1.getOffset();
                idx2 = sr2.getOffset();
            }
            catch (JavaModelException e) {
                BytecodeOutlinePlugin.log(e, 4);
                return 0;
            }
            return idx1 - idx2;
        }
    }
}

