/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import org.eclipse.jface.viewers.StructuredViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceSearcher;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;

public class OracleSourceSearchAction
implements Runnable {
    private StructuredViewer viewer;
    private Folder folder;

    public OracleSourceSearchAction(StructuredViewer viewer, Folder folder) {
        this.viewer = viewer;
        this.folder = folder;
    }

    public void run() {
        try {
            Connection con = Transaction.getInstance(this.folder.getDbConfig()).getConnection();
            Schema schema = (Schema)this.folder.getParent();
            String owner = schema.getName();
            String type = this.folder.getName();
            OracleSourceInfo[] infos = OracleSourceSearcher.execute(con, owner, type);
            OracleSourceSearchAction.AddSources(con, this.folder, infos);
            if (this.viewer != null) {
                this.viewer.refresh((Object)this.folder);
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private static void AddSources(Connection con, Folder folder, OracleSourceInfo[] infos) throws Exception {
        int i = 0;
        while (i < infos.length) {
            OracleSource source = new OracleSource();
            source.setOracleSourceInfo(infos[i]);
            folder.addChild(source);
            ++i;
        }
    }
}

