/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import zigen.plugin.db.ui.dialogs.DriverContentProvider;
import zigen.plugin.db.ui.dialogs.DriverLabelProvider;
import zigen.plugin.db.ui.dialogs.Messages;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.TreeLeaf;

public class DriverSelectDialog
extends TitleAreaDialog {
    TreeViewer viewer;
    List targetNames;
    IContainer container;
    private String title = Messages.getString("DriverSelectDialog.0");

    public DriverSelectDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        super.setTitle(this.title);
        super.setMessage(Messages.getString("DriverSelectDialog.1"), 0);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.viewer = new TreeViewer(composite2, 2050);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(768));
        this.viewer.setContentProvider((IContentProvider)new DriverContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DriverLabelProvider());
        this.viewer.setInput((Object)this);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DriverSelectDialog.this.selectionChangeHandler(event);
            }
        });
        this.viewer.expandAll();
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control ctl = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        return ctl;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private void selectionChangeHandler(SelectionChangedEvent event) {
        StructuredSelection ss = (StructuredSelection)event.getSelection();
        this.targetNames = new ArrayList();
        boolean enabeld = false;
        Iterator iter = ss.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof DataBase) continue;
            enabeld = true;
            TreeLeaf leaf = (TreeLeaf)element;
            this.targetNames.add(leaf.getName());
        }
        this.getButton(0).setEnabled(enabeld);
    }

    protected Point getInitialSize() {
        return new Point(480, 450);
    }

    public IContainer getContainer() {
        return this.container;
    }

    public List getTargetNames() {
        return this.targetNames;
    }
}

