/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.ui.handlers.IHandlerService;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.contentassist.ColumnContentAssistantProcessor;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.views.internal.SQLWhitespaceDetector;

public class TableViewEditorFor32
extends TableViewEditorFor31
implements ITableViewEditor {
    private int wordLen = 0;
    private boolean contentAssisting = false;
    private boolean proposalFiltering = false;
    static final String[] Keywords = new String[]{"AND", "ASC", "BETWEEN", "BY", "DESC", "EXISTS", "IN", "IS NULL", "IS NOT NULL", "LIKE", "NOT", "NOT EXISTS", "NULL", "OR", "ORDER BY"};
    IContentProposalProvider proposal = null;
    ContentAssistHandler fContentAssistHandler;
    static /* synthetic */ Class class$0;

    protected void conditionEventHandler(KeyEvent e) {
        if (e.character == '\r' && !this.contentAssisting) {
            e.doit = true;
            this.whereString = this.conditionComb.getText();
            this.pager.setPageNo(1);
            this.offset = 1;
            this.limit = DbPlugin.getDefault().getPreferenceStore().getInt("PreferencePage.MaxViewRecord");
            this.updateTableViewer(this.whereString, this.offset, this.limit);
        } else if (e.stateMask == 262144 && e.character == ' ' || e.stateMask == 262144 && e.keyCode == 32) {
            this.contentAssisting = true;
            e.doit = false;
        }
    }

    private String getPreviousWord(String contents, int position) {
        SQLWhitespaceDetector whiteSpace = new SQLWhitespaceDetector();
        StringBuffer buf = new StringBuffer();
        try {
            while (true) {
                char c;
                if (whiteSpace.isWhitespace(c = contents.charAt(--position)) || c == '.') {
                    return buf.reverse().toString();
                }
                buf.append(c);
            }
        }
        catch (Exception exception) {
            return buf.reverse().toString();
        }
    }

    protected void AddContentAssist2() {
        try {
            Column[] columns = this.tableNode.getColumns();
            this.proposal = new ColumnContentProposal(columns);
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            new ContentProposalAdapter((Control)this.conditionComb, (IControlContentAdapter)new ColumnComboContentAdapter(), this.proposal, keyStroke, null);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    protected void AddContentAssist() {
        if (this.fContentAssistHandler == null) {
            this.fContentAssistHandler = ContentAssistHandler.createHandlerForCombo((Combo)this.conditionComb, (SubjectControlContentAssistant)this.createContentAssistant());
            this.fContentAssistHandler.setEnabled(true);
        }
    }

    public SubjectControlContentAssistant createContentAssistant() {
        SubjectControlContentAssistant contentAssistant = new SubjectControlContentAssistant();
        Column[] columns = this.tableNode.getColumns();
        ColumnContentAssistantProcessor processor = new ColumnContentAssistantProcessor(columns);
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        contentAssistant.enableAutoActivation(true);
        contentAssistant.enableAutoInsert(true);
        return contentAssistant;
    }

    protected void setKeyBinding() {
        try {
            IEditorSite iEditorSite = this.getEditorSite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IHandlerService service = (IHandlerService)iEditorSite.getService((Class)clazz);
            service.activateHandler("zigen.plugin.InsertRecordCommand", (IHandler)new ActionHandler((IAction)this.insertRecordAction));
        }
        catch (NoClassDefFoundError e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private class ColumnComboContentAdapter
    extends ComboContentAdapter {
        private ColumnComboContentAdapter() {
        }

        public void insertControlContents(Control control, String text, int cursorPosition) {
            super.insertControlContents(control, text, cursorPosition);
            TableViewEditorFor32.this.contentAssisting = false;
        }

        public void setControlContents(Control control, String text, int cursorPosition) {
            super.setControlContents(control, text, cursorPosition);
        }

        public void setCursorPosition(Control control, int index) {
            Combo cmb = (Combo)control;
            String text = cmb.getText();
            cmb.setText(String.valueOf(text.substring(0, index - TableViewEditorFor32.this.wordLen)) + text.substring(index));
            super.setCursorPosition(control, index - TableViewEditorFor32.this.wordLen);
        }
    }

    private class ColumnContentProposal
    implements IContentProposalProvider {
        IContentProposal[] contentProposals;
        Column[] columns;

        public ColumnContentProposal(Column[] columns) {
            this.columns = columns;
            this.contentProposals = new IContentProposal[columns.length + Keywords.length];
        }

        private void setColumnProposal(List proposalList, String word) {
            int i = 0;
            while (i < this.columns.length) {
                Object p;
                Column col = this.columns[i];
                String colName = col.getName();
                String value = ContentAssistUtil.subString(colName, TableViewEditorFor32.this.wordLen);
                if (word != null && !"".equals(word)) {
                    TableViewEditorFor32.this.proposalFiltering = true;
                    if (value.compareToIgnoreCase(word) == 0) {
                        p = new IContentProposal(this, colName, col){
                            final /* synthetic */ ColumnContentProposal this$1;
                            private final /* synthetic */ String val$colName;
                            private final /* synthetic */ Column val$col;
                            {
                                this.this$1 = columnContentProposal;
                                this.val$colName = string;
                                this.val$col = column;
                            }

                            public String getContent() {
                                return this.val$colName;
                            }

                            public String getDescription() {
                                return null;
                            }

                            public String getLabel() {
                                return this.val$col.getColumnLabel();
                            }

                            public int getCursorPosition() {
                                return this.val$col.getName().length();
                            }
                        };
                        proposalList.add(p);
                    }
                } else {
                    TableViewEditorFor32.this.proposalFiltering = false;
                    p = new IContentProposal(this, colName, col){
                        final /* synthetic */ ColumnContentProposal this$1;
                        private final /* synthetic */ String val$colName;
                        private final /* synthetic */ Column val$col;
                        {
                            this.this$1 = columnContentProposal;
                            this.val$colName = string;
                            this.val$col = column;
                        }

                        public String getContent() {
                            return this.val$colName;
                        }

                        public String getDescription() {
                            return null;
                        }

                        public String getLabel() {
                            return this.val$col.getColumnLabel();
                        }

                        public int getCursorPosition() {
                            return this.val$col.getName().length();
                        }
                    };
                    proposalList.add(p);
                }
                ++i;
            }
        }

        private void setKeywordProposal(List proposalList, String word) {
            int i = 0;
            while (i < Keywords.length) {
                Object p;
                String keyword = Keywords[i];
                String value = ContentAssistUtil.subString(keyword, TableViewEditorFor32.this.wordLen);
                if (word != null && !"".equals(word)) {
                    TableViewEditorFor32.this.proposalFiltering = true;
                    if (value.compareToIgnoreCase(word) == 0) {
                        p = new IContentProposal(this, keyword){
                            final /* synthetic */ ColumnContentProposal this$1;
                            private final /* synthetic */ String val$keyword;
                            {
                                this.this$1 = columnContentProposal;
                                this.val$keyword = string;
                            }

                            public String getContent() {
                                return this.val$keyword;
                            }

                            public String getDescription() {
                                return null;
                            }

                            public String getLabel() {
                                return this.val$keyword;
                            }

                            public int getCursorPosition() {
                                return this.val$keyword.length();
                            }
                        };
                        proposalList.add(p);
                    }
                } else {
                    TableViewEditorFor32.this.proposalFiltering = false;
                    p = new IContentProposal(this, keyword){
                        final /* synthetic */ ColumnContentProposal this$1;
                        private final /* synthetic */ String val$keyword;
                        {
                            this.this$1 = columnContentProposal;
                            this.val$keyword = string;
                        }

                        public String getContent() {
                            return this.val$keyword;
                        }

                        public String getDescription() {
                            return null;
                        }

                        public String getLabel() {
                            return this.val$keyword;
                        }

                        public int getCursorPosition() {
                            return this.val$keyword.length();
                        }
                    };
                    proposalList.add(p);
                }
                ++i;
            }
        }

        public IContentProposal[] getProposals(String contents, int position) {
            ArrayList proposalList = new ArrayList();
            String word = TableViewEditorFor32.this.getPreviousWord(contents, position);
            TableViewEditorFor32.this.wordLen = word.length();
            this.setColumnProposal(proposalList, word);
            this.setKeywordProposal(proposalList, word);
            if (proposalList.size() == 0) {
                TableViewEditorFor32.this.contentAssisting = false;
            }
            return proposalList.toArray(new IContentProposal[0]);
        }
    }
}

