/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.ListenerList;
import org.epic.core.model.ISourceFileListener;
import org.epic.core.model.PODComment;
import org.epic.core.model.Package;
import org.epic.core.model.Subroutine;
import org.epic.core.parser.CurlyToken;
import org.epic.core.parser.PerlToken;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PartitionTypes;
import org.epic.perleditor.editors.PerlPartitioner;

public class SourceFile {
    private final ListenerList listeners = new ListenerList(1);
    private final ILog log;
    private final IDocument doc;
    private List pods;
    private List packages;

    public SourceFile(ILog log, IDocument doc) {
        assert (log != null);
        assert (doc != null);
        this.log = log;
        this.doc = doc;
        this.pods = Collections.EMPTY_LIST;
        this.packages = Collections.EMPTY_LIST;
    }

    public synchronized void addListener(ISourceFileListener listener) {
        this.listeners.add((Object)listener);
    }

    public IDocument getDocument() {
        return this.doc;
    }

    public List getPackages() {
        return Collections.unmodifiableList(this.packages);
    }

    public Iterator getPODs() {
        return Collections.unmodifiableList(this.pods).iterator();
    }

    public Iterator getSubs() {
        return new SubIterator();
    }

    public Iterator getUses() {
        return new ModuleUseIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse() {
        this.pods = new ArrayList();
        this.packages = new ArrayList();
        PerlPartitioner partitioner = (PerlPartitioner)PartitionTypes.getPerlPartitioner(this.doc);
        if (partitioner == null) {
            return;
        }
        Object object = partitioner.getTokensLock();
        synchronized (object) {
            try {
                ParsingState state = new ParsingState(partitioner.getTokens());
                while (state.hasMoreTokens()) {
                    state.processToken();
                }
                state.finish();
            }
            catch (BadLocationException e) {
                this.log.log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Unexpected exception: " + ((Object)((Object)e)).getClass().getName() + "; report it as a bug " + "in plug-in " + PerlEditorPlugin.getPluginId(), (Throwable)e));
            }
        }
        this.fireSourceFileChanged();
    }

    public synchronized void removeListener(ISourceFileListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void addPOD(PerlToken podStart, PerlToken podEnd) throws BadLocationException {
        this.pods.add(new PODComment(podStart, podEnd));
    }

    private void fireSourceFileChanged() {
        Object[] listeners = this.listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISourceFileListener)listeners[i]).sourceFileChanged(this);
            ++i;
        }
    }

    private class ModuleUseIterator
    implements Iterator {
        private Iterator pkgIterator;
        private Iterator useIterator;

        public ModuleUseIterator() {
            this.pkgIterator = SourceFile.this.packages.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            while (this.useIterator == null || !this.useIterator.hasNext()) {
                if (this.pkgIterator.hasNext()) {
                    Package pkg = (Package)this.pkgIterator.next();
                    this.useIterator = pkg.getUses().iterator();
                    continue;
                }
                return false;
            }
            return true;
        }

        public Object next() {
            return this.useIterator.next();
        }
    }

    private class ParsingState {
        private final int tokenCount;
        private final List tokens;
        private int tIndex = 0;
        private PerlToken t;
        private int type;
        private int blockLevel;
        private Stack pkgStack;
        private Stack subStack;
        private PerlToken podStart;
        private PerlToken packageKeyword;
        private PerlToken subKeyword;
        private PerlToken useKeyword;
        private PerlToken subName;
        private boolean inSubProto;

        public ParsingState(List tokens) {
            this.tokens = tokens;
            this.tokenCount = tokens.size();
            this.pkgStack = new Stack();
            this.subStack = new Stack();
        }

        public void finish() {
            this.closePackage();
            this.closeSub();
        }

        public boolean hasMoreTokens() {
            return this.tIndex < this.tokenCount;
        }

        public void processToken() throws BadLocationException {
            this.t = (PerlToken)((Object)this.tokens.get(this.tIndex));
            this.type = this.t.getType();
            this.updateBlockLevel();
            this.updatePackageState();
            this.updateSubState();
            this.updateUseState();
            this.updatePODState();
            ++this.tIndex;
        }

        private void closePackage() {
            if (this.pkgStack.isEmpty()) {
                return;
            }
            Package pkg = (Package)this.pkgStack.peek();
            if (this.blockLevel > pkg.getBlockLevel()) {
                return;
            }
            this.pkgStack.pop();
            pkg.setLastToken((PerlToken)((Object)this.tokens.get(this.tIndex - 1)));
        }

        private void closeSub() {
            if (this.subStack.isEmpty()) {
                return;
            }
            Subroutine sub = (Subroutine)this.subStack.peek();
            if (this.blockLevel - 1 > sub.getBlockLevel()) {
                return;
            }
            this.subStack.pop();
            if (this.t instanceof CurlyToken) {
                sub.setCloseCurly((CurlyToken)this.t);
            }
        }

        private Package getCurrentPackage() {
            if (this.pkgStack.isEmpty()) {
                this.openPackage(new Package());
            }
            return (Package)this.pkgStack.peek();
        }

        private void openPackage(Package pkg) {
            this.pkgStack.push(pkg);
            SourceFile.this.packages.add(pkg);
        }

        private void updateBlockLevel() {
            if (this.type == 14) {
                ++this.blockLevel;
            } else if (this.type == 18) {
                this.closeSub();
                this.closePackage();
                --this.blockLevel;
            }
        }

        private void updateSubState() throws BadLocationException {
            if (this.type == 89) {
                this.subKeyword = this.t;
                this.subName = null;
                this.inSubProto = false;
            }
            if (this.subKeyword != null) {
                if (this.subName == null && this.type == 80) {
                    this.subName = this.t;
                } else if (!this.inSubProto && this.type == 30) {
                    this.subKeyword = null;
                    this.subName = null;
                    this.inSubProto = false;
                } else if (this.type == 13) {
                    this.inSubProto = true;
                } else if (this.type == 17) {
                    this.inSubProto = false;
                } else if (this.type == 14) {
                    if (this.subName != null) {
                        Subroutine sub = this.getCurrentPackage().addSub(this.subKeyword, this.subName, (CurlyToken)this.t);
                        this.subStack.push(sub);
                    }
                    this.subKeyword = null;
                    this.subName = null;
                    this.inSubProto = false;
                }
            }
        }

        private void updatePackageState() {
            if (this.packageKeyword == null) {
                if (this.type == 102) {
                    this.closePackage();
                    this.packageKeyword = this.t;
                }
            } else if (this.type == 80) {
                this.openPackage(new Package(SourceFile.this.packages.size(), this.blockLevel, this.packageKeyword, this.t));
                this.packageKeyword = null;
            }
        }

        private void updatePODState() throws BadLocationException {
            if (this.podStart == null) {
                if (this.type == 27) {
                    this.podStart = this.t;
                }
            } else if (this.type == 29) {
                SourceFile.this.addPOD(this.podStart, this.t);
                this.podStart = null;
            }
        }

        private void updateUseState() throws BadLocationException {
            if (this.useKeyword == null) {
                if (this.type == 88) {
                    this.useKeyword = this.t;
                }
            } else if (this.type == 80) {
                String text = this.t.getText();
                if (!("constant".equals(text) || "warnings".equals(text) || "strict".equals(text) || "vars".equals(text))) {
                    this.getCurrentPackage().addUse(this.useKeyword, this.t);
                }
                this.useKeyword = null;
            }
        }
    }

    private class SubIterator
    implements Iterator {
        private Iterator pkgIterator;
        private Iterator subIterator;

        public SubIterator() {
            this.pkgIterator = SourceFile.this.packages.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            while (this.subIterator == null || !this.subIterator.hasNext()) {
                if (this.pkgIterator.hasNext()) {
                    Package pkg = (Package)this.pkgIterator.next();
                    this.subIterator = pkg.getSubs().iterator();
                    continue;
                }
                return false;
            }
            return true;
        }

        public Object next() {
            return this.subIterator.next();
        }
    }
}

