/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import java.io.IOException;
import java.io.Reader;

public class StringReaderThread
extends Thread {
    private final Object lock = new Object();
    private Reader reader;
    private String result;
    private IOException exception;
    private boolean disposed;

    public StringReaderThread(String name) {
        super("EPIC:StringReader" + name);
        this.start();
    }

    public StringReaderThread() {
        this("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.disposed = true;
            this.lock.notifyAll();
        }
        this.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Reader r) {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed) {
                throw new IllegalStateException("thread disposed");
            }
            if (this.reader != null) {
                throw new IllegalStateException("this thread is already reading; call getResult or dispose next");
            }
            this.reader = r;
            this.result = null;
            this.exception = null;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getResult() throws IOException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.reader == null || this.disposed) {
                    if (!this.disposed) break;
                    throw new InterruptedException("StringReaderThread disposed during getResult");
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (!this.disposed) {
            Reader r;
            Object object = this.lock;
            synchronized (object) {
                while (true) {
                    if (this.reader != null || this.disposed) {
                        if (!this.disposed) break;
                        return;
                    }
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                r = this.reader;
            }
            StringBuffer sb = new StringBuffer();
            IOException e = null;
            char[] b = new char[1024];
            try {
                int bread;
                while ((bread = r.read(b)) >= 0) {
                    sb.append(b, 0, bread);
                }
            }
            catch (IOException e2) {
                sb.setLength(0);
                e = e2;
            }
            Object object2 = this.lock;
            synchronized (object2) {
                this.reader = null;
                this.result = sb.toString();
                this.exception = e;
                this.lock.notifyAll();
            }
        }
    }
}

