/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor;

import java.io.File;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.IFileTypeInfo;
import org.eclipse.team.core.Team;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.epic.core.util.PerlExecutor;
import org.epic.perleditor.PerlPluginImages;
import org.epic.perleditor.editors.PerlDocumentProvider;
import org.epic.perleditor.editors.util.PerlColorProvider;
import org.epic.perleditor.preferences.CodeAssistPreferences;
import org.epic.perleditor.preferences.MarkOccurrencesPreferences;
import org.epic.perleditor.preferences.PreferenceConstants;
import org.epic.perleditor.preferences.SourceFormatterPreferences;
import org.epic.perleditor.preferences.TaskTagPreferences;
import org.osgi.framework.BundleContext;

public class PerlEditorPlugin
extends AbstractUIPlugin {
    private static PerlEditorPlugin plugin;
    private ResourceBundle resourceBundle;
    private PerlColorProvider colorProvider = new PerlColorProvider();
    public static final String PERL_EXECUTABLE_PREFERENCE = "PERL_EXECUTABLE";
    private static final String PERL_EXECUTABLE_DEFAULT = "perl";
    public static final String WEB_BROWSER_PREFERENCE = "WEB_BROWSER";
    private static final String WEB_BROWSER_DEFAULT = "http://";
    public static final String WARNINGS_PREFERENCE = "SHOW_WARNINGS";
    public static final String TAINT_MODE_PREFERENCE = "USE_TAINT_MODE";
    public static final String DEBUG_CONSOLE_PREFERENCE = "ENABLE_DEBUG_CONSOLE";
    public static final String SUSPEND_AT_FIRST_PREFERENCE = "SUSPEND_AT_FIRST_CONSOLE";
    private static final boolean WARNINGS_DEFAULT = true;
    private static final boolean TAINT_MODE_DEFAULT = false;
    public static final String INTERPRETER_TYPE_PREFERENCE = "INTERPRETER_TYPE";
    public static final String INTERPRETER_TYPE_STANDARD = "Standard";
    public static final String INTERPRETER_TYPE_CYGWIN = "Cygwin";
    public static final String SYNTAX_VALIDATION_PREFERENCE = "SYNTAX_VALIDATION_PREFERENCE";
    public static final boolean SYNTAX_VALIDATION_PREFERENCE_DEFAULT = true;
    public static final String SYNTAX_VALIDATION_INTERVAL_PREFERENCE = "SYNTAX_VALIDATION_IDLE_INTERVAL";
    public static final int SYNTAX_VALIDATION_INTERVAL_DEFAULT = 400;
    private IDocumentProvider fDocumentProvider;
    private boolean requirePerlCheckPassed;
    private boolean requirePerlErrorDisplayed;

    public PerlEditorPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.epic.perleditor.PerlEditorPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        String[] perlTypes = new String[]{"pl", "pm"};
        IFileTypeInfo[] fileTypes = Team.getAllTypes();
        int newTypesLength = fileTypes.length + perlTypes.length;
        String[] extensions = new String[newTypesLength];
        int[] types = new int[newTypesLength];
        int i = 0;
        while (i < fileTypes.length) {
            extensions[i] = fileTypes[i].getExtension();
            types[i] = fileTypes[i].getType();
            ++i;
        }
        while (i < newTypesLength) {
            extensions[i] = perlTypes[i - fileTypes.length];
            types[i] = 1;
            ++i;
        }
        Team.setAllTypes((String[])extensions, (int[])types);
    }

    public Color getColor(RGB rgb) {
        return this.colorProvider.getColor(rgb);
    }

    public Color getColor(String preferenceKey) {
        return this.getColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)preferenceKey));
    }

    public static PerlEditorPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PerlEditorPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static IWorkbenchWindow getWorkbenchWindow() {
        IWorkbenchWindow window = PerlEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            window = PerlEditorPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0];
        }
        return window;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(PERL_EXECUTABLE_PREFERENCE, PERL_EXECUTABLE_DEFAULT);
        PreferenceConstants.initializeDefaultValues(store);
        store.setDefault(INTERPRETER_TYPE_PREFERENCE, INTERPRETER_TYPE_STANDARD);
        store.setDefault(SYNTAX_VALIDATION_INTERVAL_PREFERENCE, 400);
        store.setDefault("syncOutlineOnCursorMove", true);
        store.setDefault(SUSPEND_AT_FIRST_PREFERENCE, "1");
        SourceFormatterPreferences.initializeDefaultValues(store);
        CodeAssistPreferences.initializeDefaultValues(store);
        TaskTagPreferences.initializeDefaults(store);
        MarkOccurrencesPreferences.initializeDefaultValues(store);
        System.setProperty("sourceCriticEnabled", store.getString("sourceCriticEnabled"));
    }

    public String getExecutablePreference() {
        return this.getPreferenceStore().getString(PERL_EXECUTABLE_PREFERENCE);
    }

    public String getDefaultExecutablePreference() {
        return PERL_EXECUTABLE_DEFAULT;
    }

    public void setExecutablePreference(String value) {
        this.getPreferenceStore().setValue(PERL_EXECUTABLE_PREFERENCE, value);
        this.requirePerlErrorDisplayed = false;
        this.checkForPerlInterpreter(true);
    }

    public String getWebBrowserPreference() {
        return this.getPreferenceStore().getString(WEB_BROWSER_PREFERENCE);
    }

    public String getDefaultWebBrowserPreference() {
        return WEB_BROWSER_DEFAULT;
    }

    public void setWebBrowserPreference(String value) {
        this.getPreferenceStore().setValue(WEB_BROWSER_PREFERENCE, value);
    }

    public boolean getWarningsPreference() {
        String value = this.getPreferenceStore().getString(WARNINGS_PREFERENCE);
        return value.equals("1");
    }

    public boolean getDefaultWarningsPreference() {
        return true;
    }

    public void setTaintPreference(boolean value) {
        this.getPreferenceStore().setValue(TAINT_MODE_PREFERENCE, value ? "1" : "0");
    }

    public boolean getTaintPreference() {
        String value = this.getPreferenceStore().getString(TAINT_MODE_PREFERENCE);
        return value.equals("1");
    }

    public boolean getDebugConsolePreference() {
        String value = this.getPreferenceStore().getString(DEBUG_CONSOLE_PREFERENCE);
        return value.equals("1");
    }

    public void setDebugConsolePreference(boolean value) {
        this.getPreferenceStore().setValue(DEBUG_CONSOLE_PREFERENCE, value ? "1" : "0");
    }

    public boolean getSuspendAtFirstPreference() {
        String value = this.getPreferenceStore().getString(SUSPEND_AT_FIRST_PREFERENCE);
        return value.equals("1");
    }

    public void setSuspendAtFirstPreference(boolean value) {
        this.getPreferenceStore().setValue(SUSPEND_AT_FIRST_PREFERENCE, value ? "1" : "0");
    }

    public boolean getDefaultTaintPreference() {
        return false;
    }

    public void setWarningsPreference(boolean value) {
        this.getPreferenceStore().setValue(WARNINGS_PREFERENCE, value ? "1" : "0");
    }

    public boolean getSyntaxValidationPreference() {
        String value = this.getPreferenceStore().getString(SYNTAX_VALIDATION_PREFERENCE);
        return value.equals("1");
    }

    public boolean getDefaultSyntaxValidationPreference() {
        return true;
    }

    public void setSyntaxValidationPreference(boolean value) {
        this.getPreferenceStore().setValue(SYNTAX_VALIDATION_PREFERENCE, value ? "1" : "0");
    }

    public static String getPluginId() {
        PerlEditorPlugin plugin = PerlEditorPlugin.getDefault();
        return plugin != null ? plugin.getBundle().getSymbolicName() : "org.epic.perleditor";
    }

    public synchronized IDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new PerlDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    public static String getUniqueIdentifier() {
        PerlEditorPlugin plugin = PerlEditorPlugin.getDefault();
        return plugin != null ? plugin.getBundle().getSymbolicName() : "org.epic.perleditor";
    }

    public boolean hasPerlInterpreter() {
        return this.requirePerlCheckPassed;
    }

    public boolean requirePerlInterpreter(boolean interactive) {
        if (!this.requirePerlCheckPassed) {
            this.checkForPerlInterpreter(interactive);
        }
        return this.requirePerlCheckPassed;
    }

    protected ImageRegistry createImageRegistry() {
        return PerlPluginImages.getImageRegistry();
    }

    private void checkForPerlInterpreter(boolean interactive) {
        block8: {
            PerlExecutor executor = new PerlExecutor();
            try {
                try {
                    ArrayList<String> args = new ArrayList<String>(1);
                    args.add("-v");
                    if (executor.execute((File)new File((String)"."), args, (String)"").stdout.indexOf("This is perl") != -1) {
                        this.requirePerlCheckPassed = true;
                        break block8;
                    }
                    Status status = new Status(4, PerlEditorPlugin.getPluginId(), 0, "The executable specified in EPIC Preferences does not appear to be a valid Perl interpreter.", null);
                    this.getLog().log((IStatus)status);
                    if (!this.requirePerlErrorDisplayed || interactive) {
                        this.requirePerlErrorDisplayed = true;
                        this.showErrorDialog("Missing Perl interpreter", "To operate correctly, EPIC requires a Perl interpreter. Check your configuration settings (\"Window/Preferences/Perl EPIC\").", (IStatus)status);
                    }
                    this.requirePerlCheckPassed = false;
                }
                catch (CoreException e) {
                    this.getLog().log(e.getStatus());
                    if (!this.requirePerlErrorDisplayed || interactive) {
                        this.requirePerlErrorDisplayed = true;
                        this.showErrorDialog("Missing Perl interpreter", "To operate correctly, EPIC requires a Perl interpreter. Check your configuration settings (\"Window/Preferences/Perl EPIC\").", e.getStatus());
                    }
                    this.requirePerlCheckPassed = false;
                    executor.dispose();
                }
            }
            finally {
                executor.dispose();
            }
        }
    }

    private void showErrorDialog(final String title, final String msg, final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError(null, (String)title, (String)msg, (IStatus)status);
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        this.colorProvider.dispose();
        super.stop(context);
    }
}

