/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.actions.AbstractOpenDeclaration;
import org.epic.perleditor.actions.OpenPackageDeclaration;
import org.epic.perleditor.actions.OpenSubDeclaration;
import org.epic.perleditor.actions.PerlEditorAction;
import org.epic.perleditor.editors.PerlEditor;

public class OpenDeclarationAction
extends PerlEditorAction {
    private final OpenSubDeclaration openSub = new OpenSubDeclaration(this);
    private final OpenPackageDeclaration openPackage = new OpenPackageDeclaration(this);

    public OpenDeclarationAction(PerlEditor editor) {
        super(editor);
    }

    public void run(ITextSelection selection) {
        AbstractOpenDeclaration.Result res2;
        AbstractOpenDeclaration.Result res1 = this.openSub.run(selection);
        if (!res1.isFound() && !(res2 = this.openPackage.run(selection)).isFound()) {
            this.reportFailure(res1);
        }
    }

    @Override
    protected void doRun() {
        AbstractOpenDeclaration.Result res2;
        AbstractOpenDeclaration.Result res1 = this.openSub.run();
        if (!res1.isFound() && !(res2 = this.openPackage.run()).isFound()) {
            this.reportFailure(res1);
        }
    }

    @Override
    protected String getPerlEditorActionId() {
        return "org.epic.perleditor.actions.OpenDeclarationAction";
    }

    private void messageBox(String title, String message) {
        Shell shell = PerlEditorPlugin.getWorkbenchWindow().getShell();
        MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
    }

    private void reportFailure(AbstractOpenDeclaration.Result result) {
        switch (result.statusCode) {
            case 1: {
                this.messageBox("Declaration not found", "Could not locate declaration for \"" + result.searchString + "\".\n" + "Check Perl Include Path in Project Properties.");
                break;
            }
            case 3: {
                this.messageBox("Nothing was selected", "No valid name could be located within the selection scope.");
                break;
            }
            case 2: {
                this.messageBox("Module file not found", "Could not locate module file for package " + result.targetModule + "\n" + "Check Perl Include Path in Project Properties.");
            }
        }
    }
}

