/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.epic.core.model.SourceFile;
import org.epic.core.model.Subroutine;
import org.epic.perleditor.actions.AbstractOpenDeclaration;
import org.epic.perleditor.actions.OpenDeclarationAction;
import org.epic.perleditor.editors.PartitionTypes;

class OpenSubDeclaration
extends AbstractOpenDeclaration {
    public OpenSubDeclaration(OpenDeclarationAction action) {
        super(action);
    }

    @Override
    protected IRegion findDeclaration(SourceFile sourceFile, String subName) {
        Iterator i = sourceFile.getSubs();
        while (i.hasNext()) {
            Subroutine sub = (Subroutine)i.next();
            if (!sub.getName().equals(subName)) continue;
            return new Region(sub.getOffset(), sub.getLength());
        }
        return null;
    }

    @Override
    protected String getLocalSearchString(String searchString) {
        int lastSepIndex = searchString.lastIndexOf("::");
        return lastSepIndex != -1 ? searchString.substring(lastSepIndex + 2) : null;
    }

    @Override
    protected String getSearchString(ITextSelection selection) {
        return this.getSelectedSubName(selection);
    }

    @Override
    protected String getTargetModule(String subName) {
        if (subName.indexOf("::") != -1) {
            int lastSepIndex = subName.lastIndexOf("::");
            return subName.substring(0, lastSepIndex);
        }
        return null;
    }

    private String getSelectedSubName(ITextSelection selection) {
        ITypedRegion partition;
        IDocument doc;
        block3: {
            doc = this.getSourceDocument();
            try {
                partition = PartitionTypes.getPerlPartition(doc, selection.getOffset());
                if (partition.getType().equals("__dftl_partition_content_type")) break block3;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        String subName = doc.get(partition.getOffset(), partition.getLength());
        return subName.indexOf(38) == 0 ? subName.substring(1) : subName;
    }
}

