/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.editors;

import net.sf.colorer.FileType;
import net.sf.colorer.Group;
import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.ImageStore;
import net.sf.colorer.eclipse.Messages;
import net.sf.colorer.eclipse.jface.IColorerEditorAdapter;
import net.sf.colorer.eclipse.jface.TextColorer;
import net.sf.colorer.handlers.LineRegion;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;

public class ColorerActionContributor
extends TextEditorActionContributor {
    public static final String ACTION_ID_PAIRMATCH = "net.sf.colorer.eclipse.editors.PairMatchAction";
    public static final String ACTION_ID_PAIRSELECT = "net.sf.colorer.eclipse.editors.pairselect";
    public static final String ACTION_ID_PAIRSELECTCONTENT = "net.sf.colorer.eclipse.editors.pairselectcontent";
    public static final String ACTION_ID_CHOOSETYPE = "net.sf.colorer.eclipse.editors.choosetype";
    public static final String ACTION_ID_FOLDING_COLLAPSE_COMMENTS = "net.sf.colorer.eclipse.editors.folding.collapseComments";
    public static final String ACTION_ID_WORD_WRAP = "net.sf.colorer.eclipse.editors.WordWrapAction";
    ITextEditor activeEditor = null;
    Action pairMatchAction = new PairMatchAction();
    Action pairSelectAction = new PairSelectAction();
    Action pairSelectContentAction = new PairSelectContentAction();
    Action cursorRegionAction = new Action(){

        public void run() {
            if (ColorerActionContributor.this.getTextColorer() == null) {
                return;
            }
            LineRegion lr = ColorerActionContributor.this.getTextColorer().getCaretRegion();
            if (lr == null) {
                return;
            }
            StyledText text = ColorerActionContributor.this.getStyledText();
            Assert.isNotNull((Object)text);
            int loffset = text.getOffsetAtLine(text.getLineAtOffset(text.getCaretOffset()));
            int selstart = loffset + lr.start;
            int selend = lr.end - lr.start;
            if (lr.end == -1) {
                selend = 0;
            }
            text.setSelectionRange(selstart, selend);
        }
    };
    Action hrcupdateAction = new Action(){

        public void run() {
            if (ColorerActionContributor.this.activeEditor != null) {
                ColorerPlugin.getDefault().reloadParserFactory();
            }
        }
    };
    FileTypeActionMenu filetypeAction = new FileTypeActionMenu();
    static /* synthetic */ Class class$org$eclipse$swt$custom$StyledText;

    void showPairError() {
        MessageDialog.openInformation(null, (String)Messages.get("editor.pairerr.title"), (String)Messages.get("editor.pairerr.msg"));
    }

    TextColorer getTextColorer() {
        if (this.activeEditor == null) {
            return null;
        }
        return ((IColorerEditorAdapter)this.activeEditor).getTextColorer();
    }

    StyledText getStyledText() {
        if (this.activeEditor == null) {
            return null;
        }
        return (StyledText)this.activeEditor.getAdapter(class$org$eclipse$swt$custom$StyledText == null ? (class$org$eclipse$swt$custom$StyledText = ColorerActionContributor.class$("org.eclipse.swt.custom.StyledText")) : class$org$eclipse$swt$custom$StyledText);
    }

    IDocument getDocument() {
        return this.activeEditor.getDocumentProvider().getDocument((Object)this.activeEditor.getEditorInput());
    }

    public ColorerActionContributor() {
        this.hrcupdateAction.setText(Messages.get("editor.hrcupdate"));
        this.hrcupdateAction.setToolTipText(Messages.get("editor.hrcupdate.tooltip"));
        this.hrcupdateAction.setImageDescriptor(ImageStore.EDITOR_UPDATEHRC);
        this.hrcupdateAction.setHoverImageDescriptor(ImageStore.EDITOR_UPDATEHRC_A);
        this.hrcupdateAction.setActionDefinitionId("net.sf.colorer.eclipse.editors.hrcupdate");
        this.cursorRegionAction.setActionDefinitionId("net.sf.colorer.eclipse.editors.selectregion");
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator("net.sf.colorer.eclipse.editor.Separator"));
        toolBarManager.add((IAction)this.hrcupdateAction);
        toolBarManager.add((IAction)this.filetypeAction);
        toolBarManager.add((IContributionItem)new Separator("net.sf.colorer.eclipse.editor.Separator1"));
        toolBarManager.add((IAction)this.pairMatchAction);
        toolBarManager.add((IAction)this.pairSelectAction);
        toolBarManager.add((IAction)this.pairSelectContentAction);
    }

    public void dispose() {
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
    }

    public void setActiveEditor(IEditorPart editor) {
        super.setActiveEditor(editor);
        if (!(editor instanceof ITextEditor)) {
            this.activeEditor = null;
            return;
        }
        this.activeEditor = (ITextEditor)editor;
        this.activeEditor.setAction(this.hrcupdateAction.getActionDefinitionId(), (IAction)this.hrcupdateAction);
        this.activeEditor.setAction(this.filetypeAction.getActionDefinitionId(), (IAction)this.filetypeAction);
        this.activeEditor.setAction(this.pairMatchAction.getActionDefinitionId(), (IAction)this.pairMatchAction);
        this.activeEditor.setAction(this.pairSelectAction.getActionDefinitionId(), (IAction)this.pairSelectAction);
        this.activeEditor.setAction(this.pairSelectContentAction.getActionDefinitionId(), (IAction)this.pairSelectContentAction);
        this.activeEditor.setAction(this.cursorRegionAction.getActionDefinitionId(), (IAction)this.cursorRegionAction);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class FileTypeActionMenu
    extends Action
    implements IMenuCreator {
        private Menu filetypeList = null;

        public FileTypeActionMenu() {
            super(Messages.get("editor.filetype"));
            this.setToolTipText(Messages.get("editor.filetype.tooltip"));
            this.setImageDescriptor(ImageStore.EDITOR_FILETYPE);
            this.setHoverImageDescriptor(ImageStore.EDITOR_FILETYPE_A);
            this.setActionDefinitionId(ColorerActionContributor.ACTION_ID_CHOOSETYPE);
            this.setMenuCreator(this);
        }

        public void run() {
            ColorerActionContributor.this.getTextColorer().chooseFileType(ColorerActionContributor.this.activeEditor.getTitle());
        }

        Menu fillMenuTree(Group group, Menu root, FileType cftype) {
            int idx;
            MenuItem mitem = new MenuItem(root, 64);
            mitem.setText(group.getDescription());
            Menu mgroup = new Menu(mitem);
            mitem.setMenu(mgroup);
            mgroup.getParentItem().setImage(ImageStore.EDITOR_GROUP.createImage());
            FileType[] ftypes = group.getFileTypes();
            for (idx = 0; idx < ftypes.length; ++idx) {
                FileTypeAction ft_action = new FileTypeAction(ftypes[idx]);
                if (cftype.equals(ftypes[idx])) {
                    mgroup.getParentItem().setImage(ImageStore.EDITOR_CUR_GROUP.createImage());
                    if (mgroup.getParentItem().getParent().getParentItem() != null) {
                        mgroup.getParentItem().getParent().getParentItem().setImage(ImageStore.EDITOR_CUR_GROUP.createImage());
                    }
                    ft_action.setImageDescriptor(ImageStore.EDITOR_CUR_FILETYPE);
                }
                ActionContributionItem item = new ActionContributionItem((IAction)ft_action);
                item.fill(mgroup, -1);
            }
            for (idx = 0; idx < group.getGroups().length; ++idx) {
                this.fillMenuTree(group.getGroups()[idx], mgroup, cftype);
            }
            return mgroup;
        }

        public Menu getMenu(Control parent) {
            if (this.filetypeList != null) {
                this.filetypeList.dispose();
            }
            this.filetypeList = new Menu(parent);
            Group[] groups = ColorerPlugin.getDefaultPF().getHRCParser().getGroups();
            FileType currentFileType = ColorerActionContributor.this.getTextColorer().getFileType();
            for (int idx = 0; idx < groups.length; ++idx) {
                this.fillMenuTree(groups[idx], this.filetypeList, currentFileType);
            }
            return this.filetypeList;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void dispose() {
            if (this.filetypeList != null) {
                this.filetypeList.dispose();
            }
        }

        class FileTypeAction
        extends Action {
            FileType ftype;

            FileTypeAction(FileType type) {
                super(type.getDescription());
                this.ftype = type;
            }

            public void run() {
                if (ColorerActionContributor.this.getTextColorer() != null) {
                    ColorerActionContributor.this.getTextColorer().setFileType(this.ftype);
                }
            }
        }
    }

    class PairSelectContentAction
    extends Action {
        PairSelectContentAction() {
            super(Messages.get("pair.selectcontent"), ImageStore.EDITOR_PAIR_SELECTCONTENT);
            this.setActionDefinitionId(ColorerActionContributor.ACTION_ID_PAIRSELECTCONTENT);
            this.setToolTipText(Messages.get("pair.selectcontent.tooltip"));
        }

        public void run() {
            if (ColorerActionContributor.this.getTextColorer() == null) {
                return;
            }
            if (!ColorerActionContributor.this.getTextColorer().selectContentPair()) {
                ColorerActionContributor.this.showPairError();
            }
        }
    }

    class PairSelectAction
    extends Action {
        PairSelectAction() {
            super(Messages.get("pair.select"), ImageStore.EDITOR_PAIR_SELECT);
            this.setActionDefinitionId(ColorerActionContributor.ACTION_ID_PAIRSELECT);
            this.setToolTipText(Messages.get("pair.select.tooltip"));
        }

        public void run() {
            if (ColorerActionContributor.this.getTextColorer() == null) {
                return;
            }
            if (!ColorerActionContributor.this.getTextColorer().selectPair()) {
                ColorerActionContributor.this.showPairError();
            }
        }
    }

    class PairMatchAction
    extends Action {
        PairMatchAction() {
            super(Messages.get("pair.find"), ImageStore.EDITOR_PAIR_MATCH);
            this.setActionDefinitionId(ColorerActionContributor.ACTION_ID_PAIRMATCH);
            this.setToolTipText(Messages.get("pair.find.tooltip"));
        }

        public void run() {
            if (ColorerActionContributor.this.getTextColorer() == null) {
                return;
            }
            if (!ColorerActionContributor.this.getTextColorer().matchPair()) {
                ColorerActionContributor.this.showPairError();
            }
        }
    }
}

