/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.editors;

import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.IColorerReloadListener;
import net.sf.colorer.eclipse.Messages;
import net.sf.colorer.eclipse.editors.CollapseCommentsAction;
import net.sf.colorer.eclipse.editors.ColorerSourceViewerConfiguration;
import net.sf.colorer.eclipse.editors.ColorerSourceViewerInformationControl;
import net.sf.colorer.eclipse.editors.DocumentLineSource;
import net.sf.colorer.eclipse.editors.WordWrapAction;
import net.sf.colorer.eclipse.jface.ColorerAnnotationProvider;
import net.sf.colorer.eclipse.jface.ColorerFoldingProvider;
import net.sf.colorer.eclipse.jface.IColorerEditorAdapter;
import net.sf.colorer.eclipse.jface.LineNumberRulerColumn_Fixed;
import net.sf.colorer.eclipse.jface.TextColorer;
import net.sf.colorer.eclipse.outline.ColorerContentOutlinePage;
import net.sf.colorer.eclipse.outline.OutlineSchemeElement;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.editor.OutlineItem;
import net.sf.colorer.impl.CachedBaseEditor;
import net.sf.colorer.impl.Logger;
import net.sf.colorer.swt.ColorManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class ColorerEditor
extends TextEditor
implements IPropertyChangeListener,
IColorerEditorAdapter {
    IPreferenceStore prefStore;
    ColorerSourceViewerConfiguration fColorerSVC;
    StyledText text;
    IDocument fDocument;
    TextColorer fTextColorer;
    BaseEditor fBaseEditor;
    ColorerContentOutlinePage contentOutliner;
    ProjectionSupport fProjectionSupport;
    ColorerFoldingProvider fFoldingProvider;
    ColorerAnnotationProvider fAnnotationProvider = new ColorerAnnotationProvider();
    VerifyListener tabReplacer = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (e.text.equals("\t")) {
                StringBuffer tab = new StringBuffer();
                for (int idx = 0; idx < ColorerEditor.this.text.getTabs(); ++idx) {
                    tab.append(' ');
                }
                e.text = tab.toString();
            }
        }
    };
    IColorerReloadListener fReloadListener = new IColorerReloadListener(){

        public void notifyReload() {
            ColorerEditor.this.detachBaseEditor();
            ColorerEditor.this.relinkColorer();
        }
    };
    static /* synthetic */ Class class$net$sf$colorer$eclipse$ftpp$FileTypePreferencePage;
    static /* synthetic */ Class class$net$sf$colorer$eclipse$PreferencePage;
    static /* synthetic */ Class class$org$eclipse$jface$text$source$ISourceViewer;
    static /* synthetic */ Class class$org$eclipse$jface$text$IDocument;
    static /* synthetic */ Class class$org$eclipse$swt$custom$StyledText;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;

    public ColorerEditor() {
        ColorerPlugin.getDefault().addReloadListener(this.fReloadListener);
        this.prefStore = ColorerPlugin.getDefault().getCombinedPreferenceStore();
        this.prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.fTextColorer = new TextColorer(this);
        this.fColorerSVC = new ColorerSourceViewerConfiguration(this.fTextColorer);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.fColorerSVC);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer).setCursorLinePainterPreferenceKeys(null, null);
        viewer.addProjectionListener(new IProjectionListener(){

            public void projectionEnabled() {
                if (ColorerEditor.this.fFoldingProvider == null) {
                    ColorerEditor.this.fFoldingProvider = new ColorerFoldingProvider();
                    ColorerEditor.this.fFoldingProvider.install(ColorerEditor.this);
                } else {
                    ColorerEditor.this.fFoldingProvider.uninstall();
                    ColorerEditor.this.fFoldingProvider.install(ColorerEditor.this);
                }
                ColorerEditor.this.getAction("org.eclipse.ui.edit.text.folding.toggle").setChecked(true);
                ColorerEditor.this.invalidateSyntax();
            }

            public void projectionDisabled() {
                if (ColorerEditor.this.fFoldingProvider == null) {
                    return;
                }
                ColorerEditor.this.fFoldingProvider.uninstall();
                ColorerEditor.this.fFoldingProvider = null;
                ColorerEditor.this.getAction("org.eclipse.ui.edit.text.folding.toggle").setChecked(false);
            }
        });
        this.fProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new ColorerSourceViewerInformationControl(shell);
            }
        });
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.info");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.task");
        this.fProjectionSupport.install();
        return viewer;
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] preferencePages = super.collectContextMenuPreferencePages();
        String[] extendedPreferencePages = new String[preferencePages.length + 2];
        extendedPreferencePages[0] = (class$net$sf$colorer$eclipse$ftpp$FileTypePreferencePage == null ? (class$net$sf$colorer$eclipse$ftpp$FileTypePreferencePage = ColorerEditor.class$("net.sf.colorer.eclipse.ftpp.FileTypePreferencePage")) : class$net$sf$colorer$eclipse$ftpp$FileTypePreferencePage).getName();
        extendedPreferencePages[1] = (class$net$sf$colorer$eclipse$PreferencePage == null ? (class$net$sf$colorer$eclipse$PreferencePage = ColorerEditor.class$("net.sf.colorer.eclipse.PreferencePage")) : class$net$sf$colorer$eclipse$PreferencePage).getName();
        System.arraycopy(preferencePages, 0, extendedPreferencePages, 2, preferencePages.length);
        return extendedPreferencePages;
    }

    protected void createActions() {
        super.createActions();
        final Shell shell = this.getSourceViewer().getTextWidget().getShell();
        Object action = new ResourceAction(Messages.getResourceBundle(), "Editor.RulerPreferencesAction."){

            public void run() {
                String[] preferencePages = ColorerEditor.this.collectRulerMenuPreferencePages();
                if (!(preferencePages.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePages[0], (String[])preferencePages, (Object)ColorerEditor.this.fTextColorer.getFileType()).open();
                }
            }
        };
        this.setAction("Preferences.RulerAction", (IAction)action);
        action = new TextOperationAction(Messages.getResourceBundle(), "Projection.Toggle.", (ITextEditor)this, 19, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.folding.toggle");
        this.setAction(action.getActionDefinitionId(), (IAction)action);
        action = new TextOperationAction(Messages.getResourceBundle(), "Projection.ExpandAll.", (ITextEditor)this, 20, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand_all");
        this.setAction(action.getActionDefinitionId(), (IAction)action);
        action = new TextOperationAction(Messages.getResourceBundle(), "Projection.CollapseAll.", (ITextEditor)this, 21, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse_all");
        this.setAction(action.getActionDefinitionId(), (IAction)action);
        action = new CollapseCommentsAction(Messages.getResourceBundle(), "Projection.CollapseComments.", this);
        this.setAction(action.getActionDefinitionId(), (IAction)action);
        action = new WordWrapAction(this);
        this.setAction(action.getActionDefinitionId(), (IAction)action);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"net.sf.colorer.eclipse.ColorerScope"});
    }

    public void invalidateSyntax() {
        this.fTextColorer.invalidateSyntax();
    }

    public void relinkColorer() {
        this.fBaseEditor = this.getBaseEditor();
        this.fAnnotationProvider.install(this);
        this.fTextColorer.relink();
        this.fTextColorer.chooseFileType(this.getEditorInput().getToolTipText());
        if (this.contentOutliner != null) {
            this.contentOutliner.attach(this);
        }
        this.propertyChange(null);
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        if (this.prefStore.getBoolean("WordWrapPatch")) {
            return new LineNumberRulerColumn_Fixed();
        }
        return super.createLineNumberRulerColumn();
    }

    protected void editorContextMenuAboutToShow(IMenuManager parentMenu) {
        super.editorContextMenuAboutToShow(parentMenu);
        if (!this.fTextColorer.pairAvailable()) {
            return;
        }
        parentMenu.insertBefore("group.undo", (IContributionItem)new Separator("colorer"));
        this.addAction(parentMenu, "colorer", "net.sf.colorer.eclipse.editors.PairMatchAction");
        this.addAction(parentMenu, "colorer", "net.sf.colorer.eclipse.editors.pairselect");
        this.addAction(parentMenu, "colorer", "net.sf.colorer.eclipse.editors.pairselectcontent");
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingsub = new MenuManager(Messages.get("Projection.Folding.label"));
        menu.insertBefore("settings", (IContributionItem)foldingsub);
        this.addAction((IMenuManager)foldingsub, "org.eclipse.ui.edit.text.folding.toggle");
        this.addAction((IMenuManager)foldingsub, "org.eclipse.ui.edit.text.folding.expand_all");
        this.addAction((IMenuManager)foldingsub, "org.eclipse.ui.edit.text.folding.collapse_all");
        this.addAction((IMenuManager)foldingsub, "net.sf.colorer.eclipse.editors.folding.collapseComments");
        menu.insertBefore("settings", (IContributionItem)new Separator("ww"));
        this.addAction(menu, "ww", "net.sf.colorer.eclipse.editors.WordWrapAction");
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e == null || e.getProperty().equals("USE_BACK") || e.getProperty().equals("HRD_SET") || e.getProperty().startsWith("@@HRD@@")) {
            String hrd = ColorerPlugin.getDefault().getPropertyHRD(this.fTextColorer.getFileType());
            if (hrd == null) {
                hrd = this.prefStore.getString("HRD_SET");
            }
            this.fTextColorer.setRegionMapper(hrd, this.prefStore.getBoolean("USE_BACK"));
        }
        if (e == null || e.getProperty().equals("FULL_BACK")) {
            this.fTextColorer.setFullBackground(this.prefStore.getBoolean("FULL_BACK"));
        }
        if (e == null || e.getProperty().equals("HORZ_CROSS") || e.getProperty().equals("VERT_CROSS")) {
            this.fTextColorer.setCross(this.prefStore.getBoolean("HORZ_CROSS"), this.prefStore.getBoolean("VERT_CROSS"));
        }
        if (e == null || e.getProperty().equals("WORD_WRAP") || e.getProperty().startsWith("@@WORD_WRAP@@")) {
            int ww = ColorerPlugin.getDefault().getPropertyWordWrap(this.fTextColorer.getFileType());
            if (ww == -1) {
                ww = this.prefStore.getBoolean("WORD_WRAP") ? 1 : 0;
            }
            this.text.setWordWrap(ww == 1);
        }
        if ((e == null || e.getProperty().equals("tabWidth")) && this.text.getTabs() != this.prefStore.getInt("tabWidth")) {
            this.text.setTabs(this.prefStore.getInt("tabWidth"));
        }
        if (e == null || e.getProperty().equals("SPACES_FOR_TABS")) {
            if (this.prefStore.getBoolean("SPACES_FOR_TABS")) {
                this.text.addVerifyListener(this.tabReplacer);
            } else {
                this.text.removeVerifyListener(this.tabReplacer);
            }
        }
        if (e == null || e.getProperty().equals("PAIRS_MATCH")) {
            String pairs = this.prefStore.getString("PAIRS_MATCH");
            int pmode = 1;
            if (pairs.equals("PAIRS_OUTLINE")) {
                pmode = 2;
            }
            if (pairs.equals("PAIRS_OUTLINE2")) {
                pmode = 3;
            }
            if (pairs.equals("PAIRS_NO")) {
                pmode = 0;
            }
            if (this.getSourceViewer() instanceof ITextViewerExtension2) {
                this.fTextColorer.setPairsPainter(pmode);
            }
        }
        if (e == null || e.getProperty().equals("net.sf.colorer.eclipse.presentation.textfont")) {
            Font textFont = JFaceResources.getFont((String)"net.sf.colorer.eclipse.presentation.textfont");
            this.text.setFont(textFont);
        }
        if (e == null || e.getProperty().equals("PROJECTION")) {
            if (this.prefStore.getBoolean("PROJECTION")) {
                ((ProjectionViewer)this.getSourceViewer()).enableProjection();
            } else {
                ((ProjectionViewer)this.getSourceViewer()).disableProjection();
            }
        }
        if (e == null || e.getProperty().equals("BACK_SCALE")) {
            int back_scale = this.prefStore.getInt("BACK_SCALE");
            this.fTextColorer.setBackgroundScale(back_scale);
        }
    }

    public Object getAdapter(Class key) {
        Object adapter;
        IEditorInput input;
        if (key.equals(class$org$eclipse$jface$text$source$ISourceViewer == null ? (class$org$eclipse$jface$text$source$ISourceViewer = ColorerEditor.class$("org.eclipse.jface.text.source.ISourceViewer")) : class$org$eclipse$jface$text$source$ISourceViewer)) {
            Assert.isNotNull((Object)this.getSourceViewer());
            return this.getSourceViewer();
        }
        if (key.equals(class$org$eclipse$jface$text$IDocument == null ? (class$org$eclipse$jface$text$IDocument = ColorerEditor.class$("org.eclipse.jface.text.IDocument")) : class$org$eclipse$jface$text$IDocument)) {
            return this.getSourceViewer().getDocument();
        }
        if (key.equals(class$org$eclipse$swt$custom$StyledText == null ? (class$org$eclipse$swt$custom$StyledText = ColorerEditor.class$("org.eclipse.swt.custom.StyledText")) : class$org$eclipse$swt$custom$StyledText)) {
            return this.text;
        }
        if (key.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = ColorerEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage) && (input = this.getEditorInput()) instanceof IStorageEditorInput) {
            if (this.contentOutliner == null) {
                this.contentOutliner = new ColorerContentOutlinePage();
                this.contentOutliner.addSelectionChangedListener(new OutlineSelectionListener());
                this.contentOutliner.attach(this);
            }
            return this.contentOutliner;
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), key)) != null) {
            return adapter;
        }
        return super.getAdapter(key);
    }

    void detachBaseEditor() {
        if (this.contentOutliner != null) {
            this.contentOutliner.detach();
        }
        if (this.fFoldingProvider != null) {
            this.fFoldingProvider.uninstall();
            this.fFoldingProvider = null;
        }
        this.fAnnotationProvider.uninstall();
        this.fBaseEditor.dispose();
        this.fBaseEditor = null;
    }

    public void dispose() {
        this.detachBaseEditor();
        this.prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        ColorerPlugin.getDefault().removeReloadListener(this.fReloadListener);
        super.dispose();
    }

    public BaseEditor getBaseEditor() {
        if (this.fBaseEditor == null) {
            this.fBaseEditor = new CachedBaseEditor(ColorerPlugin.getDefaultPF(), new DocumentLineSource(this.getSourceViewer().getDocument()));
            this.fBaseEditor.setRegionCompact(true);
        }
        return this.fBaseEditor;
    }

    public ColorManager getColorManager() {
        return ColorerPlugin.getDefault().getColorManager();
    }

    public TextColorer getTextColorer() {
        return this.fTextColorer;
    }

    public void handleAttachComplete() {
        this.text = this.getSourceViewer().getTextWidget();
        this.fDocument = this.getSourceViewer().getDocument();
        this.relinkColorer();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class OutlineSelectionListener
    implements ISelectionChangedListener {
        OutlineSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (ColorerEditor.this.fDocument == null || event.getSelection().isEmpty()) {
                return;
            }
            try {
                OutlineItem el = (OutlineItem)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (el instanceof OutlineSchemeElement) {
                    OutlineSchemeElement sel = (OutlineSchemeElement)el;
                    int selstart = ColorerEditor.this.fDocument.getLineOffset(sel.lno) + sel.pos;
                    int selength = ColorerEditor.this.fDocument.getLineOffset(sel.l2no) + sel.pos2 - selstart;
                    if (sel.l2no == 0 && sel.pos2 == 0 || selength <= 0) {
                        selength = 0;
                    }
                    ColorerEditor.this.selectAndReveal(selstart, selength);
                } else {
                    ColorerEditor.this.selectAndReveal(ColorerEditor.this.fDocument.getLineOffset(el.lno) + el.pos, el.length);
                }
            }
            catch (BadLocationException e) {
                Logger.error("ColorerEditor", "doubleClick", e);
            }
        }
    }
}

