/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.editors;

import net.sf.colorer.LineSource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class DocumentLineSource
implements LineSource {
    private IDocument fDocument;

    public DocumentLineSource(IDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("DocumentLineSource: document == null");
        }
        this.fDocument = document;
    }

    public String getLine(int lno) {
        if (this.fDocument.getNumberOfLines() <= lno) {
            return null;
        }
        try {
            IRegion linfo = this.fDocument.getLineInformation(lno);
            String line = this.fDocument.get(linfo.getOffset(), linfo.getLength());
            return line;
        }
        catch (BadLocationException e) {
            return null;
        }
    }
}

