/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.view;

import java.util.Hashtable;
import java.util.Vector;
import net.sf.colorer.HRCParser;
import net.sf.colorer.Region;
import net.sf.colorer.impl.Logger;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class RegionContentProvider
implements ITreeContentProvider {
    HRCParser hp;
    Hashtable children = new Hashtable();

    RegionContentProvider() {
    }

    public void dispose() {
        this.children = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.hp = (HRCParser)newInput;
        this.children.clear();
    }

    public Object[] getElements(Object inputElement) {
        this.children.clear();
        HRCParser hp = (HRCParser)inputElement;
        if (inputElement instanceof HRCParser) {
            Vector<Region> list = new Vector<Region>();
            int idx = 1;
            while (true) {
                Region region = hp.getRegion(idx);
                Logger.trace("RegionsTree", "Region: " + region);
                if (region == null) break;
                if (region.getParent() == null) {
                    list.add(region);
                } else {
                    this.addChild(region.getParent(), region);
                }
                ++idx;
            }
            return list.toArray();
        }
        return null;
    }

    void addChild(Region parent, Region child) {
        Vector<Region> list = (Vector<Region>)this.children.get(parent);
        if (list == null) {
            list = new Vector<Region>();
            this.children.put(parent, list);
        }
        list.add(child);
    }

    public Object[] getChildren(Object parentElement) {
        Vector list = (Vector)this.children.get(parentElement);
        if (list == null) {
            return null;
        }
        return list.toArray();
    }

    public Object getParent(Object element) {
        return ((Region)element).getParent();
    }

    public boolean hasChildren(Object element) {
        Vector list = (Vector)this.children.get(element);
        return list != null;
    }
}

