/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.editor;

import java.util.Vector;
import net.sf.colorer.Region;
import net.sf.colorer.editor.BaseEditor;
import org.eclipse.core.runtime.Assert;

public class DeepLevelCounter {
    private Vector lineVector = new Vector();
    private BaseEditor fBaseEditor;
    private int fDeepLevel;
    private int fMaxDeepLevel = 1;
    private RegionHandler fRegionHandler = new RegionHandler();

    public void install(BaseEditor baseEditor) {
        this.fBaseEditor = baseEditor;
        this.fBaseEditor.addRegionHandler(this.fRegionHandler, this.fBaseEditor.getParserFactory().getHRCParser().getRegion("def:EmbeddedTag"));
        this.fMaxDeepLevel = 1;
    }

    public void uninstall() {
        if (this.fBaseEditor != null) {
            this.fBaseEditor.removeRegionHandler(this.fRegionHandler);
            this.fBaseEditor = null;
        }
    }

    public int getLineDeepLevel(int lineNo) {
        if (lineNo < 0 || lineNo >= this.lineVector.size()) {
            return 0;
        }
        Integer deepLevel = (Integer)this.lineVector.elementAt(lineNo);
        Assert.isNotNull((Object)deepLevel);
        return deepLevel;
    }

    public int getMaxDeepLevel() {
        return this.fMaxDeepLevel;
    }

    private class RegionHandler
    implements net.sf.colorer.RegionHandler {
        private RegionHandler() {
        }

        public void addRegion(int lno, String line, int sx, int ex, Region region) {
        }

        public void clearLine(int lno, String line) {
            this.ensureCapacity(lno);
            DeepLevelCounter.this.lineVector.setElementAt(new Integer(DeepLevelCounter.this.fDeepLevel), lno);
        }

        public void startParsing(int lno) {
            DeepLevelCounter.this.fDeepLevel = 0;
        }

        public void endParsing(int lno) {
            this.ensureCapacity(lno);
        }

        public void enterScheme(int lno, String line, int sx, int ex, Region region, String scheme) {
            this.ensureCapacity(lno);
            DeepLevelCounter.this.fDeepLevel++;
            DeepLevelCounter.this.fMaxDeepLevel = Math.max(DeepLevelCounter.this.fDeepLevel, DeepLevelCounter.this.fMaxDeepLevel);
            if (sx == 0 && ex == 0) {
                return;
            }
            DeepLevelCounter.this.lineVector.setElementAt(new Integer(DeepLevelCounter.this.fDeepLevel), lno);
        }

        public void leaveScheme(int lno, String line, int sx, int ex, Region region, String scheme) {
            this.ensureCapacity(lno);
            DeepLevelCounter.this.fDeepLevel--;
            DeepLevelCounter.this.lineVector.setElementAt(new Integer(DeepLevelCounter.this.fDeepLevel), lno);
        }

        private void ensureCapacity(int lno) {
            int oldSize = DeepLevelCounter.this.lineVector.size();
            if (oldSize <= lno) {
                Integer lastValue = oldSize > 0 ? (Integer)DeepLevelCounter.this.lineVector.lastElement() : new Integer(0);
                DeepLevelCounter.this.lineVector.setSize(lno + 1);
                for (int idx = oldSize; idx < DeepLevelCounter.this.lineVector.size(); ++idx) {
                    DeepLevelCounter.this.lineVector.setElementAt(lastValue, idx);
                }
            }
        }
    }
}

