/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.action;

import java.net.MalformedURLException;
import java.net.URL;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesEditor;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.property.PropertyUtil;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.resources.Messages;
import jp.gr.java_conf.ussiy.app.propedit.util.EncodeChanger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class ShowUnicodeEscAction
implements IEditorActionDelegate {
    private PropertiesEditor textEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof PropertiesEditor) {
            this.textEditor = (PropertiesEditor)targetEditor;
        }
    }

    public void run(IAction action) {
        Shell shell;
        block13: {
            shell = new Shell(this.textEditor.getSite().getShell(), 1264);
            URL url = PropertiesEditorPlugin.getDefault().getBundle().getEntry("/");
            String path = "icons/previewPage.gif";
            ImageDescriptor descriptor = null;
            try {
                descriptor = ImageDescriptor.createFromURL((URL)new URL(url, path));
            }
            catch (MalformedURLException malformedURLException) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            Image image = descriptor.createImage();
            shell.setImage(image);
            shell.setSize(600, 400);
            shell.setLayout((Layout)new FillLayout());
            StyledText text = new StyledText((Composite)shell, 768);
            text.setEditable(false);
            Display display = Display.getCurrent();
            RGB rgb = new RGB(240, 240, 240);
            Color color = new Color((Device)display, rgb);
            text.setBackground(color);
            Font font = this.textEditor.getFont();
            text.setFont(font);
            shell.setText(this.textEditor.getTitle());
            String editorText = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput()).get();
            IProject project = ((IFileEditorInput)this.textEditor.getEditorInput()).getFile().getProject();
            String charcase = PropertyUtil.getCharCase(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("convertCharCase"));
            if (PropertyUtil.getNotAllConvert(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvert"))) {
                text.setText(editorText);
            } else if (PropertyUtil.getNotConvertComment(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvertComment"))) {
                try {
                    if (Messages.getString("eclipse.propertieseditor.preference.convert.char.uppercase").equals(charcase)) {
                        text.setText(EncodeChanger.unicode2UnicodeEscWithoutComment(editorText, 1));
                        break block13;
                    }
                    text.setText(EncodeChanger.unicode2UnicodeEscWithoutComment(editorText, 0));
                }
                catch (Exception e) {
                    Status status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                    ILog log = PropertiesEditorPlugin.getDefault().getLog();
                    log.log((IStatus)status);
                    ErrorDialog.openError(null, (String)Messages.getString("eclipse.propertieseditor.convert.error"), (String)Messages.getString("eclipse.propertieseditor.property.get.settings.error"), (IStatus)status);
                }
            } else {
                try {
                    if (Messages.getString("eclipse.propertieseditor.preference.convert.char.uppercase").equals(charcase)) {
                        text.setText(EncodeChanger.unicode2UnicodeEsc(editorText, 1));
                    } else {
                        text.setText(EncodeChanger.unicode2UnicodeEsc(editorText, 0));
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                    ILog log = PropertiesEditorPlugin.getDefault().getLog();
                    log.log((IStatus)status);
                    ErrorDialog.openError(null, (String)Messages.getString("eclipse.propertieseditor.convert.error"), (String)Messages.getString("eclipse.propertieseditor.property.get.settings.error"), (IStatus)status);
                }
            }
        }
        shell.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

