/*
 * Decompiled with CFR 0.152.
 */
package org.sf.easyexplore;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EasyExplorePlugin
extends AbstractUIPlugin {
    private static EasyExplorePlugin plugin;
    private ResourceBundle resourceBundle;

    public EasyExplorePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.sf.easyexplore.EasyExplorePluginResources");
        }
        catch (MissingResourceException missingResourceException) {}
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static EasyExplorePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = EasyExplorePlugin.getDefault().getResourceBundle();
        String res = null;
        try {
            res = bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            res = key;
        }
        return res;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void log(Object msg) {
        ILog log = EasyExplorePlugin.getDefault().getLog();
        Status status = new Status(1, EasyExplorePlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, msg + "\n", null);
        log.log((IStatus)status);
    }

    public static void log(Throwable ex) {
        ILog log = EasyExplorePlugin.getDefault().getLog();
        StringWriter stringWriter = new StringWriter();
        ex.printStackTrace(new PrintWriter(stringWriter));
        String msg = stringWriter.getBuffer().toString();
        Status status = new Status(4, EasyExplorePlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, msg, null);
        log.log((IStatus)status);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        String osName = System.getProperty("os.name");
        boolean WINDOWS = osName.indexOf("Windows") != -1;
        boolean MAC = osName.indexOf("Mac") != -1;
        String defaultTarget = "shell_open_command {0}";
        if (WINDOWS) {
            defaultTarget = "explorer.exe /n,${.}<>explorer.exe /n,/select,${resource_loc}";
        } else if (MAC) {
            defaultTarget = "open {0}";
        }
        store.setDefault("org.sf.easyexplore.targetPreference", defaultTarget);
        String defaultCommand = "shell_open_command {0}";
        if (WINDOWS) {
            defaultCommand = "cmd /C start cmd /K cd {0}";
        } else if (MAC) {
            defaultCommand = "open {0}";
        }
        store.setDefault("org.sf.easyexplore.commandPreference", defaultCommand);
        String defaultRandom = "Type here your command";
        String defaultRandomTitle = "Title";
        if (WINDOWS) {
            defaultRandom = "\"${env_var:ProgramFiles}\\hidemaru\\hidemaru.exe\" ${resource_loc}";
            defaultRandomTitle = "\u79c0\u4e38";
        } else if (MAC) {
            // empty if block
        }
        store.setDefault("org.sf.easyexplore.randomPreference", defaultRandom);
        store.setDefault("org.sf.easyexplore.randomTitlePreference", defaultRandomTitle);
    }

    public String getTarget() {
        return this.getPreferenceStore().getString("org.sf.easyexplore.targetPreference");
    }

    public String getCommand() {
        return this.getPreferenceStore().getString("org.sf.easyexplore.commandPreference");
    }

    public String getRandom() {
        return this.getPreferenceStore().getString("org.sf.easyexplore.randomPreference");
    }

    public boolean isSupported() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("windows") != -1 || osName.indexOf("mac") != -1;
    }
}

