/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.dialogs.SvnDialog;
import org.tigris.subversion.subclipse.ui.util.UrlCombo;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeDialog
extends SvnDialog {
    private static final int REVISION_WIDTH_HINT = 40;
    private UrlCombo fromUrlCombo;
    private Button fromBrowseButton;
    private Text fromRevisionText;
    private Button fromHeadButton;
    private Button useFromUrlButton;
    private UrlCombo toUrlCombo;
    private Button toBrowseButton;
    private Text toRevisionText;
    private Button toHeadButton;
    private Button ignoreAncestryButton;
    private Button forceButton;
    private Button okButton;
    private Button diffButton;
    private Button dryRunButton;
    private IResource resource;
    private SVNUrl fromUrl;
    private SVNRevision fromRevision;
    private SVNUrl toUrl;
    private SVNRevision toRevision;
    private boolean force;
    private boolean ignoreAncestry;
    private ISVNLocalResource svnResource;
    private File diffFile;
    private File file;
    private ISVNClientAdapter svnClient;

    public MergeDialog(Shell parentShell, IResource resource) {
        super(parentShell, "MergeDialog");
        this.resource = resource;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("MergeDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(Policy.bind("MergeDialog.text"));
        this.svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
        String urlString = null;
        try {
            urlString = this.svnResource.getStatus().getUrlString();
        }
        catch (SVNException sVNException) {}
        Group fromGroup = new Group(composite, 0);
        fromGroup.setText(Policy.bind("MergeDialog.from"));
        GridLayout fromLayout = new GridLayout();
        fromLayout.numColumns = 2;
        fromGroup.setLayout((Layout)fromLayout);
        data = new GridData(1808);
        fromGroup.setLayoutData((Object)data);
        this.fromUrlCombo = new UrlCombo((Composite)fromGroup, 0);
        this.fromUrlCombo.setLayoutData(new GridData(768));
        this.fromUrlCombo.init(this.resource.getProject().getName());
        if (urlString != null) {
            this.fromUrlCombo.setText(urlString);
        }
        this.fromBrowseButton = new Button((Composite)fromGroup, 8);
        this.fromBrowseButton.setText(Policy.bind("SwitchDialog.browse"));
        Composite fromRevisionComposite = new Composite((Composite)fromGroup, 0);
        GridLayout fromRevisionLayout = new GridLayout();
        fromRevisionLayout.numColumns = 3;
        fromRevisionComposite.setLayout((Layout)fromRevisionLayout);
        data = new GridData(1808);
        fromRevisionComposite.setLayoutData((Object)data);
        this.fromHeadButton = new Button(fromRevisionComposite, 32);
        this.fromHeadButton.setText(Policy.bind("MergeDialog.fromHead"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.fromHeadButton.setLayoutData((Object)data);
        Label fromRevisionLabel = new Label(fromRevisionComposite, 0);
        fromRevisionLabel.setText(Policy.bind("MergeDialog.revision"));
        this.fromRevisionText = new Text(fromRevisionComposite, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.fromRevisionText.setLayoutData((Object)data);
        Button fromLogButton = new Button(fromRevisionComposite, 8);
        fromLogButton.setText(Policy.bind("MergeDialog.showLog"));
        fromLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeDialog.this.showLog(MergeDialog.this.fromRevisionText);
            }
        });
        SelectionAdapter fromListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeDialog.this.fromRevisionText.setEnabled(!MergeDialog.this.fromHeadButton.getSelection());
                MergeDialog.this.setOkButtonStatus();
                if (!MergeDialog.this.fromHeadButton.getSelection()) {
                    MergeDialog.this.fromRevisionText.selectAll();
                    MergeDialog.this.fromRevisionText.setFocus();
                }
            }
        };
        this.fromHeadButton.addSelectionListener((SelectionListener)fromListener);
        Group toGroup = new Group(composite, 0);
        toGroup.setText(Policy.bind("MergeDialog.to"));
        GridLayout toLayout = new GridLayout();
        toLayout.numColumns = 2;
        toGroup.setLayout((Layout)toLayout);
        data = new GridData(1808);
        toGroup.setLayoutData((Object)data);
        Composite useFromComposite = new Composite((Composite)toGroup, 0);
        GridLayout useFromLayout = new GridLayout();
        useFromComposite.setLayout((Layout)useFromLayout);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        useFromComposite.setLayoutData((Object)data);
        this.useFromUrlButton = new Button(useFromComposite, 32);
        this.useFromUrlButton.setSelection(true);
        this.useFromUrlButton.setText(Policy.bind("MergeDialog.useFrom"));
        this.toUrlCombo = new UrlCombo((Composite)toGroup, 0);
        this.toUrlCombo.init(this.resource.getProject().getName());
        this.toUrlCombo.setText(this.fromUrlCombo.getText());
        this.toUrlCombo.setLayoutData(new GridData(768));
        this.toUrlCombo.getCombo().setVisible(false);
        this.toBrowseButton = new Button((Composite)toGroup, 8);
        this.toBrowseButton.setText(Policy.bind("MergeDialog.browseTo"));
        this.toBrowseButton.setVisible(false);
        Composite toRevisionComposite = new Composite((Composite)toGroup, 0);
        GridLayout toRevisionLayout = new GridLayout();
        toRevisionLayout.numColumns = 3;
        toRevisionComposite.setLayout((Layout)toRevisionLayout);
        data = new GridData(1808);
        toRevisionComposite.setLayoutData((Object)data);
        this.toHeadButton = new Button(toRevisionComposite, 32);
        this.toHeadButton.setText(Policy.bind("MergeDialog.toHead"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.toHeadButton.setLayoutData((Object)data);
        Label toRevisionLabel = new Label(toRevisionComposite, 0);
        toRevisionLabel.setText(Policy.bind("MergeDialog.toRevision"));
        this.toRevisionText = new Text(toRevisionComposite, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.toRevisionText.setLayoutData((Object)data);
        Button toLogButton = new Button(toRevisionComposite, 8);
        toLogButton.setText(Policy.bind("MergeDialog.showToLog"));
        toLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeDialog.this.showLog(MergeDialog.this.toRevisionText);
            }
        });
        SelectionAdapter toListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeDialog.this.toRevisionText.setEnabled(!MergeDialog.this.toHeadButton.getSelection());
                MergeDialog.this.setOkButtonStatus();
                if (!MergeDialog.this.toHeadButton.getSelection()) {
                    MergeDialog.this.toRevisionText.selectAll();
                    MergeDialog.this.toRevisionText.setFocus();
                }
            }
        };
        this.toHeadButton.addSelectionListener((SelectionListener)toListener);
        SelectionAdapter browseListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUrlDialog dialog = new ChooseUrlDialog(MergeDialog.this.getShell(), MergeDialog.this.resource);
                if (dialog.open() == 0 && dialog.getUrl() != null) {
                    if (e.getSource() == MergeDialog.this.fromBrowseButton) {
                        MergeDialog.this.fromUrlCombo.setText(dialog.getUrl());
                        if (MergeDialog.this.useFromUrlButton.getSelection()) {
                            MergeDialog.this.toUrlCombo.setText(dialog.getUrl());
                        }
                    } else {
                        MergeDialog.this.toUrlCombo.setText(dialog.getUrl());
                    }
                    MergeDialog.this.setOkButtonStatus();
                }
            }
        };
        this.fromBrowseButton.addSelectionListener((SelectionListener)browseListener);
        this.toBrowseButton.addSelectionListener((SelectionListener)browseListener);
        this.useFromUrlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MergeDialog.this.useFromUrlButton.getSelection()) {
                    MergeDialog.this.toUrlCombo.setText(MergeDialog.this.fromUrlCombo.getText());
                }
                MergeDialog.this.toBrowseButton.setVisible(!MergeDialog.this.useFromUrlButton.getSelection());
                MergeDialog.this.toUrlCombo.getCombo().setVisible(!MergeDialog.this.useFromUrlButton.getSelection());
                MergeDialog.this.setOkButtonStatus();
            }
        });
        this.fromUrlCombo.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MergeDialog.this.useFromUrlButton.getSelection()) {
                    MergeDialog.this.toUrlCombo.setText(MergeDialog.this.fromUrlCombo.getText());
                }
            }
        });
        this.fromUrlCombo.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MergeDialog.this.useFromUrlButton.getSelection()) {
                    MergeDialog.this.toUrlCombo.setText(MergeDialog.this.fromUrlCombo.getText());
                }
            }
        });
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MergeDialog.this.setOkButtonStatus();
            }
        };
        this.fromUrlCombo.getCombo().addModifyListener(modifyListener);
        this.fromRevisionText.addModifyListener(modifyListener);
        this.toUrlCombo.getCombo().addModifyListener(modifyListener);
        this.toRevisionText.addModifyListener(modifyListener);
        Composite ignoreComposite = new Composite(composite, 0);
        GridLayout ignoreLayout = new GridLayout();
        ignoreLayout.numColumns = 2;
        ignoreComposite.setLayout((Layout)ignoreLayout);
        data = new GridData(768);
        ignoreComposite.setLayoutData((Object)data);
        this.ignoreAncestryButton = new Button(ignoreComposite, 32);
        this.ignoreAncestryButton.setText(Policy.bind("MergeDialog.ignoreAncestry"));
        this.forceButton = new Button(ignoreComposite, 32);
        this.forceButton.setText(Policy.bind("MergeDialog.force"));
        Group workingGroup = new Group(composite, 0);
        GridLayout workingLayout = new GridLayout();
        workingLayout.numColumns = 2;
        workingGroup.setLayout((Layout)workingLayout);
        data = new GridData(768);
        workingGroup.setLayoutData((Object)data);
        Composite workingComposite = new Composite((Composite)workingGroup, 0);
        workingComposite.setLayout((Layout)new GridLayout());
        data = new GridData(768);
        workingComposite.setLayoutData((Object)data);
        Label workingLabel = new Label(workingComposite, 0);
        workingLabel.setText(Policy.bind("MergeDialog.workingCopy"));
        Text workingText = new Text(workingComposite, 2056);
        data = new GridData(768);
        workingText.setLayoutData((Object)data);
        workingText.setText(this.resource.getLocation().toString());
        Label repositoryLabel = new Label(workingComposite, 0);
        repositoryLabel.setText(Policy.bind("MergeDialog.repositoryUrl"));
        Text repositoryText = new Text(workingComposite, 2056);
        data = new GridData(768);
        repositoryText.setLayoutData((Object)data);
        if (urlString != null) {
            repositoryText.setText(urlString);
        }
        Button workingLogButton = new Button((Composite)workingGroup, 8);
        workingLogButton.setText(Policy.bind("MergeDialog.showWorkingLog"));
        workingLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeDialog.this.showLog(null);
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.fromRevisionText.addFocusListener((FocusListener)focusListener);
        this.toRevisionText.addFocusListener((FocusListener)focusListener);
        this.fromUrlCombo.getCombo().setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.merge_dialog_context");
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.dryRunButton = this.createButton(parent, 2, Policy.bind("MergeDialog.dryRun"), false);
        this.dryRunButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeDialog.this.dryRun();
            }
        });
        this.dryRunButton.setEnabled(false);
        this.diffButton = this.createButton(parent, 3, Policy.bind("MergeDialog.diff"), false);
        this.diffButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeDialog.this.diff();
            }
        });
        this.diffButton.setEnabled(false);
        super.createButtonsForButtonBar(parent);
    }

    private void dryRun() {
        try {
            this.svnClient = this.svnResource.getRepository().getSVNClient();
            this.file = this.resource.getLocation().toFile();
            this.fromUrl = new SVNUrl(this.fromUrlCombo.getText());
            this.toUrl = new SVNUrl(this.toUrlCombo.getText());
            this.fromRevision = this.fromHeadButton.getSelection() ? SVNRevision.HEAD : SVNRevision.getRevision((String)this.fromRevisionText.getText().trim());
            this.toRevision = this.toHeadButton.getSelection() ? SVNRevision.HEAD : SVNRevision.getRevision((String)this.toRevisionText.getText().trim());
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        MergeDialog.this.svnClient.merge(MergeDialog.this.fromUrl, MergeDialog.this.fromRevision, MergeDialog.this.toUrl, MergeDialog.this.toRevision, MergeDialog.this.file, MergeDialog.this.forceButton.getSelection(), true, true, MergeDialog.this.ignoreAncestryButton.getSelection());
                    }
                    catch (SVNClientException e) {
                        MessageDialog.openError((Shell)MergeDialog.this.getShell(), (String)Policy.bind("MergeDialog.dryRun"), (String)e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.dryRun"), (String)e.toString());
        }
    }

    private void diff() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Policy.bind("MergeDialog.diffTitle"));
        String returnFile = dialog.open();
        if (returnFile == null) {
            return;
        }
        this.diffFile = new File(returnFile);
        try {
            this.svnClient = this.svnResource.getRepository().getSVNClient();
            this.fromUrl = new SVNUrl(this.fromUrlCombo.getText());
            this.toUrl = new SVNUrl(this.toUrlCombo.getText());
            this.fromRevision = this.fromHeadButton.getSelection() ? SVNRevision.HEAD : SVNRevision.getRevision((String)this.fromRevisionText.getText().trim());
            this.toRevision = this.toHeadButton.getSelection() ? SVNRevision.HEAD : SVNRevision.getRevision((String)this.toRevisionText.getText().trim());
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        MergeDialog.this.svnClient.diff(MergeDialog.this.fromUrl, MergeDialog.this.fromRevision, MergeDialog.this.toUrl, MergeDialog.this.toRevision, MergeDialog.this.diffFile, true);
                    }
                    catch (SVNClientException e) {
                        MessageDialog.openError((Shell)MergeDialog.this.getShell(), (String)Policy.bind("MergeDialog.diff"), (String)e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.diff"), (String)e.toString());
        }
    }

    private void showLog(Text text) {
        ISVNRemoteFile remoteResource = null;
        if (text == this.fromRevisionText) {
            try {
                this.fromUrl = new SVNUrl(this.fromUrlCombo.getText());
                remoteResource = this.svnResource.getRepository().getRemoteFile(this.fromUrl);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
                return;
            }
            if (remoteResource == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)(String.valueOf(Policy.bind("MergeDialog.urlError")) + " " + this.fromUrlCombo.getText()));
                return;
            }
        }
        if (text == this.toRevisionText) {
            try {
                this.toUrl = new SVNUrl(this.toUrlCombo.getText());
                remoteResource = this.svnResource.getRepository().getRemoteFile(this.toUrl);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
                return;
            }
            if (remoteResource == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)(String.valueOf(Policy.bind("MergeDialog.urlError")) + " " + this.toUrlCombo.getText()));
                return;
            }
        }
        HistoryDialog dialog = null;
        dialog = text == this.fromRevisionText || text == this.toRevisionText ? new HistoryDialog(this.getShell(), (ISVNRemoteResource)remoteResource) : new HistoryDialog(this.getShell(), this.resource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        if (text != null && this.useFromUrlButton.getSelection()) {
            this.fromRevisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber() - 1L));
            this.fromHeadButton.setSelection(false);
            this.toRevisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
            this.toHeadButton.setSelection(false);
            this.fromRevisionText.setEnabled(true);
            this.toRevisionText.setEnabled(true);
            return;
        }
        if (text == this.fromRevisionText || text == null && this.fromRevisionText.getText().trim().length() == 0) {
            this.fromRevisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
            this.fromHeadButton.setSelection(false);
            this.fromRevisionText.setEnabled(true);
        }
        if (text == this.toRevisionText) {
            this.toRevisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
            this.toHeadButton.setSelection(false);
            this.toRevisionText.setEnabled(true);
        }
    }

    protected void okPressed() {
        block11: {
            this.force = this.forceButton.getSelection();
            this.ignoreAncestry = this.ignoreAncestryButton.getSelection();
            this.fromUrlCombo.saveUrl();
            if (!this.toUrlCombo.getText().equals(this.fromUrlCombo.getText())) {
                this.toUrlCombo.saveUrl();
            }
            try {
                this.fromUrl = new SVNUrl(this.fromUrlCombo.getText());
                if (this.fromHeadButton.getSelection()) {
                    this.fromRevision = SVNRevision.HEAD;
                } else {
                    try {
                        this.fromRevision = SVNRevision.getRevision((String)this.fromRevisionText.getText().trim());
                    }
                    catch (ParseException parseException) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.title"), (String)Policy.bind("MergeDialog.invalidFrom"));
                        return;
                    }
                }
                if (this.useFromUrlButton.getSelection()) {
                    this.toUrl = new SVNUrl(this.fromUrlCombo.getText());
                }
                this.toUrl = new SVNUrl(this.toUrlCombo.getText());
                if (this.toHeadButton.getSelection()) {
                    this.toRevision = SVNRevision.HEAD;
                    break block11;
                }
                try {
                    this.toRevision = SVNRevision.getRevision((String)this.toRevisionText.getText().trim());
                }
                catch (ParseException parseException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.title"), (String)Policy.bind("MergeDialog.invalidTo"));
                    return;
                }
            }
            catch (MalformedURLException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.title"), (String)e.getMessage());
                return;
            }
        }
        super.okPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            this.okButton.setText(Policy.bind("MergeDialog.mergeButton"));
            this.okButton.setEnabled(false);
        }
        return button;
    }

    private void setOkButtonStatus() {
        boolean canFinish = true;
        if (!this.fromHeadButton.getSelection() && this.fromRevisionText.getText().trim().length() == 0) {
            canFinish = false;
        } else if (!this.toHeadButton.getSelection() && this.toRevisionText.getText().trim().length() == 0) {
            canFinish = false;
        }
        this.okButton.setEnabled(canFinish);
        this.diffButton.setEnabled(canFinish);
        this.dryRunButton.setEnabled(canFinish);
    }

    public SVNRevision getFromRevision() {
        return this.fromRevision;
    }

    public SVNUrl getFromUrl() {
        return this.fromUrl;
    }

    public SVNRevision getToRevision() {
        return this.toRevision;
    }

    public SVNUrl getToUrl() {
        return this.toUrl;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }
}

