/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbnormalStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadSpelledInfo;
import com.l2jserver.gameserver.network.serverpackets.PartySpelled;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class CharEffectList {
    protected static final Logger _log = Logger.getLogger(CharEffectList.class.getName());
    private static final L2Effect[] EMPTY_EFFECTS = new L2Effect[0];
    public static final int EFFECT_FLAG_CHARM_OF_COURAGE = 1;
    public static final int EFFECT_FLAG_CHARM_OF_LUCK = 2;
    public static final int EFFECT_FLAG_PHOENIX_BLESSING = 4;
    public static final int EFFECT_FLAG_NOBLESS_BLESSING = 8;
    public static final int EFFECT_FLAG_SILENT_MOVE = 16;
    public static final int EFFECT_FLAG_PROTECTION_BLESSING = 32;
    public static final int EFFECT_FLAG_RELAXING = 64;
    public static final int EFFECT_FLAG_FEAR = 128;
    public static final int EFFECT_FLAG_CONFUSED = 256;
    public static final int EFFECT_FLAG_MUTED = 512;
    public static final int EFFECT_FLAG_PSYCHICAL_MUTED = 1024;
    public static final int EFFECT_FLAG_PSYCHICAL_ATTACK_MUTED = 2048;
    public static final int EFFECT_FLAG_DISARMED = 4096;
    public static final int EFFECT_FLAG_ROOTED = 8192;
    public static final int EFFECT_FLAG_SLEEP = 16384;
    public static final int EFFECT_FLAG_STUNNED = 32768;
    public static final int EFFECT_FLAG_BETRAYED = 65536;
    public static final int EFFECT_FLAG_INVUL = 262144;
    public static final int EFFECT_FLAG_PARALYZED = 524288;
    public static final int EFFECT_FLAG_BLOCK_RESURRECTION = 0x100000;
    private FastList<L2Effect> _buffs;
    private FastList<L2Effect> _debuffs;
    private Map<String, List<L2Effect>> _stackedEffects;
    private volatile boolean _hasBuffsRemovedOnAnyAction = false;
    private volatile boolean _hasBuffsRemovedOnDamage = false;
    private volatile boolean _hasDebuffsRemovedOnDamage = false;
    private boolean _queuesInitialized = false;
    private LinkedBlockingQueue<L2Effect> _addQueue;
    private LinkedBlockingQueue<L2Effect> _removeQueue;
    private AtomicBoolean queueLock = new AtomicBoolean();
    private int _effectFlags;
    private boolean _partyOnly = false;
    private L2Character _owner;

    public CharEffectList(L2Character owner) {
        this._owner = owner;
    }

    public final L2Effect[] getAllEffects() {
        if ((this._buffs == null || this._buffs.isEmpty()) && (this._debuffs == null || this._debuffs.isEmpty())) {
            return EMPTY_EFFECTS;
        }
        FastList temp = FastList.newInstance();
        if (this._buffs != null && !this._buffs.isEmpty()) {
            temp.addAll(this._buffs);
        }
        if (this._debuffs != null && !this._debuffs.isEmpty()) {
            temp.addAll(this._debuffs);
        }
        Object[] tempArray = new L2Effect[temp.size()];
        temp.toArray(tempArray);
        FastList.recycle((FastList)temp);
        return tempArray;
    }

    public final L2Effect getFirstEffect(L2EffectType tp) {
        L2Effect effectNotInUse = null;
        if (this._buffs != null && !this._buffs.isEmpty()) {
            for (L2Effect e : this._buffs) {
                if (e == null || e.getEffectType() != tp) continue;
                if (e.getInUse()) {
                    return e;
                }
                effectNotInUse = e;
            }
        }
        if (effectNotInUse == null && this._debuffs != null && !this._debuffs.isEmpty()) {
            for (L2Effect e : this._debuffs) {
                if (e == null || e.getEffectType() != tp) continue;
                if (e.getInUse()) {
                    return e;
                }
                effectNotInUse = e;
            }
        }
        return effectNotInUse;
    }

    public final L2Effect getFirstEffect(L2Skill skill) {
        L2Effect effectNotInUse = null;
        if (skill.isDebuff()) {
            if (this._debuffs == null) {
                return null;
            }
            if (this._debuffs.isEmpty()) {
                return null;
            }
            for (L2Effect e : this._debuffs) {
                if (e == null || e.getSkill() != skill) continue;
                if (e.getInUse()) {
                    return e;
                }
                effectNotInUse = e;
            }
            return effectNotInUse;
        }
        if (this._buffs == null) {
            return null;
        }
        if (this._buffs.isEmpty()) {
            return null;
        }
        for (L2Effect e : this._buffs) {
            if (e == null || e.getSkill() != skill) continue;
            if (e.getInUse()) {
                return e;
            }
            effectNotInUse = e;
        }
        return effectNotInUse;
    }

    public final L2Effect getFirstEffect(int skillId) {
        L2Effect effectNotInUse = null;
        if (this._buffs != null && !this._buffs.isEmpty()) {
            for (L2Effect e : this._buffs) {
                if (e == null || e.getSkill().getId() != skillId) continue;
                if (e.getInUse()) {
                    return e;
                }
                effectNotInUse = e;
            }
        }
        if (effectNotInUse == null && this._debuffs != null && !this._debuffs.isEmpty()) {
            for (L2Effect e : this._debuffs) {
                if (e == null || e.getSkill().getId() != skillId) continue;
                if (e.getInUse()) {
                    return e;
                }
                effectNotInUse = e;
            }
        }
        return effectNotInUse;
    }

    private boolean doesStack(L2Skill checkSkill) {
        if (this._buffs == null || this._buffs.isEmpty() || checkSkill._effectTemplates == null || checkSkill._effectTemplates.length < 1 || checkSkill._effectTemplates[0].abnormalType == null || "none".equals(checkSkill._effectTemplates[0].abnormalType)) {
            return false;
        }
        String stackType = checkSkill._effectTemplates[0].abnormalType;
        for (L2Effect e : this._buffs) {
            if (e.getAbnormalType() == null || !e.getAbnormalType().equals(stackType)) continue;
            return true;
        }
        return false;
    }

    public int getBuffCount() {
        if (this._buffs == null) {
            return 0;
        }
        int buffCount = 0;
        if (this._buffs.isEmpty()) {
            return 0;
        }
        for (L2Effect e : this._buffs) {
            if (e == null || !e.getShowIcon() || e.getSkill().isDance() || e.getSkill().is7Signs()) continue;
            switch (e.getSkill().getSkillType()) {
                case BUFF: 
                case HEAL_PERCENT: 
                case MANAHEAL_PERCENT: {
                    ++buffCount;
                }
            }
        }
        return buffCount;
    }

    public int getDanceCount() {
        if (this._buffs == null) {
            return 0;
        }
        int danceCount = 0;
        if (this._buffs.isEmpty()) {
            return 0;
        }
        for (L2Effect e : this._buffs) {
            if (e == null || !e.getSkill().isDance() || !e.getInUse()) continue;
            ++danceCount;
        }
        return danceCount;
    }

    public final void stopAllEffects() {
        L2Effect[] effects;
        for (L2Effect e : effects = this.getAllEffects()) {
            if (e == null) continue;
            e.exit(true);
        }
    }

    public final void stopAllEffectsExceptThoseThatLastThroughDeath() {
        L2Effect[] effects;
        for (L2Effect e : effects = this.getAllEffects()) {
            if (e == null || e.getSkill().isStayAfterDeath()) continue;
            e.exit(true);
        }
    }

    public void stopAllToggles() {
        if (this._buffs != null && !this._buffs.isEmpty()) {
            for (L2Effect e : this._buffs) {
                if (e == null || !e.getSkill().isToggle()) continue;
                e.exit();
            }
        }
    }

    public final void stopEffects(L2EffectType type) {
        FastList temp = FastList.newInstance();
        if (this._buffs != null && !this._buffs.isEmpty()) {
            for (L2Effect e : this._buffs) {
                if (e == null || e.getEffectType() != type) continue;
                temp.add((Object)e);
            }
        }
        if (this._debuffs != null && !this._debuffs.isEmpty()) {
            for (L2Effect e : this._debuffs) {
                if (e == null || e.getEffectType() != type) continue;
                temp.add((Object)e);
            }
        }
        if (!temp.isEmpty()) {
            for (L2Effect e : temp) {
                if (e == null) continue;
                e.exit();
            }
        }
        FastList.recycle((FastList)temp);
    }

    public final void stopSkillEffects(int skillId) {
        FastList temp = FastList.newInstance();
        if (this._buffs != null && !this._buffs.isEmpty()) {
            for (L2Effect e : this._buffs) {
                if (e == null || e.getSkill().getId() != skillId) continue;
                temp.add((Object)e);
            }
        }
        if (this._debuffs != null && !this._debuffs.isEmpty()) {
            for (L2Effect e : this._debuffs) {
                if (e == null || e.getSkill().getId() != skillId) continue;
                temp.add((Object)e);
            }
        }
        if (!temp.isEmpty()) {
            for (L2Effect e : temp) {
                if (e == null) continue;
                e.exit();
            }
        }
        FastList.recycle((FastList)temp);
    }

    public final void stopSkillEffects(L2SkillType skillType, int negateLvl) {
        FastList temp = FastList.newInstance();
        if (this._buffs != null && !this._buffs.isEmpty()) {
            for (L2Effect e : this._buffs) {
                if (e == null || e.getSkill().getSkillType() != skillType && (e.getSkill().getEffectType() == null || e.getSkill().getEffectType() != skillType) || negateLvl != -1 && (e.getSkill().getEffectType() == null || e.getSkill().getEffectAbnormalLvl() < 0 || e.getSkill().getEffectAbnormalLvl() > negateLvl) && (e.getSkill().getAbnormalLvl() < 0 || e.getSkill().getAbnormalLvl() > negateLvl)) continue;
                temp.add((Object)e);
            }
        }
        if (this._debuffs != null && !this._debuffs.isEmpty()) {
            for (L2Effect e : this._debuffs) {
                if (e == null || e.getSkill().getSkillType() != skillType && (e.getSkill().getEffectType() == null || e.getSkill().getEffectType() != skillType) || negateLvl != -1 && (e.getSkill().getEffectType() == null || e.getSkill().getEffectAbnormalLvl() < 0 || e.getSkill().getEffectAbnormalLvl() > negateLvl) && (e.getSkill().getAbnormalLvl() < 0 || e.getSkill().getAbnormalLvl() > negateLvl)) continue;
                temp.add((Object)e);
            }
        }
        if (!temp.isEmpty()) {
            for (L2Effect e : temp) {
                if (e == null) continue;
                e.exit();
            }
        }
        FastList.recycle((FastList)temp);
    }

    public void stopEffectsOnAction() {
        if (this._hasBuffsRemovedOnAnyAction && this._buffs != null && !this._buffs.isEmpty()) {
            for (L2Effect e : this._buffs) {
                if (e == null || !e.getSkill().isRemovedOnAnyActionExceptMove()) continue;
                e.exit(true);
            }
        }
    }

    public void stopEffectsOnDamage(boolean awake) {
        if (this._hasBuffsRemovedOnDamage && this._buffs != null && !this._buffs.isEmpty()) {
            for (L2Effect e : this._buffs) {
                if (e == null || !e.getSkill().isRemovedOnDamage() || !awake && e.getSkill().getSkillType() == L2SkillType.SLEEP) continue;
                e.exit(true);
            }
        }
        if (this._hasDebuffsRemovedOnDamage && this._debuffs != null && !this._debuffs.isEmpty()) {
            for (L2Effect e : this._debuffs) {
                if (e == null || !e.getSkill().isRemovedOnDamage() || !awake && e.getSkill().getSkillType() == L2SkillType.SLEEP) continue;
                e.exit(true);
            }
        }
    }

    public void updateEffectIcons(boolean partyOnly) {
        if (this._buffs == null && this._debuffs == null) {
            return;
        }
        if (partyOnly) {
            this._partyOnly = true;
        }
        this.queueRunner();
    }

    public void queueEffect(L2Effect effect, boolean remove) {
        if (effect == null) {
            return;
        }
        if (!this._queuesInitialized) {
            this.init();
        }
        if (remove) {
            this._removeQueue.offer(effect);
        } else {
            this._addQueue.offer(effect);
        }
        this.queueRunner();
    }

    private synchronized void init() {
        if (this._queuesInitialized) {
            return;
        }
        this._addQueue = new LinkedBlockingQueue();
        this._removeQueue = new LinkedBlockingQueue();
        this._queuesInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueRunner() {
        if (!this.queueLock.compareAndSet(false, true)) {
            return;
        }
        try {
            while (true) {
                L2Effect effect;
                if ((effect = this._removeQueue.poll()) != null) {
                    this.removeEffectFromQueue(effect);
                    this._partyOnly = false;
                    continue;
                }
                effect = this._addQueue.poll();
                if (effect != null) {
                    this.addEffectFromQueue(effect);
                    this._partyOnly = false;
                }
                if (this._addQueue.isEmpty() && this._removeQueue.isEmpty()) break;
            }
            this.computeEffectFlags();
            this.updateEffectIcons();
        }
        finally {
            this.queueLock.set(false);
        }
    }

    protected void removeEffectFromQueue(L2Effect effect) {
        FastList<L2Effect> effectList;
        if (effect == null) {
            return;
        }
        if (effect.getSkill().isDebuff()) {
            if (this._debuffs == null) {
                return;
            }
            effectList = this._debuffs;
        } else {
            if (this._buffs == null) {
                return;
            }
            effectList = this._buffs;
        }
        if ("none".equals(effect.getAbnormalType())) {
            this._owner.removeStatsOwner(effect);
        } else {
            if (this._stackedEffects == null) {
                return;
            }
            List<L2Effect> stackQueue = this._stackedEffects.get(effect.getAbnormalType());
            if (stackQueue == null || stackQueue.isEmpty()) {
                return;
            }
            int index = stackQueue.indexOf(effect);
            if (index >= 0) {
                stackQueue.remove(effect);
                if (index == 0) {
                    L2Effect newStackedEffect;
                    this._owner.removeStatsOwner(effect);
                    if (!stackQueue.isEmpty() && (newStackedEffect = this.listsContains(stackQueue.get(0))) != null && newStackedEffect.setInUse(true)) {
                        this._owner.addStatFuncs(newStackedEffect.getStatFuncs());
                    }
                }
                if (stackQueue.isEmpty()) {
                    this._stackedEffects.remove(effect.getAbnormalType());
                } else {
                    this._stackedEffects.put(effect.getAbnormalType(), stackQueue);
                }
            }
        }
        if (effectList.remove((Object)effect) && this._owner instanceof L2PcInstance && effect.getShowIcon()) {
            SystemMessage sm = effect.getSkill().isToggle() ? SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_BEEN_ABORTED) : SystemMessage.getSystemMessage(SystemMessageId.EFFECT_S1_DISAPPEARED);
            sm.addSkillName(effect);
            this._owner.sendPacket(sm);
        }
    }

    protected void addEffectFromQueue(L2Effect newEffect) {
        FastList stackQueue;
        if (newEffect == null) {
            return;
        }
        L2Skill newSkill = newEffect.getSkill();
        if (newSkill.isDebuff()) {
            if (this._debuffs == null) {
                this._debuffs = new FastList().shared();
            }
            for (L2Effect e : this._debuffs) {
                if (e == null || e.getSkill().getId() != newEffect.getSkill().getId() || e.getEffectType() != newEffect.getEffectType() || e.getAbnormalLvl() != newEffect.getAbnormalLvl() || !e.getAbnormalType().equals(newEffect.getAbnormalType())) continue;
                newEffect.stopEffectTask();
                return;
            }
            this._debuffs.addLast((Object)newEffect);
        } else {
            if (this._buffs == null) {
                this._buffs = new FastList().shared();
            }
            for (L2Effect e : this._buffs) {
                if (e == null || e.getSkill().getId() != newEffect.getSkill().getId() || e.getEffectType() != newEffect.getEffectType() || e.getAbnormalLvl() != newEffect.getAbnormalLvl() || !e.getAbnormalType().equals(newEffect.getAbnormalType())) continue;
                e.exit();
            }
            if (newEffect.isHerbEffect() && this.getBuffCount() >= this._owner.getMaxBuffCount()) {
                newEffect.stopEffectTask();
                return;
            }
            if (!this.doesStack(newSkill) && !newSkill.is7Signs()) {
                if (newSkill.isDance()) {
                    int effectsToRemove = this.getDanceCount() - Config.DANCES_MAX_AMOUNT;
                    if (effectsToRemove >= 0) {
                        for (L2Effect e : this._buffs) {
                            if (e == null || !e.getSkill().isDance()) continue;
                            e.exit();
                            if (--effectsToRemove >= 0) continue;
                            break;
                        }
                    }
                } else {
                    int effectsToRemove = this.getBuffCount() - this._owner.getMaxBuffCount();
                    if (effectsToRemove >= 0) {
                        block0 : switch (newSkill.getSkillType()) {
                            case BUFF: 
                            case HEAL_PERCENT: 
                            case MANAHEAL_PERCENT: {
                                block9: for (L2Effect e : this._buffs) {
                                    if (e == null || e.getSkill().isDance()) continue;
                                    switch (e.getSkill().getSkillType()) {
                                        case BUFF: 
                                        case HEAL_PERCENT: 
                                        case MANAHEAL_PERCENT: {
                                            e.exit();
                                            break;
                                        }
                                        default: {
                                            continue block9;
                                        }
                                    }
                                    if (--effectsToRemove >= 0) continue;
                                    break block0;
                                }
                                break;
                            }
                        }
                    }
                }
            }
            if (newSkill.isDance()) {
                this._buffs.addLast((Object)newEffect);
            } else {
                int pos = 0;
                if (newSkill.isToggle()) {
                    for (L2Effect e : this._buffs) {
                        if (e == null) continue;
                        if (!e.getSkill().isDance()) {
                            ++pos;
                            continue;
                        }
                        break;
                    }
                } else {
                    for (L2Effect e : this._buffs) {
                        if (e == null) continue;
                        if (!(e.getSkill().isToggle() || e.getSkill().is7Signs() || e.getSkill().isDance())) {
                            ++pos;
                            continue;
                        }
                        break;
                    }
                }
                this._buffs.add(pos, (Object)newEffect);
            }
        }
        if ("none".equals(newEffect.getAbnormalType())) {
            if (newEffect.setInUse(true)) {
                this._owner.addStatFuncs(newEffect.getStatFuncs());
            }
            return;
        }
        L2Effect effectToAdd = null;
        L2Effect effectToRemove = null;
        if (this._stackedEffects == null) {
            this._stackedEffects = new FastMap();
        }
        if ((stackQueue = this._stackedEffects.get(newEffect.getAbnormalType())) != null) {
            int pos = 0;
            if (!stackQueue.isEmpty()) {
                effectToRemove = this.listsContains((L2Effect)stackQueue.get(0));
                Iterator queueIterator = stackQueue.iterator();
                while (queueIterator.hasNext() && newEffect.getAbnormalLvl() < ((L2Effect)queueIterator.next()).getAbnormalLvl()) {
                    ++pos;
                }
                stackQueue.add(pos, newEffect);
                if (Config.EFFECT_CANCELING && !newEffect.isHerbEffect() && stackQueue.size() > 1) {
                    if (newSkill.isDebuff()) {
                        this._debuffs.remove(stackQueue.remove(1));
                    } else {
                        this._buffs.remove(stackQueue.remove(1));
                    }
                }
            } else {
                stackQueue.add(0, newEffect);
            }
        } else {
            stackQueue = new FastList();
            stackQueue.add(0, newEffect);
        }
        this._stackedEffects.put(newEffect.getAbnormalType(), (List<L2Effect>)stackQueue);
        if (!stackQueue.isEmpty()) {
            effectToAdd = this.listsContains((L2Effect)stackQueue.get(0));
        }
        if (effectToRemove != effectToAdd) {
            if (effectToRemove != null) {
                this._owner.removeStatsOwner(effectToRemove);
                effectToRemove.setInUse(false);
            }
            if (effectToAdd != null && effectToAdd.setInUse(true)) {
                this._owner.addStatFuncs(effectToAdd.getStatFuncs());
            }
        }
    }

    protected void updateEffectIcons() {
        OlympiadGameTask game;
        if (this._owner == null) {
            return;
        }
        if (!(this._owner instanceof L2Playable)) {
            this.updateEffectFlags();
            return;
        }
        AbnormalStatusUpdate mi = null;
        PartySpelled ps = null;
        ExOlympiadSpelledInfo os = null;
        if (this._owner instanceof L2PcInstance) {
            if (this._partyOnly) {
                this._partyOnly = false;
            } else {
                mi = new AbnormalStatusUpdate();
            }
            if (this._owner.isInParty()) {
                ps = new PartySpelled(this._owner);
            }
            if (((L2PcInstance)this._owner).isInOlympiadMode() && ((L2PcInstance)this._owner).isOlympiadStart()) {
                os = new ExOlympiadSpelledInfo((L2PcInstance)this._owner);
            }
        } else if (this._owner instanceof L2Summon) {
            ps = new PartySpelled(this._owner);
        }
        boolean foundRemovedOnAction = false;
        boolean foundRemovedOnDamage = false;
        if (this._buffs != null && !this._buffs.isEmpty()) {
            block6: for (L2Effect e : this._buffs) {
                if (e == null) continue;
                if (e.getSkill().isRemovedOnAnyActionExceptMove()) {
                    foundRemovedOnAction = true;
                }
                if (e.getSkill().isRemovedOnDamage()) {
                    foundRemovedOnDamage = true;
                }
                if (!e.getShowIcon()) continue;
                switch (e.getEffectType()) {
                    case CHARGE: 
                    case SIGNET_GROUND: {
                        continue block6;
                    }
                }
                if (!e.getInUse()) continue;
                if (mi != null) {
                    e.addIcon(mi);
                }
                if (ps != null) {
                    e.addPartySpelledIcon(ps);
                }
                if (os == null) continue;
                e.addOlympiadSpelledIcon(os);
            }
        }
        this._hasBuffsRemovedOnAnyAction = foundRemovedOnAction;
        this._hasBuffsRemovedOnDamage = foundRemovedOnDamage;
        foundRemovedOnDamage = false;
        if (this._debuffs != null && !this._debuffs.isEmpty()) {
            block7: for (L2Effect e : this._debuffs) {
                if (e == null) continue;
                if (e.getSkill().isRemovedOnAnyActionExceptMove()) {
                    foundRemovedOnAction = true;
                }
                if (e.getSkill().isRemovedOnDamage()) {
                    foundRemovedOnDamage = true;
                }
                if (!e.getShowIcon()) continue;
                switch (e.getEffectType()) {
                    case SIGNET_GROUND: {
                        continue block7;
                    }
                }
                if (!e.getInUse()) continue;
                if (mi != null) {
                    e.addIcon(mi);
                }
                if (ps != null) {
                    e.addPartySpelledIcon(ps);
                }
                if (os == null) continue;
                e.addOlympiadSpelledIcon(os);
            }
        }
        this._hasDebuffsRemovedOnDamage = foundRemovedOnDamage;
        if (mi != null) {
            this._owner.sendPacket(mi);
        }
        if (ps != null) {
            if (this._owner instanceof L2Summon) {
                L2PcInstance summonOwner = ((L2Summon)this._owner).getOwner();
                if (summonOwner != null) {
                    if (summonOwner.isInParty()) {
                        summonOwner.getParty().broadcastToPartyMembers(ps);
                    } else {
                        summonOwner.sendPacket(ps);
                    }
                }
            } else if (this._owner instanceof L2PcInstance && this._owner.isInParty()) {
                this._owner.getParty().broadcastToPartyMembers(ps);
            }
        }
        if (os != null && (game = OlympiadGameManager.getInstance().getOlympiadTask(((L2PcInstance)this._owner).getOlympiadGameId())) != null && game.isBattleStarted()) {
            game.getZone().broadcastPacketToObservers(os);
        }
    }

    protected void updateEffectFlags() {
        boolean foundRemovedOnAction = false;
        boolean foundRemovedOnDamage = false;
        if (this._buffs != null && !this._buffs.isEmpty()) {
            for (L2Effect e : this._buffs) {
                if (e == null) continue;
                if (e.getSkill().isRemovedOnAnyActionExceptMove()) {
                    foundRemovedOnAction = true;
                }
                if (!e.getSkill().isRemovedOnDamage()) continue;
                foundRemovedOnDamage = true;
            }
        }
        this._hasBuffsRemovedOnAnyAction = foundRemovedOnAction;
        this._hasBuffsRemovedOnDamage = foundRemovedOnDamage;
        foundRemovedOnDamage = false;
        if (this._debuffs != null && !this._debuffs.isEmpty()) {
            for (L2Effect e : this._debuffs) {
                if (e == null || !e.getSkill().isRemovedOnDamage()) continue;
                foundRemovedOnDamage = true;
            }
        }
        this._hasDebuffsRemovedOnDamage = foundRemovedOnDamage;
    }

    private L2Effect listsContains(L2Effect effect) {
        if (this._buffs != null && !this._buffs.isEmpty() && this._buffs.contains((Object)effect)) {
            return effect;
        }
        if (this._debuffs != null && !this._debuffs.isEmpty() && this._debuffs.contains((Object)effect)) {
            return effect;
        }
        return null;
    }

    private final void computeEffectFlags() {
        int flags = 0;
        if (this._buffs != null) {
            for (L2Effect e : this._buffs) {
                if (e == null) continue;
                flags |= e.getEffectFlags();
            }
        }
        if (this._debuffs != null) {
            for (L2Effect e : this._debuffs) {
                if (e == null) continue;
                flags |= e.getEffectFlags();
            }
        }
        this._effectFlags = flags;
    }

    public boolean isAffected(int bitFlag) {
        return (this._effectFlags & bitFlag) != 0;
    }

    public void clear() {
        try {
            if (this._addQueue != null) {
                this._addQueue.clear();
                this._addQueue = null;
            }
            if (this._removeQueue != null) {
                this._removeQueue.clear();
                this._removeQueue = null;
            }
            this._queuesInitialized = false;
            if (this._buffs != null) {
                this._buffs.clear();
                this._buffs = null;
            }
            if (this._debuffs != null) {
                this._debuffs.clear();
                this._debuffs = null;
            }
            if (this._stackedEffects != null) {
                this._stackedEffects.clear();
                this._stackedEffects = null;
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
        }
    }
}

