/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.StringTokenizer;

public class L2FortEnvoyInstance
extends L2Npc {
    public L2FortEnvoyInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
        this.setInstanceType(L2Object.InstanceType.L2FortEnvoyInstance);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = !player.isClanLeader() || player.getClan() == null || this.getFort().getFortId() != player.getClan().getHasFort() ? "data/html/fortress/envoy-noclan.htm" : (this.getFort().getFortState() == 0 ? "data/html/fortress/envoy.htm" : "data/html/fortress/envoy-no.htm");
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%castleName%", CastleManager.getInstance().getCastleById(this.getFort().getCastleIdFromEnvoy(this.getNpcId())).getCastleNameHtm());
        player.sendPacket(html);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        String par = "";
        if (st.countTokens() >= 1) {
            par = st.nextToken();
        }
        if (actualCommand.equalsIgnoreCase("select")) {
            int val = 0;
            try {
                val = Integer.parseInt(par);
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            int castleId = 0;
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            if (val == 2) {
                castleId = this.getFort().getCastleIdFromEnvoy(this.getNpcId());
                if (CastleManager.getInstance().getCastleById(castleId).getOwnerId() < 1) {
                    html.setHtml("<html><body>Contact is currently not possible, " + CastleManager.getInstance().getCastleById(castleId).getCastleNameHtm() + " Castle isn't currently owned by clan.</body></html>");
                    player.sendPacket(html);
                    return;
                }
            }
            this.getFort().setFortState(val, castleId);
            html.setFile(player.getHtmlPrefix(), "data/html/fortress/envoy-ok.htm");
            html.replace((CharSequence)"%castleName%", CastleManager.getInstance().getCastleById(this.getFort().getCastleIdFromEnvoy(this.getNpcId())).getCastleNameHtm());
            player.sendPacket(html);
        } else {
            super.onBypassFeedback(player, command);
        }
    }
}

