/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2PeaceZone;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;

public class L2XmassTreeInstance
extends L2Npc {
    private static final int[][] _buffs = new int[][]{{4262, 2}, {4263, 1}, {4264, 1}, {4265, 3}, {4266, 3}};
    private static final String[] XMASS_SONGS = new String[]{"CC_01", "CC_02", "CC_03", "CC_04", "CC_05", "CC_06"};
    protected ScheduledFuture<?> _aiTask;

    public L2XmassTreeInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2XmassTreeInstance);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (this.getNpcId() == 13007 && ZoneManager.getInstance().getZone(this, L2PeaceZone.class) == null) {
            this._aiTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new XmassAI(this, SkillTable.getInstance().getInfo(2139, 1)), 3000L, 3000L);
            this.broadcastPacket(new PlaySound(1, XMASS_SONGS[Rnd.get(XMASS_SONGS.length)], 0, 0, 0, 0, 0));
        }
    }

    @Override
    public void deleteMe() {
        if (this._aiTask != null) {
            this._aiTask.cancel(true);
        }
        this._aiTask = null;
        super.deleteMe();
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        return 900;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    protected class XmassAI
    implements Runnable {
        protected final L2XmassTreeInstance _caster;
        protected final L2Skill _skill;
        private int _buffIndex = 0;

        protected XmassAI(L2XmassTreeInstance caster, L2Skill skill) {
            this._caster = caster;
            this._skill = skill;
            if (this._skill.getSkillType() == L2SkillType.NOTDONE) {
                throw new RuntimeException();
            }
        }

        @Override
        public void run() {
            Collection<L2PcInstance> plrs = L2XmassTreeInstance.this.getKnownList().getKnownPlayersInRadius(this._skill.getSkillRadius());
            for (L2PcInstance player : plrs) {
                if (player.isInvul() || player.isMovementDisabled() || player.getPkKills() > 5) continue;
                if (player.getCurrentHp() < (double)player.getMaxHp() || player.getCurrentMp() < (double)player.getMaxMp()) {
                    this.handleEffect(player);
                    continue;
                }
                int[] b = _buffs[this._buffIndex];
                this.handleBuff(player, b[0], b[1]);
            }
            this._buffIndex = (this._buffIndex + 1) % _buffs.length;
        }

        protected void handleEffect(L2PcInstance player) {
            L2Skill skill = this._skill;
            if (!this.doesStack(player, skill)) {
                skill.getEffects(player, player);
            }
        }

        protected void handleBuff(L2PcInstance player, int skillId, int skillLevel) {
            L2Skill skill = SkillTable.getInstance().getInfo(skillId, skillLevel);
            if (!this.doesStack(player, skill)) {
                skill.getEffects(this._caster, player);
                player.sendPacket(new MagicSkillUse(this._caster, player, skillId, skillLevel, skill.getHitTime(), 0));
            }
        }

        private boolean doesStack(L2PcInstance player, L2Skill checkSkill) {
            String stackType = checkSkill.getEffectTemplates()[0].abnormalType;
            for (L2Effect e : player.getAllEffects()) {
                if (!stackType.equals(e.getAbnormalType())) continue;
                return true;
            }
            return false;
        }
    }
}

