/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.HeroSkillTable;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.olympiad.CompetitionType;
import com.l2jserver.gameserver.model.olympiad.Participant;
import com.l2jserver.gameserver.model.zone.type.L2OlympiadStadiumZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMode;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractOlympiadGame {
    protected static final Logger _log = Logger.getLogger(AbstractOlympiadGame.class.getName());
    protected static final Logger _logResults = Logger.getLogger("olympiad");
    protected static final String POINTS = "olympiad_points";
    protected static final String COMP_DONE = "competitions_done";
    protected static final String COMP_WON = "competitions_won";
    protected static final String COMP_LOST = "competitions_lost";
    protected static final String COMP_DRAWN = "competitions_drawn";
    protected long _startTime = 0L;
    protected boolean _aborted = false;
    protected final int _stadiumID;

    protected AbstractOlympiadGame(int id) {
        this._stadiumID = id;
    }

    public final boolean isAborted() {
        return this._aborted;
    }

    public final int getStadiumId() {
        return this._stadiumID;
    }

    protected boolean makeCompetitionStart() {
        this._startTime = System.currentTimeMillis();
        return !this._aborted;
    }

    protected final void addPointsToParticipant(Participant par, int points) {
        par.updateStat(POINTS, points);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_GAINED_S2_OLYMPIAD_POINTS);
        sm.addString(par.name);
        sm.addNumber(points);
        this.broadcastPacket(sm);
    }

    protected final void removePointsFromParticipant(Participant par, int points) {
        par.updateStat(POINTS, -points);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_LOST_S2_OLYMPIAD_POINTS);
        sm.addString(par.name);
        sm.addNumber(points);
        this.broadcastPacket(sm);
    }

    protected static SystemMessage checkDefaulted(L2PcInstance player) {
        if (player == null || !player.isOnline()) {
            return SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_ENDS_THE_GAME);
        }
        if (player.getClient() == null || player.getClient().isDetached()) {
            return SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_ENDS_THE_GAME);
        }
        if (player.inObserverMode() || TvTEvent.isPlayerParticipant(player.getObjectId())) {
            return SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_DOES_NOT_MEET_THE_REQUIREMENTS_FOR_JOINING_THE_GAME);
        }
        if (player.isDead()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CANNOT_PARTICIPATE_OLYMPIAD_WHILE_DEAD);
            sm.addPcName(player);
            player.sendPacket(sm);
            return SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_DOES_NOT_MEET_THE_REQUIREMENTS_FOR_JOINING_THE_GAME);
        }
        if (player.isSubClassActive()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_WHILE_CHANGED_TO_SUB_CLASS);
            sm.addPcName(player);
            player.sendPacket(sm);
            return SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_DOES_NOT_MEET_THE_REQUIREMENTS_FOR_JOINING_THE_GAME);
        }
        if (player.isCursedWeaponEquipped()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CANNOT_JOIN_OLYMPIAD_POSSESSING_S2);
            sm.addPcName(player);
            sm.addItemName(player.getCursedWeaponEquippedId());
            player.sendPacket(sm);
            return SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_DOES_NOT_MEET_THE_REQUIREMENTS_FOR_JOINING_THE_GAME);
        }
        if (!player.isInventoryUnder80(true)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_INVENTORY_SLOT_EXCEEDS_80_PERCENT);
            sm.addPcName(player);
            player.sendPacket(sm);
            return SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_DOES_NOT_MEET_THE_REQUIREMENTS_FOR_JOINING_THE_GAME);
        }
        return null;
    }

    protected static final boolean portPlayerToArena(Participant par, Location loc, int id) {
        L2PcInstance player = par.player;
        if (player == null || !player.isOnline()) {
            return false;
        }
        try {
            player.setLastCords(player.getX(), player.getY(), player.getZ());
            if (player.isSitting()) {
                player.standUp();
            }
            player.setTarget(null);
            player.setOlympiadGameId(id);
            player.setIsInOlympiadMode(true);
            player.setIsOlympiadStart(false);
            player.setOlympiadSide(par.side);
            player.olyBuff = 5;
            player.setInstanceId(0);
            player.teleToLocation(loc, false);
            player.sendPacket(new ExOlympiadMode(2));
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
            return false;
        }
        return true;
    }

    protected static final void removals(L2PcInstance player, boolean removeParty) {
        try {
            L2Party party;
            if (player == null) {
                return;
            }
            player.stopAllEffectsExceptThoseThatLastThroughDeath();
            if (player.getClan() != null) {
                player.getClan().removeSkillEffects(player);
                if (player.getClan().getHasCastle() > 0) {
                    CastleManager.getInstance().getCastleByOwner(player.getClan()).removeResidentialSkills(player);
                }
                if (player.getClan().getHasFort() > 0) {
                    FortManager.getInstance().getFortByOwner(player.getClan()).removeResidentialSkills(player);
                }
            }
            player.abortAttack();
            player.abortCast();
            player.getAppearance().setVisible();
            if (player.isHero()) {
                for (L2Skill skill : HeroSkillTable.getHeroSkills()) {
                    player.removeSkill(skill, false);
                }
            }
            player.setCurrentCp(player.getMaxCp());
            player.setCurrentHp(player.getMaxHp());
            player.setCurrentMp(player.getMaxMp());
            L2Summon summon = player.getPet();
            if (summon != null) {
                summon.stopAllEffectsExceptThoseThatLastThroughDeath();
                summon.abortAttack();
                summon.abortCast();
                if (summon instanceof L2PetInstance) {
                    summon.unSummon(player);
                }
            }
            player.stopCubicsByOthers();
            if (removeParty && (party = player.getParty()) != null) {
                party.removePartyMember(player);
            }
            if (player.getAgathionId() > 0) {
                player.setAgathionId(0);
                player.broadcastUserInfo();
            }
            player.checkItemRestriction();
            player.disableAutoShotsAll();
            if (player.getActiveWeaponInstance() != null) {
                player.getActiveWeaponInstance().setChargedSoulshot(0);
                player.getActiveWeaponInstance().setChargedSpiritshot(0);
            }
            for (L2Skill skill : player.getAllSkills()) {
                if (skill.getReuseDelay() > 900000) continue;
                player.enableSkill(skill);
            }
            player.sendSkillList();
            player.sendPacket(new SkillCoolTime(player));
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    protected static final void cleanEffects(L2PcInstance player) {
        try {
            L2Summon summon;
            player.setIsOlympiadStart(false);
            player.setTarget(null);
            player.abortAttack();
            player.abortCast();
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            if (player.isDead()) {
                player.setIsDead(false);
            }
            player.stopAllEffectsExceptThoseThatLastThroughDeath();
            player.clearSouls();
            player.clearCharges();
            if (player.getAgathionId() > 0) {
                player.setAgathionId(0);
            }
            if ((summon = player.getPet()) != null && !summon.isDead()) {
                summon.setTarget(null);
                summon.abortAttack();
                summon.abortCast();
                summon.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                summon.stopAllEffectsExceptThoseThatLastThroughDeath();
            }
            player.setCurrentCp(player.getMaxCp());
            player.setCurrentHp(player.getMaxHp());
            player.setCurrentMp(player.getMaxMp());
            player.getStatus().startHpMpRegeneration();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    protected static final void playerStatusBack(L2PcInstance player) {
        try {
            if (player.isTransformed()) {
                player.untransform();
            }
            player.setIsInOlympiadMode(false);
            player.setIsOlympiadStart(false);
            player.setOlympiadSide(-1);
            player.setOlympiadGameId(-1);
            player.sendPacket(new ExOlympiadMode(0));
            if (player.getClan() != null) {
                player.getClan().addSkillEffects(player);
                if (player.getClan().getHasCastle() > 0) {
                    CastleManager.getInstance().getCastleByOwner(player.getClan()).giveResidentialSkills(player);
                }
                if (player.getClan().getHasFort() > 0) {
                    FortManager.getInstance().getFortByOwner(player.getClan()).giveResidentialSkills(player);
                }
            }
            if (player.isHero()) {
                for (L2Skill skill : HeroSkillTable.getHeroSkills()) {
                    player.addSkill(skill, false);
                }
            }
            player.sendSkillList();
            player.setCurrentCp(player.getMaxCp());
            player.setCurrentHp(player.getMaxHp());
            player.setCurrentMp(player.getMaxMp());
            player.getStatus().startHpMpRegeneration();
            if (Config.L2JMOD_DUALBOX_CHECK_MAX_OLYMPIAD_PARTICIPANTS_PER_IP > 0) {
                AntiFeedManager.getInstance().removePlayer(1, player);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "portPlayersToArena()", e);
        }
    }

    protected static final void portPlayerBack(L2PcInstance player) {
        if (player == null) {
            return;
        }
        if (player.getLastX() == 0 && player.getLastY() == 0) {
            return;
        }
        player.teleToLocation(player.getLastX(), player.getLastY(), player.getLastZ());
        player.setLastCords(0, 0, 0);
    }

    public static final void rewardParticipant(L2PcInstance player, int[][] reward) {
        if (player == null || !player.isOnline() || reward == null) {
            return;
        }
        try {
            InventoryUpdate iu = new InventoryUpdate();
            for (int[] it : reward) {
                L2ItemInstance item;
                if (it == null || it.length != 2 || (item = player.getInventory().addItem("Olympiad", it[0], it[1], player, null)) == null) continue;
                iu.addModifiedItem(item);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
                sm.addItemName(it[0]);
                sm.addNumber(it[1]);
                player.sendPacket(sm);
            }
            player.sendPacket(iu);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public abstract CompetitionType getType();

    public abstract String[] getPlayerNames();

    public abstract boolean containsParticipant(int var1);

    public abstract void sendOlympiadInfo(L2Character var1);

    public abstract void broadcastOlympiadInfo(L2OlympiadStadiumZone var1);

    protected abstract void broadcastPacket(L2GameServerPacket var1);

    protected abstract boolean needBuffers();

    protected abstract boolean checkDefaulted();

    protected abstract void removals();

    protected abstract boolean portPlayersToArena(List<Location> var1);

    protected abstract void cleanEffects();

    protected abstract void portPlayersBack();

    protected abstract void playersStatusBack();

    protected abstract void clearPlayers();

    protected abstract void handleDisconnect(L2PcInstance var1);

    protected abstract void resetDamage();

    protected abstract void addDamage(L2PcInstance var1, int var2);

    protected abstract boolean checkBattleStatus();

    protected abstract boolean haveWinner();

    protected abstract void validateWinner(L2OlympiadStadiumZone var1);

    protected abstract int getDivider();

    protected abstract int[][] getReward();
}

