/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2CastleChamberlainInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;

public class RequestSetSeed
extends L2GameClientPacket {
    private static final String _C__D0_0A_REQUESTSETSEED = "[C] D0:0A RequestSetSeed";
    private static final int BATCH_LENGTH = 20;
    private int _manorId;
    private Seed[] _items = null;

    @Override
    protected void readImpl() {
        this._manorId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 20 != this._buf.remaining()) {
            return;
        }
        this._items = new Seed[count];
        for (int i = 0; i < count; ++i) {
            int itemId = this.readD();
            long sales = this.readQ();
            long price = this.readQ();
            if (itemId < 1 || sales < 0L || price < 0L) {
                this._items = null;
                return;
            }
            this._items[i] = new Seed(itemId, sales, price);
        }
    }

    @Override
    protected void runImpl() {
        if (this._items == null) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null || player.getClan() == null || (player.getClanPrivileges() & 0x20000) == 0) {
            return;
        }
        Castle currentCastle = CastleManager.getInstance().getCastleById(this._manorId);
        if (currentCastle.getOwnerId() != player.getClanId()) {
            return;
        }
        L2Object manager = player.getTarget();
        if (!(manager instanceof L2CastleChamberlainInstance)) {
            manager = player.getLastFolkNPC();
        }
        if (!(manager instanceof L2CastleChamberlainInstance)) {
            return;
        }
        if (((L2CastleChamberlainInstance)manager).getCastle() != currentCastle) {
            return;
        }
        if (!player.isInsideRadius(manager, 150, true, false)) {
            return;
        }
        ArrayList<CastleManorManager.SeedProduction> seeds = new ArrayList<CastleManorManager.SeedProduction>(this._items.length);
        for (Seed i : this._items) {
            CastleManorManager.SeedProduction s = i.getSeed();
            if (s == null) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to overflow while setting manor.", Config.DEFAULT_PUNISH);
                return;
            }
            seeds.add(s);
        }
        currentCastle.setSeedProduction(seeds, 1);
        if (Config.ALT_MANOR_SAVE_ALL_ACTIONS) {
            currentCastle.saveSeedData(1);
        }
    }

    @Override
    public String getType() {
        return _C__D0_0A_REQUESTSETSEED;
    }

    private static class Seed {
        private final int _itemId;
        private final long _sales;
        private final long _price;

        public Seed(int id, long s, long p) {
            this._itemId = id;
            this._sales = s;
            this._price = p;
        }

        public CastleManorManager.SeedProduction getSeed() {
            if (this._sales != 0L && 99900000000L / this._sales < this._price) {
                return null;
            }
            return CastleManorManager.getInstance().getNewSeedProduction(this._itemId, this._sales, this._price, this._sales);
        }
    }
}

