/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills;

import com.l2jserver.gameserver.Item;
import com.l2jserver.gameserver.skills.DocumentBase;
import com.l2jserver.gameserver.skills.conditions.Condition;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.item.L2Item;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import javolution.util.FastList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class DocumentItem
extends DocumentBase {
    private Item _currentItem = null;
    private List<L2Item> _itemsInFile = new FastList();

    public DocumentItem(File file) {
        super(file);
    }

    @Override
    protected StatsSet getStatsSet() {
        return this._currentItem.set;
    }

    @Override
    protected String getTableValue(String name) {
        return ((String[])this._tables.get(name))[this._currentItem.currentLevel];
    }

    @Override
    protected String getTableValue(String name, int idx) {
        return ((String[])this._tables.get(name))[idx - 1];
    }

    @Override
    protected void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"item".equalsIgnoreCase(d.getNodeName())) continue;
                try {
                    this._currentItem = new Item();
                    this.parseItem(d);
                    this._itemsInFile.add(this._currentItem.item);
                    this.resetTable();
                    continue;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Cannot create item " + this._currentItem.id, e);
                }
            }
        }
    }

    protected void parseItem(Node n) throws InvocationTargetException {
        Node first;
        int itemId = Integer.parseInt(n.getAttributes().getNamedItem("id").getNodeValue());
        String className = n.getAttributes().getNamedItem("type").getNodeValue();
        String itemName = n.getAttributes().getNamedItem("name").getNodeValue();
        this._currentItem.id = itemId;
        this._currentItem.name = itemName;
        this._currentItem.type = className;
        this._currentItem.set = new StatsSet();
        this._currentItem.set.set("item_id", itemId);
        this._currentItem.set.set("name", itemName);
        for (n = first = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if ("table".equalsIgnoreCase(n.getNodeName())) {
                if (this._currentItem.item != null) {
                    throw new IllegalStateException("Item created but table node found! Item " + itemId);
                }
                this.parseTable(n);
                continue;
            }
            if ("set".equalsIgnoreCase(n.getNodeName())) {
                if (this._currentItem.item != null) {
                    throw new IllegalStateException("Item created but set node found! Item " + itemId);
                }
                this.parseBeanSet(n, this._currentItem.set, 1);
                continue;
            }
            if ("for".equalsIgnoreCase(n.getNodeName())) {
                this.makeItem();
                this.parseTemplate(n, this._currentItem.item);
                continue;
            }
            if (!"cond".equalsIgnoreCase(n.getNodeName())) continue;
            this.makeItem();
            Condition condition = this.parseCondition(n.getFirstChild(), this._currentItem.item);
            Node msg = n.getAttributes().getNamedItem("msg");
            Node msgId = n.getAttributes().getNamedItem("msgId");
            if (condition != null && msg != null) {
                condition.setMessage(msg.getNodeValue());
            } else if (condition != null && msgId != null) {
                condition.setMessageId(Integer.decode(this.getValue(msgId.getNodeValue(), null)));
                Node addName = n.getAttributes().getNamedItem("addName");
                if (addName != null && Integer.decode(this.getValue(msgId.getNodeValue(), null)) > 0) {
                    condition.addName();
                }
            }
            this._currentItem.item.attach(condition);
        }
        this.makeItem();
    }

    private void makeItem() throws InvocationTargetException {
        if (this._currentItem.item != null) {
            return;
        }
        try {
            Constructor<?> c = Class.forName("com.l2jserver.gameserver.templates.item.L2" + this._currentItem.type).getConstructor(StatsSet.class);
            this._currentItem.item = (L2Item)c.newInstance(this._currentItem.set);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public List<L2Item> getItemList() {
        return this._itemsInFile;
    }
}

