/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.util.IllegalPlayerAction;
import java.io.File;
import javolution.text.TextBuilder;

public final class Util {
    static final double HEADING_PER_DEGREE = 182.04444444444445;

    public static void handleIllegalPlayerAction(L2PcInstance actor, String message, int punishment) {
        ThreadPoolManager.getInstance().scheduleGeneral(new IllegalPlayerAction(actor, message, punishment), 5000L);
    }

    public static String getRelativePath(File base, File file) {
        return file.toURI().getPath().substring(base.toURI().getPath().length());
    }

    public static double calculateAngleFrom(L2Object obj1, L2Object obj2) {
        return Util.calculateAngleFrom(obj1.getX(), obj1.getY(), obj2.getX(), obj2.getY());
    }

    public static final double calculateAngleFrom(int obj1X, int obj1Y, int obj2X, int obj2Y) {
        double angleTarget = Math.toDegrees(Math.atan2(obj2Y - obj1Y, obj2X - obj1X));
        if (angleTarget < 0.0) {
            angleTarget = 360.0 + angleTarget;
        }
        return angleTarget;
    }

    public static final double convertHeadingToDegree(int clientHeading) {
        return (double)clientHeading / 182.04444444444445;
    }

    public static final int convertDegreeToClientHeading(double degree) {
        if (degree < 0.0) {
            degree = 360.0 + degree;
        }
        return (int)(degree * 182.04444444444445);
    }

    public static final int calculateHeadingFrom(L2Object obj1, L2Object obj2) {
        return Util.calculateHeadingFrom(obj1.getX(), obj1.getY(), obj2.getX(), obj2.getY());
    }

    public static final int calculateHeadingFrom(int obj1X, int obj1Y, int obj2X, int obj2Y) {
        double angleTarget = Math.toDegrees(Math.atan2(obj2Y - obj1Y, obj2X - obj1X));
        if (angleTarget < 0.0) {
            angleTarget = 360.0 + angleTarget;
        }
        return (int)(angleTarget * 182.04444444444445);
    }

    public static final int calculateHeadingFrom(double dx, double dy) {
        double angleTarget = Math.toDegrees(Math.atan2(dy, dx));
        if (angleTarget < 0.0) {
            angleTarget = 360.0 + angleTarget;
        }
        return (int)(angleTarget * 182.04444444444445);
    }

    public static double calculateDistance(int x1, int y1, int x2, int y2) {
        return Util.calculateDistance(x1, y1, 0, x2, y2, 0, false);
    }

    public static double calculateDistance(int x1, int y1, int z1, int x2, int y2, int z2, boolean includeZAxis) {
        double dx = (double)x1 - (double)x2;
        double dy = (double)y1 - (double)y2;
        if (includeZAxis) {
            double dz = z1 - z2;
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double calculateDistance(L2Object obj1, L2Object obj2, boolean includeZAxis) {
        if (obj1 == null || obj2 == null) {
            return 1000000.0;
        }
        return Util.calculateDistance(obj1.getPosition().getX(), obj1.getPosition().getY(), obj1.getPosition().getZ(), obj2.getPosition().getX(), obj2.getPosition().getY(), obj2.getPosition().getZ(), includeZAxis);
    }

    public static String capitalizeFirst(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] arr = str.toCharArray();
        char c = arr[0];
        if (Character.isLetter(c)) {
            arr[0] = Character.toUpperCase(c);
        }
        return arr.toString();
    }

    @Deprecated
    public static String capitalizeWords(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] charArray = str.toCharArray();
        String result = "";
        charArray[0] = Character.toUpperCase(charArray[0]);
        for (int i = 0; i < charArray.length; ++i) {
            if (Character.isWhitespace(charArray[i])) {
                charArray[i + 1] = Character.toUpperCase(charArray[i + 1]);
            }
            result = result + Character.toString(charArray[i]);
        }
        return result;
    }

    public static boolean checkIfInRange(int range, L2Object obj1, L2Object obj2, boolean includeZAxis) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.getInstanceId() != obj2.getInstanceId()) {
            return false;
        }
        if (range == -1) {
            return true;
        }
        int rad = 0;
        if (obj1 instanceof L2Character) {
            rad += ((L2Character)obj1).getTemplate().collisionRadius;
        }
        if (obj2 instanceof L2Character) {
            rad += ((L2Character)obj2).getTemplate().collisionRadius;
        }
        double dx = obj1.getX() - obj2.getX();
        double dy = obj1.getY() - obj2.getY();
        if (includeZAxis) {
            double dz = obj1.getZ() - obj2.getZ();
            double d = dx * dx + dy * dy + dz * dz;
            return d <= (double)(range * range + 2 * range * rad + rad * rad);
        }
        double d = dx * dx + dy * dy;
        return d <= (double)(range * range + 2 * range * rad + rad * rad);
    }

    public static boolean checkIfInShortRadius(int radius, L2Object obj1, L2Object obj2, boolean includeZAxis) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (radius == -1) {
            return true;
        }
        int dx = obj1.getX() - obj2.getX();
        int dy = obj1.getY() - obj2.getY();
        if (includeZAxis) {
            int dz = obj1.getZ() - obj2.getZ();
            return dx * dx + dy * dy + dz * dz <= radius * radius;
        }
        return dx * dx + dy * dy <= radius * radius;
    }

    public static int countWords(String str) {
        return str.trim().split("\\s+").length;
    }

    public static String implodeString(Iterable<String> strArray, String strDelim) {
        TextBuilder sbString = TextBuilder.newInstance();
        for (String strValue : strArray) {
            sbString.append(strValue);
            sbString.append(strDelim);
        }
        String result = sbString.toString();
        TextBuilder.recycle((TextBuilder)sbString);
        return result;
    }

    public static float roundTo(float number, int numPlaces) {
        if (numPlaces <= 1) {
            return Math.round(number);
        }
        float exponent = (float)Math.pow(10.0, numPlaces);
        return (float)Math.round(number * exponent) / exponent;
    }

    public static boolean isDigit(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        for (char c : text.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        for (char c : text.toCharArray()) {
            if (Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String formatAdena(long amount) {
        String s = "";
        long rem = amount % 1000L;
        s = Long.toString(rem);
        amount = (amount - rem) / 1000L;
        while (amount > 0L) {
            if (rem < 99L) {
                s = '0' + s;
            }
            if (rem < 9L) {
                s = '0' + s;
            }
            rem = amount % 1000L;
            s = Long.toString(rem) + "," + s;
            amount = (amount - rem) / 1000L;
        }
        return s;
    }

    public static String formatAdenaK(long amount) {
        String u;
        long a = amount / 1000000000L;
        if (a != 0L && amount % 100000000L == 0L) {
            u = "G";
        } else {
            a = amount / 1000000L;
            if (a != 0L && amount % 100000L == 0L) {
                u = "M";
            } else {
                a = amount / 1000L;
                if (a != 0L && amount % 1000L == 0L) {
                    u = "K";
                } else {
                    a = amount;
                    u = "";
                }
            }
        }
        return Util.formatAdena(a) + u;
    }

    public static int calcCameraAngle(L2Character target) {
        return (540 - (int)Math.round(Util.convertHeadingToDegree(target.getHeading()))) % 360;
    }

    public static <T> boolean contains(T[] array, T obj) {
        for (T element : array) {
            if (element != obj) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int obj) {
        for (int element : array) {
            if (element != obj) continue;
            return true;
        }
        return false;
    }
}

